/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.exceptions.OkapiException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ModelMapUtil {
    private final JSONParser parser = new JSONParser();
    private Map<String, String> map = new HashMap<String, String>();

    public void setMap(String modelMap) {
        try {
            this.map = new HashMap<String, String>();
            JSONObject obj = (JSONObject)this.parser.parse(modelMap);
            for (String key : obj.keySet()) {
                String model = (String)obj.get((Object)key);
                this.map.put(key.toLowerCase(), model);
            }
        }
        catch (ParseException e) {
            throw new OkapiException("Error setting the Model map: ", e);
        }
    }

    public String getModelResourceName(String sourceCode, String targetCode) {
        String languagePair = (sourceCode + "/" + targetCode).toLowerCase();
        String model = this.map.get(languagePair);
        if (model == null) {
            throw new OkapiException("Model map does not contain language pair " + languagePair);
        }
        return model;
    }
}

