/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters.fontmappings;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.okapi.common.LocalePair;
import net.sf.okapi.common.filters.fontmappings.FontMapping;
import net.sf.okapi.common.filters.fontmappings.FontMappings;

public final class DefaultFontMappings
implements FontMappings {
    private final List<FontMapping> mappings;

    public DefaultFontMappings(FontMapping ... mappings) {
        this(new LinkedList<FontMapping>(Arrays.asList(mappings)));
    }

    public DefaultFontMappings(List<FontMapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public FontMappings applicableTo(LocalePair pair) {
        return new DefaultFontMappings(this.mappings.stream().filter(m -> m.applicableTo(pair)).collect(Collectors.toList()));
    }

    @Override
    public String targetFontFor(String sourceFont) {
        String font = sourceFont;
        for (FontMapping fontMapping : this.mappings) {
            if (!fontMapping.applicableTo(font)) continue;
            font = fontMapping.targetFont();
        }
        return font;
    }

    @Override
    public void addFrom(FontMappings.Input input) {
        Iterator<FontMapping> iterator = input.read();
        while (iterator.hasNext()) {
            this.mappings.add(iterator.next());
        }
    }

    @Override
    public <T> T writtenTo(FontMappings.Output<T> output) {
        return output.writtenWith(this.mappings.iterator());
    }
}

