/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.virtualdb.jdbc.h2;

import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.virtualdb.IVDocument;
import net.sf.okapi.virtualdb.IVItem;
import net.sf.okapi.virtualdb.IVTextUnit;
import net.sf.okapi.virtualdb.jdbc.h2.H2Document;

public class H2TextUnit
implements IVTextUnit {
    private long itemKey;
    private H2Document doc;
    private long parent;
    private long previous;
    private long next;
    private ITextUnit tu;

    public H2TextUnit(long itemKey, H2Document doc, String id, String name, String type) {
        this.tu = new TextUnit(id);
        this.itemKey = itemKey;
        this.doc = doc;
        this.tu.setName(name);
        this.tu.setType(type);
    }

    void fillPointers(long parent, long previous, long next) {
        this.parent = parent;
        this.previous = previous;
        this.next = next;
    }

    void setTextUnit(ITextUnit tu) {
        this.tu = tu;
    }

    @Override
    public ITextUnit getTextUnit() {
        return this.tu;
    }

    @Override
    public IVDocument getDocument() {
        return this.doc;
    }

    @Override
    public IVItem getParent() {
        return this.doc.db.getItemFromItemKey(this.doc, this.parent);
    }

    @Override
    public IVItem getNextSibling() {
        return this.doc.db.getItemFromItemKey(this.doc, this.next);
    }

    @Override
    public IVItem getPreviousSibling() {
        return this.doc.db.getItemFromItemKey(this.doc, this.previous);
    }

    @Override
    public IVItem getFirstChild() {
        return null;
    }

    @Override
    public void save() {
        this.doc.db.saveTextUnit(this);
    }

    @Override
    public IVItem.ItemType getItemType() {
        return IVItem.ItemType.TEXT_UNIT;
    }

    @Override
    public String getId() {
        return this.tu.getId();
    }

    @Override
    public String getName() {
        return this.tu.getName();
    }

    @Override
    public String getType() {
        return this.tu.getType();
    }

    @Override
    public long getKey() {
        return this.itemKey;
    }
}

