/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized.gmx;

import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.steps.wordcount.categorized.CategoryGroup;
import net.sf.okapi.steps.wordcount.categorized.CategoryHandler;
import net.sf.okapi.steps.wordcount.common.AltAnnotationBasedCountStep;

public class GMXExactMatchedWordCountStep
extends AltAnnotationBasedCountStep
implements CategoryHandler {
    public static final String METRIC = "ExactMatchedWordCount";

    @Override
    public String getMetric() {
        return METRIC;
    }

    @Override
    public String getDescription() {
        return "An accumulation of the word count for text units that have been matched unambiguously with a prior translation and thus require no translator input. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "GMX Exact Matched Word Count";
    }

    @Override
    protected boolean accept(MatchType type) {
        return type == MatchType.EXACT_UNIQUE_ID || type == MatchType.EXACT_PREVIOUS_VERSION;
    }

    @Override
    public CategoryGroup getCategoryGroup() {
        return CategoryGroup.GMX_WORD_COUNTS;
    }
}

