/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.whitespacecorrection;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrectionStepParameters;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrector;

@UsingParameters(value=WhitespaceCorrectionStepParameters.class)
public class WhitespaceCorrectionStep
extends BasePipelineStep {
    protected LocaleId sourceLocale;
    protected LocaleId targetLocale;
    private WhitespaceCorrectionStepParameters params = new WhitespaceCorrectionStepParameters();

    @Override
    public String getName() {
        return "Whitespace Correction";
    }

    @Override
    public String getDescription() {
        return "Correct whitespace following segment-ending punctuation when translating from  a space-delimited language (such as English) to a non-space-delimited language (Chinese or Japanese), or vice-versa. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public WhitespaceCorrectionStepParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (WhitespaceCorrectionStepParameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        new WhitespaceCorrector(this.sourceLocale, this.targetLocale, this.getParameters().getPunctuation(), this.getParameters().getWhitespace()).correctWhitespace(event.getTextUnit());
        return event;
    }
}

