/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.steps.ttxsplitter.TTXSplitterParameters;
import net.sf.okapi.steps.ttxsplitter.WordCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTXSplitter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TTXSplitterParameters params;
    private String srcLang;
    private WordCounter counter;
    private long wordCount;
    private long partWC;
    private XMLEventReader reader;
    private int outputState;
    private XMLOutputFactory outFact;
    private XMLEventFactory evtFact;
    private XMLEventWriter writer;
    private int part;
    private String outputPath;
    private Stack<XMLEvent> topStack;
    private Stack<XMLEvent> stack;
    private int level;
    private ArrayList<XMLEvent> endEvents;

    public TTXSplitter(TTXSplitterParameters params) {
        this.params = params;
    }

    public void initialize(String srcLang) {
        this.srcLang = srcLang;
        this.counter = new WordCounter(LocaleId.fromString(srcLang));
    }

    public void split(URI inputURI) {
        try {
            this.outputState = -1;
            this.process(inputURI);
            if (this.wordCount <= (long)this.params.getPartCount()) {
                this.logger.warn("Word count for this document is {} (less than the {} files requested): No split was perfomed.", (Object)this.wordCount, (Object)this.params.getPartCount());
                return;
            }
            this.partWC = this.wordCount / (long)this.params.getPartCount();
            this.logger.info("Word count = {}: {} files of about {} words each.", new Object[]{this.wordCount, this.params.getPartCount(), this.partWC});
            this.outputState = 0;
            this.part = 0;
            this.outputPath = new File(inputURI).getAbsolutePath();
            this.stack = new Stack();
            this.topStack = new Stack();
            this.process(inputURI);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.logger.error("Could not split the TTX document:\n{}", (Object)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(URI inputURI) throws XMLStreamException, MalformedURLException, IOException {
        try {
            XMLInputFactory inpFact = XMLInputFactory.newInstance();
            inpFact.setProperty("javax.xml.stream.isCoalescing", true);
            inpFact.setProperty("javax.xml.stream.supportDTD", false);
            StreamSource source = new StreamSource(new BufferedInputStream(inputURI.toURL().openStream()));
            this.reader = inpFact.createXMLEventReader(source);
            if (this.outputState > -1) {
                this.outFact = XMLOutputFactory.newInstance();
                this.evtFact = XMLEventFactory.newInstance();
                this.endEvents = new ArrayList();
                this.endEvents.add(this.evtFact.createEndElement(new QName("", "Raw"), null));
                this.endEvents.add(this.evtFact.createEndElement(new QName("", "Body"), null));
                this.endEvents.add(this.evtFact.createEndElement(new QName("", "TRADOStag"), null));
            }
            this.level = 0;
            this.wordCount = 0L;
            boolean inText = false;
            boolean skip = false;
            StringBuilder sb = new StringBuilder();
            block22: while (this.reader.hasNext()) {
                XMLEvent event = this.reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        ++this.level;
                        StartElement elem = event.asStartElement();
                        switch (elem.getName().getLocalPart()) {
                            case "Tuv": {
                                String lang = this.getAttributeValue(elem, "Lang");
                                if (this.srcLang.equals(lang)) {
                                    skip = false;
                                    break;
                                }
                                skip = true;
                                break;
                            }
                            case "UserSettings": {
                                this.initialize(this.getAttributeValue(elem, "SourceLanguage"));
                                break;
                            }
                            case "ut": {
                                if (this.writer != null) {
                                    this.writer.add(event);
                                }
                                this.skipElement("ut");
                                --this.level;
                                continue block22;
                            }
                            case "Raw": {
                                inText = true;
                                if (this.outputState == 0) {
                                    this.topStack.push(event);
                                    this.outputState = 1;
                                }
                                if (this.outputState <= -1) break;
                                this.startNewOutput();
                                continue block22;
                            }
                            case "df": {
                                if (this.writer == null) break;
                                this.stack.push(event);
                            }
                        }
                        break;
                    }
                    case 2: {
                        --this.level;
                        String name = event.asEndElement().getName().getLocalPart();
                        if (name.equals("df") && this.writer != null) {
                            this.stack.pop();
                        }
                        if (this.level != 3 || !inText) break;
                        if (sb.length() > 0) {
                            this.wordCount += this.counter.getWordCount(sb.toString());
                            sb.setLength(0);
                        }
                        if (this.wordCount < this.partWC || this.writer == null || this.part >= this.params.getPartCount()) break;
                        this.writer.add(event);
                        this.endOutput();
                        this.startNewOutput();
                        continue block22;
                    }
                    case 4: {
                        if (!inText || skip) break;
                        sb.append(event.asCharacters().getData());
                    }
                }
                if (this.outputState == 0) {
                    this.topStack.push(event);
                }
                if (this.writer == null) continue;
                this.writer.add(event);
            }
        }
        finally {
            this.close();
        }
    }

    private String getAttributeValue(StartElement elem, String name) {
        Attribute attr = elem.getAttributeByName(new QName("", name));
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    private void endOutput() throws XMLStreamException {
        if (this.writer != null) {
            if (!this.stack.isEmpty()) {
                for (int i = 0; i < this.stack.size(); ++i) {
                    EndElement endElement = this.evtFact.createEndElement(new QName("", "df"), null);
                    this.writer.add(endElement);
                }
            }
            if (this.part < this.params.getPartCount()) {
                for (XMLEvent xMLEvent : this.endEvents) {
                    this.writer.add(xMLEvent);
                }
            }
            this.writer.close();
            this.writer = null;
            this.logger.info("Part {} has {} words.", (Object)String.format("%03d", this.part), (Object)this.wordCount);
        }
    }

    private void startNewOutput() throws XMLStreamException, IOException {
        int i;
        this.wordCount = 0L;
        ++this.part;
        String mark = String.format("_part%03d", this.part);
        FileOutputStream fos = new FileOutputStream(this.outputPath.replace(".ttx", mark + ".ttx"));
        this.writer = this.outFact.createXMLEventWriter(fos, "UTF-8");
        for (i = 0; i < this.topStack.size(); ++i) {
            this.writer.add((XMLEvent)this.topStack.elementAt(i));
        }
        for (i = 0; i < this.stack.size(); ++i) {
            this.writer.add((XMLEvent)this.stack.elementAt(i));
        }
    }

    private void close() throws XMLStreamException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.endOutput();
    }

    private void skipElement(String name) throws XMLStreamException {
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            if (this.writer != null) {
                this.writer.add(event);
            }
            switch (event.getEventType()) {
                case 2: {
                    if (!name.equals(event.asEndElement().getName().getLocalPart())) break;
                    return;
                }
            }
        }
    }
}

