/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.searchandreplace;

import java.util.ArrayList;
import net.sf.okapi.common.StringParameters;

public class Parameters
extends StringParameters {
    private static final String REGEX = "regEx";
    private static final String DOTALL = "dotAll";
    private static final String IGNORECASE = "ignoreCase";
    private static final String MULTILINE = "multiLine";
    private static final String TARGET = "target";
    private static final String SOURCE = "source";
    private static final String REPLACEALL = "replaceALL";
    private static final String COUNT = "count";
    private static final String REPLACEMENTSPATH = "replacementsPath";
    private static final String LOGPATH = "logPath";
    private static final String SAVELOG = "saveLog";
    public ArrayList<String[]> rules;

    public boolean getRegEx() {
        return this.getBoolean(REGEX);
    }

    public void setRegEx(boolean regEx) {
        this.setBoolean(REGEX, regEx);
    }

    public boolean getDotAll() {
        return this.getBoolean(DOTALL);
    }

    public void setDotAll(boolean dotAll) {
        this.setBoolean(DOTALL, dotAll);
    }

    public boolean getIgnoreCase() {
        return this.getBoolean(IGNORECASE);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.setBoolean(IGNORECASE, ignoreCase);
    }

    public boolean getMultiLine() {
        return this.getBoolean(MULTILINE);
    }

    public void setMultiLine(boolean multiLine) {
        this.setBoolean(MULTILINE, multiLine);
    }

    public boolean getTarget() {
        return this.getBoolean(TARGET);
    }

    public void setTarget(boolean target) {
        this.setBoolean(TARGET, target);
    }

    public boolean getSource() {
        return this.getBoolean(SOURCE);
    }

    public void setSource(boolean source) {
        this.setBoolean(SOURCE, source);
    }

    public boolean getReplaceAll() {
        return this.getBoolean(REPLACEALL);
    }

    public void setReplaceAll(boolean replaceAll) {
        this.setBoolean(REPLACEALL, replaceAll);
    }

    public String getReplacementsPath() {
        return this.getString(REPLACEMENTSPATH);
    }

    public void setReplacementsPath(String replacementsPath) {
        this.setString(REPLACEMENTSPATH, replacementsPath);
    }

    public String getLogPath() {
        return this.getString(LOGPATH);
    }

    public void setLogPath(String logPath) {
        this.setString(LOGPATH, logPath);
    }

    public boolean getSaveLog() {
        return this.getBoolean(SAVELOG);
    }

    public void setSaveLog(boolean saveLog) {
        this.setBoolean(SAVELOG, saveLog);
    }

    public void setRules(ArrayList<String[]> rules) {
        this.rules = rules;
    }

    @Override
    public void reset() {
        super.reset();
        this.setRegEx(false);
        this.setDotAll(false);
        this.setIgnoreCase(false);
        this.setMultiLine(false);
        this.setTarget(true);
        this.setSource(false);
        this.setReplaceAll(true);
        this.setReplacementsPath("");
        this.setLogPath("${rootDir}/replacementsLog.txt");
        this.setSaveLog(false);
        this.rules = new ArrayList();
    }

    public void addRule(String[] pattern) {
        this.rules.add(pattern);
    }

    public ArrayList<String[]> getRules() {
        return this.rules;
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        int count = this.buffer.getInteger(COUNT, 0);
        for (int i = 0; i < count; ++i) {
            String[] s = new String[]{this.buffer.getString(String.format("use%d", i), ""), this.buffer.getString(String.format("search%d", i), ""), this.buffer.getString(String.format("replace%d", i), "")};
            this.rules.add(s);
        }
    }

    @Override
    public String toString() {
        this.buffer.setInteger(COUNT, this.rules.size());
        int i = 0;
        for (String[] temp : this.rules) {
            this.buffer.setString(String.format("use%d", i), temp[0]);
            this.buffer.setString(String.format("search%d", i), temp[1]);
            this.buffer.setString(String.format("replace%d", i), temp[2]);
            ++i;
        }
        return this.buffer.toString();
    }
}

