/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.lengthchecker;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.LengthChecker;
import net.sf.okapi.steps.lengthchecker.Parameters;

@UsingParameters(value=Parameters.class)
public class LengthCheckerStep
extends BasePipelineStep {
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private LengthChecker lengthChecker = new LengthChecker();
    private Parameters params = new Parameters();
    private net.sf.okapi.lib.verification.Parameters fullParams = new net.sf.okapi.lib.verification.Parameters();

    @Override
    public String getName() {
        return "Length Quality Check";
    }

    @Override
    public String getDescription() {
        return "Compare source and target lengths and annotate those that seem mismatched. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.fullParams.fromString(this.params.toString());
        this.lengthChecker.startProcess(this.sourceLocale, this.targetLocale, this.fullParams, new ArrayList<Issue>());
        return event;
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        this.lengthChecker.processStartSubDocument(event.getStartSubDocument());
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        this.lengthChecker.processStartDocument((StartDocument)event.getResource(), null);
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.lengthChecker.processTextUnit(event.getTextUnit());
        return event;
    }

    protected List<Issue> getIssues() {
        return this.lengthChecker.getIssues();
    }
}

