/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.gcaligner;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.steps.gcaligner.DpFunction;
import net.sf.okapi.steps.gcaligner.DpMatrixCell;

public class DpMatrix<T> {
    private DpMatrixCell[][] m_matrix;
    private List<T> sequenceX;
    private List<T> sequenceY;
    private DpFunction<T> m_dpFunction;

    public DpMatrix(List<T> sequenceX, List<T> sequenceY, DpFunction<T> p_dpFunction) {
        this.sequenceX = sequenceX;
        this.sequenceY = sequenceY;
        this.m_dpFunction = p_dpFunction;
        this.m_matrix = new DpMatrixCell[sequenceX.size() + 1][sequenceY.size() + 1];
        this.initMatrix();
    }

    public List<DpMatrixCell> align() {
        this.fillMatrix();
        return this.alignedResult();
    }

    public T getAlignmentElementX(int p_xIdx) {
        return this.sequenceX.get(p_xIdx - 1);
    }

    public T getAlignmentElementY(int p_yIdx) {
        return this.sequenceY.get(p_yIdx - 1);
    }

    public List<T> getAlignmentElementsX(int p_xFromIdx, int p_xToIdx) {
        return new ArrayList<T>(this.sequenceX.subList(p_xFromIdx - 1, p_xToIdx - 1));
    }

    public List<T> getAlignmentElementsY(int p_yFromIdx, int p_yToIdx) {
        return new ArrayList<T>(this.sequenceY.subList(p_yFromIdx - 1, p_yToIdx - 1));
    }

    public DpMatrixCell getCell(int p_xIdx, int p_yIdx) {
        return this.m_matrix[p_xIdx][p_yIdx];
    }

    private void initMatrix() {
        for (int x = 0; x < this.m_matrix.length; ++x) {
            for (int y = 0; y < this.m_matrix[x].length; ++y) {
                this.m_matrix[x][y] = new DpMatrixCell(x, y);
            }
        }
    }

    private void fillMatrix() {
        for (int x = 0; x < this.m_matrix.length; ++x) {
            for (int y = 0; y < this.m_matrix[x].length; ++y) {
                this.m_dpFunction.setCellScore(x, y, this);
            }
        }
    }

    private List<DpMatrixCell> alignedResult() {
        LinkedList<DpMatrixCell> result = new LinkedList<DpMatrixCell>();
        DpMatrixCell cell = this.m_matrix[this.sequenceX.size()][this.sequenceY.size()];
        while (cell.hasNext()) {
            result.addFirst(cell);
            cell = cell.nextCell();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int y = 0; y < this.m_matrix[0].length; ++y) {
            for (int x = 0; x < this.m_matrix.length; ++x) {
                if (x == 0) {
                    sb.append("\r\n");
                }
                DpMatrixCell cell = this.m_matrix[x][y];
                sb.append(cell.getScore()).append("\t");
            }
        }
        return sb.toString();
    }
}

