/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.externalcommand;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String COMMAND = "command";
    private static final String TIMEOUT = "timeout";

    public String getCommand() {
        return this.getString(COMMAND);
    }

    public void setCommand(String command) {
        this.setString(COMMAND, command);
    }

    public int getTimeout() {
        return this.getInteger(TIMEOUT);
    }

    public void setTimeout(int timeout) {
        this.setInteger(TIMEOUT, timeout);
    }

    @Override
    public void reset() {
        super.reset();
        this.setCommand("");
        this.setTimeout(-1);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(COMMAND, "Command line", "Command path to execute");
        desc.add(TIMEOUT, "Timeout", "Timeout in seconds after which the command is cancelled (use -1 for no timeout)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("External Command", true, false);
        desc.addTextInputPart(paramsDesc.get(COMMAND));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(TIMEOUT));
        tip.setVertical(false);
        return desc;
    }
}

