/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.diffleverage;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String FUZZYTHRESHOLD = "fuzzyThreshold";
    private static final String CODESENSITIVE = "codesensitive";
    private static final String DIFFONLY = "diffOnly";
    private static final String COPYTOTARGET = "copyToTarget";

    @Override
    public void reset() {
        super.reset();
        this.setFuzzyThreshold(100);
        this.setCodesensitive(true);
        this.setDiffOnly(false);
        this.setCopyToTarget(false);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(FUZZYTHRESHOLD, "Leverage only if the match is equal or above this score", "Fuzzy Thresholds are between 1 and 100. A score of 100 emans exact match (codes and text) only");
        desc.add(CODESENSITIVE, "Include inline codes in the comparison", "Use codes to compare contents");
        desc.add(DIFFONLY, "Diff only and mark the TextUnit as matched", "Diff only and do not copy the match or create a leverage annotation");
        desc.add(COPYTOTARGET, "Copy to/over the target? (WARNING: Copied target will not be segmented!)", "Copy to/over the target (a leverage annotation will still be created). WARNING: Copied target will not be segmented and any exisiting target will be lost.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Diff Leverage", true, false);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(FUZZYTHRESHOLD));
        sip.setRange(1, 100);
        sip.setVertical(false);
        desc.addCheckboxPart(paramsDesc.get(CODESENSITIVE));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(DIFFONLY));
        desc.addCheckboxPart(paramsDesc.get(COPYTOTARGET));
        return desc;
    }

    public int getFuzzyThreshold() {
        return this.getInteger(FUZZYTHRESHOLD);
    }

    public void setFuzzyThreshold(int fuzzyThreshold) {
        this.setInteger(FUZZYTHRESHOLD, fuzzyThreshold);
    }

    public boolean isCodesensitive() {
        return this.getBoolean(CODESENSITIVE);
    }

    public void setCodesensitive(boolean codesensitive) {
        this.setBoolean(CODESENSITIVE, codesensitive);
    }

    public boolean isDiffOnly() {
        return this.getBoolean(DIFFONLY);
    }

    public void setDiffOnly(boolean diffOnly) {
        this.setBoolean(DIFFONLY, diffOnly);
    }

    public void setCopyToTarget(boolean copyToTarget) {
        this.setBoolean(COPYTOTARGET, copyToTarget);
    }

    public boolean isCopyToTarget() {
        return this.getBoolean(COPYTOTARGET);
    }
}

