/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.diffleverage;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.steps.diffleverage.FileAlignment;
import net.sf.okapi.steps.diffleverage.FileLikeThing;

public class FileAligner<T>
implements Iterable<FileAlignment<T>> {
    private List<FileLikeThing<T>> newFiles;
    private Map<String, FileLikeThing<T>> trgFilesMap;
    private URI newRootUri;
    private Map<String, FileLikeThing<T>> oldSrcFilesMap;
    private Map<String, FileLikeThing<T>> oldTrgFilesMap;
    private List<FileAlignment<T>> alignedFiles;
    private boolean lowerCase;
    private boolean trilingual;

    public FileAligner(List<FileLikeThing<T>> newFiles, List<FileLikeThing<T>> oldSrcFiles, List<FileLikeThing<T>> oldTrgFiles, URI newRootUri, URI oldSrcRootUri, URI oldTrgRootUri) {
        this(true, newFiles, oldSrcFiles, oldTrgFiles, newRootUri, oldSrcRootUri, oldTrgRootUri);
    }

    public FileAligner(boolean lowerCase, List<FileLikeThing<T>> newFiles, List<FileLikeThing<T>> oldSrcFiles, List<FileLikeThing<T>> oldTrgFiles, URI newRootUri, URI oldSrcRootUri, URI oldTrgRootUri) {
        this.lowerCase = lowerCase;
        this.trilingual = true;
        this.newFiles = newFiles;
        this.newRootUri = newRootUri;
        this.oldTrgFilesMap = new TreeMap<String, FileLikeThing<T>>();
        this.oldSrcFilesMap = new TreeMap<String, FileLikeThing<T>>();
        this.createMatchingMap(lowerCase, this.oldSrcFilesMap, newFiles, oldSrcFiles, newRootUri, oldSrcRootUri);
        for (FileLikeThing<T> f : oldTrgFiles) {
            String key = FileAligner.getRealtivePath(f.getPath(), oldTrgRootUri);
            if (lowerCase) {
                key = key.toLowerCase();
            }
            if (this.oldTrgFilesMap.containsKey(key)) {
                throw new OkapiException("Duplicate path entry: " + key);
            }
            this.oldTrgFilesMap.put(key, f);
        }
    }

    public FileAligner(List<FileLikeThing<T>> srcFiles, List<FileLikeThing<T>> trgFiles, URI srcRootUri, URI trgRootUri) {
        this(true, srcFiles, trgFiles, srcRootUri, trgRootUri);
    }

    public FileAligner(boolean lowerCase, List<FileLikeThing<T>> srcFiles, List<FileLikeThing<T>> trgFiles, URI srcRootUri, URI trgRootUri) {
        this.newFiles = srcFiles;
        this.newRootUri = srcRootUri;
        this.lowerCase = lowerCase;
        this.trilingual = false;
        this.trgFilesMap = new TreeMap<String, FileLikeThing<T>>();
        this.createMatchingMap(lowerCase, this.trgFilesMap, srcFiles, trgFiles, srcRootUri, trgRootUri);
    }

    private void createMatchingMap(boolean lowerCase, Map<String, FileLikeThing<T>> matchingFileMap, List<FileLikeThing<T>> newFiles, List<FileLikeThing<T>> matchingFiles, URI newRootUri, URI matchingRotUri) {
        for (FileLikeThing<T> f : matchingFiles) {
            String key = FileAligner.getRealtivePath(f.getPath(), matchingRotUri);
            if (lowerCase) {
                key = key.toLowerCase();
            }
            if (matchingFileMap.containsKey(key)) {
                throw new OkapiException("Duplicate path entry: " + key);
            }
            matchingFileMap.put(key, f);
        }
    }

    public void align() {
        this.alignedFiles = new LinkedList<FileAlignment<T>>();
        for (FileLikeThing<T> f : this.newFiles) {
            String key = FileAligner.getRealtivePath(f.getPath(), this.newRootUri);
            if (this.lowerCase) {
                key = key.toLowerCase();
            }
            FileLikeThing<T> o = null;
            if (this.trilingual) {
                o = this.oldSrcFilesMap.get(key);
                if (o != null) {
                    if (this.oldTrgFilesMap != null) {
                        FileLikeThing<T> t = this.oldTrgFilesMap.get(key);
                        this.alignedFiles.add(new FileAlignment<T>(f, o, t));
                        continue;
                    }
                    this.alignedFiles.add(new FileAlignment<T>(f, o));
                    continue;
                }
                this.alignedFiles.add(new FileAlignment<T>(f));
                continue;
            }
            o = this.trgFilesMap.get(key);
            if (o != null) {
                this.alignedFiles.add(new FileAlignment<T>(f, o));
                continue;
            }
            this.alignedFiles.add(new FileAlignment<T>(f));
        }
    }

    @Override
    public Iterator<FileAlignment<T>> iterator() {
        return this.alignedFiles.iterator();
    }

    public List<FileAlignment<T>> getAlignments() {
        return this.alignedFiles;
    }

    private static String getRealtivePath(URI path, URI root) {
        String r = path.relativize(root).toString();
        return path.toString().replaceFirst(r, "");
    }
}

