/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.GroupNode;
import net.sf.okapi.lib.xliff2.document.IGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.IWithGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;

public abstract class WithGroupOrUnitNode
implements IWithGroupOrUnitNode {
    private LinkedHashMap<String, IGroupOrUnitNode> nodes = new LinkedHashMap();

    @Override
    public UnitNode add(UnitNode node) {
        this.nodes.put("u" + node.get().getId(), node);
        return node;
    }

    @Override
    public UnitNode addUnitNode(String id) {
        return this.add(new UnitNode(new Unit(id)));
    }

    @Override
    public GroupNode add(GroupNode node) {
        String id = node.get().getId();
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        this.nodes.put("g" + id, node);
        return node;
    }

    @Override
    public GroupNode addGroupNode(String id) {
        return this.add(new GroupNode(null, new StartGroupData(id)));
    }

    @Override
    public List<UnitNode> getUnitNodes() {
        ArrayList<UnitNode> unitNodes = new ArrayList<UnitNode>();
        for (String nodeKey : this.nodes.keySet()) {
            IGroupOrUnitNode node = this.nodes.get(nodeKey);
            if (node.isUnit()) {
                unitNodes.add((UnitNode)node);
                continue;
            }
            GroupNode groupNode = (GroupNode)node;
            unitNodes.addAll(groupNode.getUnitNodes());
        }
        return unitNodes;
    }

    @Override
    public UnitNode getUnitNode(String id) {
        UnitNode item = (UnitNode)this.nodes.get("u" + id);
        if (item != null) {
            return item;
        }
        for (IGroupOrUnitNode node : this.nodes.values()) {
            if (node.isUnit() || (item = ((GroupNode)node).getUnitNode(id)) == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public GroupNode getGroupNode(String id) {
        GroupNode item = (GroupNode)this.nodes.get("g" + id);
        if (item != null) {
            return item;
        }
        for (IGroupOrUnitNode node : this.nodes.values()) {
            if (node.isUnit() || (item = ((GroupNode)node).getGroupNode(id)) == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public Iterator<IGroupOrUnitNode> createGroupOrUnitIterator() {
        return this.nodes.values().iterator();
    }
}

