/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.IGlossaryReader;

public class CSVReader
implements IGlossaryReader {
    private final int MAX_COLUMNS = 2;
    private final char DELIMITER = (char)44;
    private final char QUALIFIER = (char)34;
    private ConceptEntry nextEntry;
    private BufferedReader reader;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private int currentLine = 0;

    public CSVReader(LocaleId srcLoc, LocaleId trgLoc) {
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
    }

    @Override
    public void open(File file) {
        try {
            this.open(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void open(InputStream input) {
        try {
            this.close();
            String encoding = "UTF-8";
            BOMAwareInputStream bis = new BOMAwareInputStream(input, encoding);
            encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, encoding));
            this.readNext();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void close() {
        this.nextEntry = null;
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public ConceptEntry next() {
        ConceptEntry currentEntry = this.nextEntry;
        this.readNext();
        return currentEntry;
    }

    private void readNext() {
        try {
            String[] parts;
            this.nextEntry = null;
            while (true) {
                String line;
                if ((line = this.reader.readLine()) == null) {
                    return;
                }
                if ((line = line.trim()).isEmpty()) continue;
                ++this.currentLine;
                parts = this.parseCsvLine(line);
                if (parts[0] != null && parts[1] != null && parts[0].length() > 0 && parts[1].length() > 0) break;
            }
            ConceptEntry cent = new ConceptEntry();
            cent.addTerm(this.srcLoc, parts[0]);
            cent.addTerm(this.trgLoc, parts[1]);
            this.nextEntry = cent;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error when reading." + e.getLocalizedMessage(), e);
        }
    }

    private String[] parseCsvLine(String line) {
        String[] entry = new String[3];
        int column = 0;
        StringBuilder sb = new StringBuilder();
        boolean insideColumn = false;
        boolean qualified = false;
        for (int i = 0; i < line.length() && column < 2; ++i) {
            if (!insideColumn) {
                if (line.charAt(i) == ' ') continue;
                if (line.charAt(i) == ',') {
                    entry[column] = sb.toString();
                    ++column;
                    sb.setLength(0);
                    continue;
                }
                insideColumn = true;
                if (line.charAt(i) == '\"') {
                    qualified = true;
                    continue;
                }
                qualified = false;
                sb.append(line.charAt(i));
                continue;
            }
            if (line.charAt(i) == ',') {
                if (qualified) {
                    sb.append(line.charAt(i));
                    continue;
                }
                if (qualified) continue;
                entry[column] = sb.toString().trim();
                ++column;
                sb.setLength(0);
                insideColumn = false;
                continue;
            }
            if (line.charAt(i) == '\"') {
                if (i + 1 < line.length() && line.charAt(i + 1) == '\"') {
                    sb.append(line.charAt(i));
                    ++i;
                    continue;
                }
                if (insideColumn && !qualified) {
                    throw new OkapiIOException("Row " + this.currentLine + ": Incorrect place for qualifier");
                }
                insideColumn = false;
                continue;
            }
            sb.append(line.charAt(i));
        }
        entry[column] = sb.toString();
        return entry;
    }
}

