/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml.parser;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.filters.yaml.parser.IYamlHandler;
import net.sf.okapi.filters.yaml.parser.JavaCharStream;
import net.sf.okapi.filters.yaml.parser.Token;
import net.sf.okapi.filters.yaml.parser.TokenMgrException;
import net.sf.okapi.filters.yaml.parser.YamlParserConstants;

public class YamlParserTokenManager
implements YamlParserConstants {
    static final int MAX_INDENTS = 1000;
    static final int FIRST_COLUMN = 0;
    int[] indentStack = new int[1000];
    int[] indentTokenTypes = new int[1000];
    int sp = 0;
    int pendingDedents = 0;
    Token lastToken;
    int flowSequenceNesting = 0;
    int flowMappingeNesting = 0;
    boolean linestart = false;
    IYamlHandler handler = null;
    List<Token> endIndentedSpecial;
    public PrintStream debugStream = System.out;
    static final long[] jjbitVec0 = new long[]{-2L, -1L, -1L, -1L};
    static final long[] jjbitVec2 = new long[]{0L, 0L, -1L, -1L};
    static final long[] jjbitVec3 = new long[]{0L, 0L, 32L, 0L};
    static final long[] jjbitVec4 = new long[]{0x30000000000L, 0L, 0L, 0L};
    static final long[] jjbitVec5 = new long[]{0L, 0L, 0x100000000L, 0L};
    static final long[] jjbitVec6 = new long[]{0L, 0L, 1L, 0L};
    static final long[] jjbitVec7 = new long[]{16384L, 0L, 0L, 0L};
    static final long[] jjbitVec8 = new long[]{0x800000000FFFL, 0x80000000L, 0L, 0L};
    static final long[] jjbitVec9 = new long[]{1L, 0L, 0L, 0L};
    static final long[] jjbitVec10 = new long[]{0L, 0L, 0L, Long.MIN_VALUE};
    static final long[] jjbitVec11 = new long[]{0L, 0L, 0x100000020L, 0L};
    static final long[] jjbitVec12 = new long[]{144036023242751L, 0x80000000L, 0L, 0L};
    public static final String[] jjstrLiteralImages = new String[]{"", null, "BLOCK_SEQUENCE_START", "BLOCK_MAPPING_START", "BLOCK_END", "NULL_SCALAR", "FALSE_START", null, null, null, null, null, null, null, "[", "{", "]", "}", null, null, null, null, null, null, null, null, null, "''", "\"\"", null, null, null, null, null, "\"", null, "'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    static final int[] jjnextStates = new int[]{114, 115, 117, 119, 120, 122, 130, 19, 21, 22, 94, 95, 99, 100, 78, 80, 81, 83, 65, 74, 1, 3, 4, 50, 51, 52, 6, 7, 8, 10, 11, 12, 81, 83, 84, 99, 100, 103, 7, 8, 10, 11, 12, 10, 11, 12, 13, 14, 10, 11, 14, 10, 11, 28, 29, 30, 31, 32, 28, 29, 32, 28, 29, 36, 38, 39, 53, 54, 50, 51, 54, 50, 51, 59, 60, 62, 63, 60, 62, 63, 68, 70, 71, 88, 89, 90, 91, 92, 88, 89, 92, 88, 89, 94, 95, 97, 99, 100, 102, 103, 107, 108, 109, 110, 111, 107, 108, 111, 107, 108, 114, 115, 117, 119, 120, 122, 130, 125, 126, 127, 128, 129, 125, 126, 129, 125, 126, 131, 125, 126, 127, 43, 44, 101, 112, 96, 98, 67, 68, 85, 86, 104, 105, 7, 8, 9, 10, 11, 7, 8, 11, 7, 8, 15, 17, 18, 5, 6, 8, 14, 16, 17, 14, 16, 17, 7, 9, 6, 7, 9, 59, 61, 62, 92, 93, 95, 96, 98, 99, 107, 108, 72, 73, 77, 78, 56, 58, 59, 61, 43, 52, 77, 78, 81, 37, 38, 40, 41, 38, 40, 41, 46, 48, 49, 66, 67, 68, 69, 70, 66, 67, 70, 66, 67, 72, 73, 75, 77, 78, 80, 81, 85, 86, 87, 88, 89, 85, 86, 89, 85, 86, 95, 96, 98, 99, 101, 102, 103, 104, 105, 101, 102, 105, 101, 102, 79, 90, 74, 76, 45, 46, 63, 64, 82, 83};
    int curLexState = 7;
    int defaultLexState = 7;
    int jjnewStateCnt;
    int jjround;
    int jjmatchedPos;
    int jjmatchedKind;
    public static final String[] lexStateNames = new String[]{"BLOCK_INDENTED", "INDENTED", "SINGLEQUOTE", "DOUBLEQUOTE", "DOCUMENT_START_END", "FLOW", "UNREACHABLE", "DEFAULT"};
    public static final int[] jjnewLexState = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 3, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final long[] jjtoToken = new long[]{2231871033310845L};
    static final long[] jjtoSkip = new long[]{6755399441055746L};
    static final long[] jjtoSpecial = new long[]{6755399441055746L};
    static final long[] jjtoMore = new long[]{0L};
    protected JavaCharStream input_stream;
    private final int[] jjrounds = new int[133];
    private final int[] jjstateSet = new int[266];
    private final StringBuilder jjimage;
    private StringBuilder image = this.jjimage = new StringBuilder();
    private int jjimageLen;
    private int lengthOfMatch;
    protected int curChar;

    void reset() {
        this.indentStack = new int[1000];
        this.indentTokenTypes = new int[1000];
        this.sp = 0;
        this.pendingDedents = 0;
        this.lastToken = null;
        this.flowSequenceNesting = 0;
        this.flowMappingeNesting = 0;
        this.linestart = false;
        this.endIndentedSpecial = null;
        this.indentStack[this.sp] = 0;
        this.indentTokenTypes[this.sp] = -1;
        this.curLexState = 7;
    }

    void CommonTokenAction(Token currentToken) {
        int tokenSize = currentToken.image.length();
        int currentColumn = currentToken.beginColumn;
        if (this.ignoreIndent(currentToken.kind)) {
            return;
        }
        if (this.pendingDedents > 0) {
            this.handlePendingDedent(currentToken);
            return;
        }
        if (currentToken.kind != 0 && this.lastToken != null && this.lastToken.beginColumn == currentToken.beginColumn && this.lastToken.beginLine == currentToken.beginLine) {
            return;
        }
        int lastLine = this.lastToken == null ? 0 : this.lastToken.endLine;
        int currentLine = currentToken.beginLine;
        if (currentToken.kind != 0 && currentLine == lastLine && !this.isBlockKey(currentToken.kind) && currentToken.kind != 40) {
            this.lastToken = currentToken;
            return;
        }
        if (this.unwindIndent(currentToken)) {
            this.lastToken = currentToken;
            return;
        }
        if (currentToken.kind == 40 || this.isBlockKey(currentToken.kind)) {
            if (this.peekIndent() < currentColumn) {
                if (this.lastTokenWasTag(this.lastToken) && this.lastToken.beginLine == currentToken.beginLine) {
                    this.push(this.lastToken.beginColumn, currentToken.kind);
                } else {
                    this.push(currentColumn, currentToken.kind);
                }
                if (currentToken.kind == 40 && !this.isIndentlessBlock(currentToken)) {
                    this.backup(tokenSize);
                    currentToken.kind = 2;
                    currentToken.image = "BLOCK_SEQUENCE_START";
                } else if (this.isBlockKey(currentToken.kind)) {
                    this.backup(tokenSize);
                    currentToken.kind = 3;
                    currentToken.image = "BLOCK_MAPPING_START";
                }
            }
        } else if (this.peekType() == 40 && this.isBlockKey(currentToken.kind) && currentLine == lastLine) {
            this.push(currentColumn, currentToken.kind);
            this.backup(tokenSize);
            currentToken.kind = 3;
            currentToken.image = "BLOCK_MAPPING_START";
        } else if (this.peekType() == 40 && currentToken.kind == 40 && currentLine == lastLine) {
            this.backup(tokenSize);
            currentToken.kind = 2;
            currentToken.image = "BLOCK_SEQUENCE_START";
        }
        this.lastToken = currentToken;
    }

    public void initialize(IYamlHandler h) {
        this.reset();
        this.handler = h;
    }

    public boolean lastTokenWasTag(Token t) {
        if (t == null) {
            return false;
        }
        return t.kind == 9;
    }

    private boolean isIndentlessBlock(Token indentCandidate) {
        return indentCandidate.kind == 40 && (this.peekIndent() == 0 || this.isBlockKey(this.peekType()) && this.peekIndent() == indentCandidate.beginColumn);
    }

    public boolean isBlockKey(int kind) {
        switch (this.curLexState) {
            case 5: {
                return false;
            }
        }
        switch (kind) {
            case 42: 
            case 43: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    public boolean ignoreIndent(int kind) {
        switch (this.curLexState) {
            case 5: {
                return true;
            }
        }
        switch (kind) {
            case 5: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 47: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    public boolean canUnindent(Token t) {
        switch (this.curLexState) {
            case 5: {
                return false;
            }
        }
        switch (t.kind) {
            case 16: 
            case 17: {
                return false;
            }
        }
        return true;
    }

    private void backup(int n) {
        this.input_stream.backup(n);
    }

    private boolean unwindIndent(Token t) {
        if (!this.canUnindent(t)) {
            return false;
        }
        int beginColumn = t.beginColumn;
        if (t.kind == 0 || t.kind == 19 || t.kind == 20) {
            beginColumn = 0;
        }
        if (this.peekIndent() > beginColumn) {
            int prevIndex = this.findPreviousIndent(beginColumn);
            for (int d = this.sp - 1; d >= prevIndex; --d) {
                ++this.pendingDedents;
            }
            this.handlePendingDedent(t);
            return true;
        }
        return false;
    }

    private boolean isIndentedScalarFinished(Token t) {
        if (this.peekIndent() >= t.beginColumn) {
            this.endIndentedSpecial = this.getSpecialTokensBefore(t);
            this.backup(t.image.length());
            t.kind = 5;
            t.image = "";
            return true;
        }
        return false;
    }

    public void processIndentedBlockEnd() {
        if (this.endIndentedSpecial != null) {
            boolean first = true;
            for (Token s : this.endIndentedSpecial) {
                if (s.kind == 1) {
                    this.handler.handleComment(first ? " " + s.image : s.image, true);
                } else {
                    this.handler.handleWhitespace(s.image, true);
                }
                first = false;
            }
            this.endIndentedSpecial = null;
        }
    }

    private void handlePendingDedent(Token t) {
        if (t.kind != 6) {
            this.backup(t.image.length());
        }
        t.kind = 4;
        t.image = "BLOCK_END";
        if (this.pendingDedents > 0) {
            --this.pendingDedents;
        }
        this.pop();
    }

    private void push(int indent, int type) {
        if (this.sp >= 1000) {
            throw new IllegalStateException("Indent Error");
        }
        ++this.sp;
        this.indentStack[this.sp] = indent;
        this.indentTokenTypes[this.sp] = type;
    }

    private int pop() {
        if (this.sp < 0) {
            throw new IllegalStateException("Unindent error");
        }
        int top = this.indentStack[this.sp];
        --this.sp;
        return top;
    }

    public int peekIndent() {
        return this.indentStack[this.sp];
    }

    public int peekType() {
        return this.indentTokenTypes[this.sp];
    }

    public boolean insideFlow() {
        return this.flowSequenceNesting != 0 || this.flowMappingeNesting != 0;
    }

    private int findPreviousIndent(int i) {
        for (int j = this.sp - 1; j >= 0; --j) {
            if (this.indentStack[j] != i) continue;
            return j;
        }
        return -1;
    }

    private void ignorableWhiteSpace(Token t) {
        if (this.curLexState == 7 || this.curLexState == 5) {
            this.handler.handleWhitespace(t.image, false);
        }
    }

    private void ignorableComment(Token t) {
        if (this.curLexState == 7 || this.curLexState == 5) {
            this.handler.handleComment(t.image, false);
        }
    }

    public List<Token> getSpecialTokensBefore(Token t) {
        if (t.specialToken == null) {
            return null;
        }
        ArrayList<Token> specialTokensList = new ArrayList<Token>();
        Token tmp_t = t.specialToken;
        while (tmp_t.specialToken != null) {
            tmp_t = tmp_t.specialToken;
        }
        while (tmp_t != null) {
            specialTokensList.add(tmp_t);
            tmp_t = tmp_t.next;
        }
        return specialTokensList;
    }

    public void setDebugStream(PrintStream ds) {
        this.debugStream = ds;
    }

    private final int jjStopStringLiteralDfa_7(int pos, long active0) {
        switch (pos) {
            case 0: {
                if ((active0 & 0x10000000L) != 0L) {
                    return 133;
                }
                if ((active0 & 0x8000000L) != 0L) {
                    return 134;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_7(int pos, long active0) {
        return this.jjMoveNfa_7(this.jjStopStringLiteralDfa_7(pos, active0), pos + 1);
    }

    private int jjStopAtPos(int pos, int kind) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        return pos + 1;
    }

    private int jjMoveStringLiteralDfa0_7() {
        switch (this.curChar) {
            case 34: {
                return this.jjMoveStringLiteralDfa1_7(0x10000000L);
            }
            case 39: {
                return this.jjMoveStringLiteralDfa1_7(0x8000000L);
            }
            case 91: {
                return this.jjStopAtPos(0, 14);
            }
            case 123: {
                return this.jjStopAtPos(0, 15);
            }
        }
        return this.jjMoveNfa_7(0, 0);
    }

    private int jjMoveStringLiteralDfa1_7(long active0) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(0, active0);
            return 1;
        }
        switch (this.curChar) {
            case 34: {
                if ((active0 & 0x10000000L) == 0L) break;
                return this.jjStopAtPos(1, 28);
            }
            case 39: {
                if ((active0 & 0x8000000L) == 0L) break;
                return this.jjStartNfaWithStates_7(1, 27, 79);
            }
        }
        return this.jjStartNfa_7(0, active0);
    }

    private int jjStartNfaWithStates_7(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_7(state, pos + 1);
    }

    private int jjMoveNfa_7(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 133;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block219: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x3BFFCB10FFFFDBFFL & l) != 0L) {
                                if (kind > 45) {
                                    kind = 45;
                                }
                                this.jjCheckNAddStates(0, 6);
                            } else if ((0x100002400L & l) != 0L) {
                                this.jjCheckNAddStates(7, 9);
                            } else if ((0x8400200000000000L & l) != 0L) {
                                this.jjCheckNAddTwoStates(116, 131);
                            } else if (this.curChar == 34) {
                                this.jjCheckNAddStates(10, 13);
                            } else if (this.curChar == 39) {
                                this.jjCheckNAddStates(14, 17);
                            } else if (this.curChar == 37) {
                                this.jjAddStates(18, 19);
                            } else if (this.curChar == 62) {
                                if (kind > 39) {
                                    kind = 39;
                                }
                                this.jjCheckNAddTwoStates(46, 47);
                            } else if (this.curChar == 42) {
                                this.jjCheckNAddTwoStates(23, 24);
                            } else if (this.curChar == 38) {
                                this.jjCheckNAdd(18);
                            } else if (this.curChar == 33) {
                                this.jjstateSet[this.jjnewStateCnt++] = 15;
                            } else if (this.curChar == 35) {
                                if (kind > 1) {
                                    kind = 1;
                                }
                                this.jjCheckNAddStates(20, 22);
                            }
                            if ((0x2400L & l) != 0L) {
                                if (kind > 51) {
                                    kind = 51;
                                }
                            } else if (this.curChar == 32) {
                                if (kind > 52) {
                                    kind = 52;
                                }
                            } else if (this.curChar == 45) {
                                this.jjCheckNAddStates(23, 25);
                            } else if (this.curChar == 46) {
                                this.jjstateSet[this.jjnewStateCnt++] = 40;
                            } else if (this.curChar == 33) {
                                this.jjCheckNAddStates(26, 31);
                            }
                            if (this.curChar == 13) {
                                this.jjCheckNAddTwoStates(20, 76);
                                break;
                            }
                            if (this.curChar != 45) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 33;
                            break;
                        }
                        case 134: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) != 0L) {
                                this.jjCheckNAddStates(32, 34);
                            } else if (this.curChar == 39) {
                                this.jjstateSet[this.jjnewStateCnt++] = 82;
                            }
                            if ((0xFFFFFF7FFFFFDBFFL & l) != 0L) {
                                if (kind > 29) {
                                    kind = 29;
                                }
                                this.jjCheckNAddTwoStates(78, 80);
                                break;
                            }
                            if (this.curChar != 39) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 79;
                            break;
                        }
                        case 133: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) != 0L) {
                                this.jjCheckNAddStates(35, 37);
                            }
                            if ((0xFFFFFFFBFFFFC9FFL & l) == 0L) break;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(94, 95);
                            break;
                        }
                        case 79: {
                            if (this.curChar == 39) {
                                this.jjCheckNAddStates(32, 34);
                            }
                            if (this.curChar != 39) break;
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(78, 80);
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block219;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block219;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block219;
                            kind = 1;
                            break;
                        }
                        case 5: 
                        case 15: {
                            if (this.curChar != 33) break;
                            this.jjCheckNAddStates(26, 31);
                            break;
                        }
                        case 6: {
                            if (this.curChar != 60) break;
                            this.jjCheckNAddStates(38, 42);
                            break;
                        }
                        case 7: {
                            if ((0xAFFFFFFA00000000L & l) == 0L) break;
                            this.jjCheckNAddStates(38, 42);
                            break;
                        }
                        case 8: {
                            if (this.curChar != 62) break;
                            this.jjCheckNAddStates(43, 45);
                            break;
                        }
                        case 9: {
                            if (this.curChar != 10 || kind <= 9) continue block219;
                            kind = 9;
                            break;
                        }
                        case 10: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 9;
                            break;
                        }
                        case 11: {
                            if ((0x2400L & l) == 0L || kind <= 9) continue block219;
                            kind = 9;
                            break;
                        }
                        case 12: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAddStates(46, 49);
                            break;
                        }
                        case 13: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAdd(13);
                            break;
                        }
                        case 14: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(50, 52);
                            break;
                        }
                        case 16: {
                            if (this.curChar != 33) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 15;
                            break;
                        }
                        case 17: {
                            if (this.curChar != 38) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 18: {
                            if ((0x3FF200000000000L & l) == 0L) continue block219;
                            if (kind > 12) {
                                kind = 12;
                            }
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 19: {
                            if ((0x100002400L & l) == 0L) break;
                            this.jjCheckNAddStates(7, 9);
                            break;
                        }
                        case 20: {
                            if (this.curChar != 10) break;
                            this.jjCheckNAddStates(7, 9);
                            break;
                        }
                        case 21: {
                            if (this.curChar != 13) break;
                            this.jjCheckNAdd(20);
                            break;
                        }
                        case 22: {
                            if (this.curChar != 42) break;
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 23: {
                            if ((0x3BFFCB10FFFFDBFFL & l) == 0L) continue block219;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 24: {
                            if ((0x8400200000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 25;
                            break;
                        }
                        case 25: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) continue block219;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 26: {
                            if (this.curChar != 45) break;
                            this.jjCheckNAddStates(53, 55);
                            break;
                        }
                        case 27: {
                            if (this.curChar != 10 || kind <= 19) continue block219;
                            kind = 19;
                            break;
                        }
                        case 28: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 27;
                            break;
                        }
                        case 29: {
                            if ((0x2400L & l) == 0L || kind <= 19) continue block219;
                            kind = 19;
                            break;
                        }
                        case 30: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAddStates(56, 59);
                            break;
                        }
                        case 31: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 32: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(60, 62);
                            break;
                        }
                        case 33: {
                            if (this.curChar != 45) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 26;
                            break;
                        }
                        case 34: {
                            if (this.curChar != 45) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 33;
                            break;
                        }
                        case 35: {
                            if (this.curChar != 46) continue block219;
                            if (kind > 20) {
                                kind = 20;
                            }
                            this.jjCheckNAddStates(63, 65);
                            break;
                        }
                        case 36: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 20) {
                                kind = 20;
                            }
                            this.jjCheckNAddStates(63, 65);
                            break;
                        }
                        case 37: {
                            if (this.curChar != 10 || kind <= 20) continue block219;
                            kind = 20;
                            break;
                        }
                        case 38: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 37;
                            break;
                        }
                        case 39: {
                            if ((0x2400L & l) == 0L || kind <= 20) continue block219;
                            kind = 20;
                            break;
                        }
                        case 40: {
                            if (this.curChar != 46) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 35;
                            break;
                        }
                        case 41: {
                            if (this.curChar != 46) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 40;
                            break;
                        }
                        case 43: {
                            if ((0x280000000000L & l) == 0L) continue block219;
                            if (kind > 38) {
                                kind = 38;
                            }
                            this.jjCheckNAdd(44);
                            break;
                        }
                        case 44: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 38) {
                                kind = 38;
                            }
                            this.jjCheckNAdd(44);
                            break;
                        }
                        case 45: {
                            if (this.curChar != 62) continue block219;
                            if (kind > 39) {
                                kind = 39;
                            }
                            this.jjCheckNAddTwoStates(46, 47);
                            break;
                        }
                        case 46: {
                            if ((0x280000000000L & l) == 0L) continue block219;
                            if (kind > 39) {
                                kind = 39;
                            }
                            this.jjCheckNAdd(47);
                            break;
                        }
                        case 47: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 39) {
                                kind = 39;
                            }
                            this.jjCheckNAdd(47);
                            break;
                        }
                        case 48: {
                            if (this.curChar != 45) break;
                            this.jjCheckNAddStates(23, 25);
                            break;
                        }
                        case 49: {
                            if (this.curChar != 10 || kind <= 40) continue block219;
                            kind = 40;
                            break;
                        }
                        case 50: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 49;
                            break;
                        }
                        case 51: {
                            if ((0x2400L & l) == 0L || kind <= 40) continue block219;
                            kind = 40;
                            break;
                        }
                        case 52: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 40) {
                                kind = 40;
                            }
                            this.jjCheckNAddStates(66, 69);
                            break;
                        }
                        case 53: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 40) {
                                kind = 40;
                            }
                            this.jjCheckNAdd(53);
                            break;
                        }
                        case 54: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(70, 72);
                            break;
                        }
                        case 55: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block219;
                            kind = 51;
                            break;
                        }
                        case 56: {
                            if (this.curChar != 32 || kind <= 52) continue block219;
                            kind = 52;
                            break;
                        }
                        case 57: {
                            if (this.curChar != 37) break;
                            this.jjAddStates(18, 19);
                            break;
                        }
                        case 59: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(73, 76);
                            break;
                        }
                        case 60: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(77, 79);
                            break;
                        }
                        case 61: {
                            if (this.curChar != 10 || kind <= 10) continue block219;
                            kind = 10;
                            break;
                        }
                        case 62: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 61;
                            break;
                        }
                        case 63: {
                            if ((0x2400L & l) == 0L || kind <= 10) continue block219;
                            kind = 10;
                            break;
                        }
                        case 67: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(67, 68);
                            break;
                        }
                        case 68: {
                            if ((0x3FF400000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(80, 82);
                            break;
                        }
                        case 69: {
                            if (this.curChar != 10 || kind <= 11) continue block219;
                            kind = 11;
                            break;
                        }
                        case 70: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 69;
                            break;
                        }
                        case 71: {
                            if ((0x2400L & l) == 0L || kind <= 11) continue block219;
                            kind = 11;
                            break;
                        }
                        case 75: {
                            if (this.curChar != 13) break;
                            this.jjCheckNAddTwoStates(20, 76);
                            break;
                        }
                        case 76: {
                            if (this.curChar != 10 || kind <= 51) continue block219;
                            kind = 51;
                            break;
                        }
                        case 77: {
                            if (this.curChar != 39) break;
                            this.jjCheckNAddStates(14, 17);
                            break;
                        }
                        case 78: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) == 0L) continue block219;
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(78, 80);
                            break;
                        }
                        case 80: {
                            if (this.curChar != 39) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 79;
                            break;
                        }
                        case 81: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(32, 34);
                            break;
                        }
                        case 82: {
                            if (this.curChar != 39) break;
                            this.jjCheckNAddStates(32, 34);
                            break;
                        }
                        case 83: {
                            if (this.curChar != 39) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 82;
                            break;
                        }
                        case 84: {
                            if (this.curChar != 39) break;
                            this.jjCheckNAddTwoStates(85, 86);
                            break;
                        }
                        case 85: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(85, 86);
                            break;
                        }
                        case 86: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAddStates(83, 85);
                            break;
                        }
                        case 87: {
                            if (this.curChar != 10 || kind <= 42) continue block219;
                            kind = 42;
                            break;
                        }
                        case 88: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 87;
                            break;
                        }
                        case 89: {
                            if ((0x2400L & l) == 0L || kind <= 42) continue block219;
                            kind = 42;
                            break;
                        }
                        case 90: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAddStates(86, 89);
                            break;
                        }
                        case 91: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAdd(91);
                            break;
                        }
                        case 92: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(90, 92);
                            break;
                        }
                        case 93: {
                            if (this.curChar != 34) break;
                            this.jjCheckNAddStates(10, 13);
                            break;
                        }
                        case 94: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) == 0L) continue block219;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(94, 95);
                            break;
                        }
                        case 97: {
                            if ((0x3FF000000000000L & l) == 0L) continue block219;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddStates(93, 95);
                            break;
                        }
                        case 98: {
                            if ((0x1800400000000L & l) == 0L) continue block219;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(94, 95);
                            break;
                        }
                        case 99: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) == 0L) break;
                            this.jjCheckNAddStates(35, 37);
                            break;
                        }
                        case 102: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(96, 99);
                            break;
                        }
                        case 103: {
                            if (this.curChar != 34) break;
                            this.jjCheckNAddTwoStates(104, 105);
                            break;
                        }
                        case 104: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(104, 105);
                            break;
                        }
                        case 105: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAddStates(100, 102);
                            break;
                        }
                        case 106: {
                            if (this.curChar != 10 || kind <= 43) continue block219;
                            kind = 43;
                            break;
                        }
                        case 107: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 106;
                            break;
                        }
                        case 108: {
                            if ((0x2400L & l) == 0L || kind <= 43) continue block219;
                            kind = 43;
                            break;
                        }
                        case 109: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAddStates(103, 106);
                            break;
                        }
                        case 110: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAdd(110);
                            break;
                        }
                        case 111: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(107, 109);
                            break;
                        }
                        case 112: {
                            if ((0x1800400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(35, 37);
                            break;
                        }
                        case 113: {
                            if ((0x3BFFCB10FFFFDBFFL & l) == 0L) continue block219;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(0, 6);
                            break;
                        }
                        case 114: {
                            if ((0xFBFFFFF7FFFFDBFFL & l) == 0L) continue block219;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(110, 112);
                            break;
                        }
                        case 115: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAdd(116);
                            break;
                        }
                        case 116: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) continue block219;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(110, 112);
                            break;
                        }
                        case 117: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 118;
                            break;
                        }
                        case 118: {
                            if (this.curChar != 35) continue block219;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(110, 112);
                            break;
                        }
                        case 119: {
                            if ((0xFBFFFFF7FFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(113, 116);
                            break;
                        }
                        case 120: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 121;
                            break;
                        }
                        case 121: {
                            if (this.curChar != 35) break;
                            this.jjCheckNAddStates(113, 116);
                            break;
                        }
                        case 122: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(122, 123);
                            break;
                        }
                        case 123: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAddStates(117, 119);
                            break;
                        }
                        case 124: {
                            if (this.curChar != 10 || kind <= 46) continue block219;
                            kind = 46;
                            break;
                        }
                        case 125: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 124;
                            break;
                        }
                        case 126: {
                            if ((0x2400L & l) == 0L || kind <= 46) continue block219;
                            kind = 46;
                            break;
                        }
                        case 127: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 46) {
                                kind = 46;
                            }
                            this.jjCheckNAddStates(120, 123);
                            break;
                        }
                        case 128: {
                            if (this.curChar != 32) continue block219;
                            if (kind > 46) {
                                kind = 46;
                            }
                            this.jjCheckNAdd(128);
                            break;
                        }
                        case 129: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(124, 126);
                            break;
                        }
                        case 130: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAddStates(127, 130);
                            break;
                        }
                        case 131: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(113, 116);
                            break;
                        }
                        case 132: {
                            if ((0x8400200000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(116, 131);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                block220: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xC7FFFFFED7FFFFFEL & l) != 0L) {
                                if (kind > 45) {
                                    kind = 45;
                                }
                                this.jjCheckNAddStates(0, 6);
                                break;
                            }
                            if (this.curChar != 124) break;
                            if (kind > 38) {
                                kind = 38;
                            }
                            this.jjAddStates(131, 132);
                            break;
                        }
                        case 134: {
                            this.jjCheckNAddStates(32, 34);
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(78, 80);
                            break;
                        }
                        case 133: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) != 0L) {
                                this.jjCheckNAddStates(35, 37);
                            } else if (this.curChar == 92) {
                                this.jjAddStates(133, 134);
                            }
                            if ((0xFFFFFFFFEFFFFFFFL & l) != 0L) {
                                if (kind > 30) {
                                    kind = 30;
                                }
                                this.jjCheckNAddTwoStates(94, 95);
                                break;
                            }
                            if (this.curChar != 92) break;
                            this.jjAddStates(135, 136);
                            break;
                        }
                        case 1: {
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 7: {
                            if ((0x47FFFFFEAFFFFFFFL & l) == 0L) break;
                            this.jjAddStates(38, 42);
                            break;
                        }
                        case 18: {
                            if ((0x7FFFFFE87FFFFFEL & l) == 0L) continue block220;
                            if (kind > 12) {
                                kind = 12;
                            }
                            this.jjstateSet[this.jjnewStateCnt++] = 18;
                            break;
                        }
                        case 23: {
                            if ((0xC7FFFFFED7FFFFFEL & l) == 0L) continue block220;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 25: {
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 42: {
                            if (this.curChar != 124) continue block220;
                            if (kind > 38) {
                                kind = 38;
                            }
                            this.jjAddStates(131, 132);
                            break;
                        }
                        case 58: {
                            if (this.curChar != 71) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 59;
                            break;
                        }
                        case 60: {
                            this.jjAddStates(77, 79);
                            break;
                        }
                        case 64: {
                            if (this.curChar != 65) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 58;
                            break;
                        }
                        case 65: {
                            if (this.curChar != 84) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 64;
                            break;
                        }
                        case 66: {
                            if (this.curChar != 76) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 67;
                            break;
                        }
                        case 72: {
                            if (this.curChar != 77) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 66;
                            break;
                        }
                        case 73: {
                            if (this.curChar != 65) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 72;
                            break;
                        }
                        case 74: {
                            if (this.curChar != 89) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 73;
                            break;
                        }
                        case 78: {
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(78, 80);
                            break;
                        }
                        case 81: {
                            this.jjCheckNAddStates(32, 34);
                            break;
                        }
                        case 94: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) continue block220;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(94, 95);
                            break;
                        }
                        case 95: {
                            if (this.curChar != 92) break;
                            this.jjAddStates(135, 136);
                            break;
                        }
                        case 96: {
                            if (this.curChar != 120) break;
                            this.jjCheckNAdd(97);
                            break;
                        }
                        case 97: {
                            if ((0x7E0000007EL & l) == 0L) continue block220;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddStates(93, 95);
                            break;
                        }
                        case 98: {
                            if ((0x55406490004000L & l) == 0L) continue block220;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(94, 95);
                            break;
                        }
                        case 99: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(35, 37);
                            break;
                        }
                        case 100: {
                            if (this.curChar != 92) break;
                            this.jjAddStates(133, 134);
                            break;
                        }
                        case 101: {
                            if (this.curChar != 120) break;
                            this.jjCheckNAdd(102);
                            break;
                        }
                        case 102: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(96, 99);
                            break;
                        }
                        case 112: {
                            if ((0x55406490004000L & l) == 0L) break;
                            this.jjCheckNAddStates(35, 37);
                            break;
                        }
                        case 113: {
                            if ((0xC7FFFFFED7FFFFFEL & l) == 0L) continue block220;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(0, 6);
                            break;
                        }
                        case 114: 
                        case 116: {
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(110, 112);
                            break;
                        }
                        case 117: {
                            this.jjstateSet[this.jjnewStateCnt++] = 118;
                            break;
                        }
                        case 119: 
                        case 131: {
                            this.jjCheckNAddStates(113, 116);
                            break;
                        }
                        case 120: {
                            this.jjstateSet[this.jjnewStateCnt++] = 121;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block221: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_3(hiByte, i1, i2, l1, l2)) {
                                this.jjCheckNAddStates(7, 9);
                            }
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52) {
                                kind = 52;
                            }
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(0, 6);
                            break;
                        }
                        case 134: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 29) {
                                    kind = 29;
                                }
                                this.jjCheckNAddTwoStates(78, 80);
                            }
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(32, 34);
                            break;
                        }
                        case 133: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 30) {
                                    kind = 30;
                                }
                                this.jjCheckNAddTwoStates(94, 95);
                            }
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(35, 37);
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block221;
                            kind = 1;
                            break;
                        }
                        case 11: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 9) continue block221;
                            kind = 9;
                            break;
                        }
                        case 12: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAddStates(46, 49);
                            break;
                        }
                        case 13: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAdd(13);
                            break;
                        }
                        case 14: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(50, 52);
                            break;
                        }
                        case 19: {
                            if (!YamlParserTokenManager.jjCanMove_3(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(7, 9);
                            break;
                        }
                        case 23: 
                        case 25: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 29: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 19) continue block221;
                            kind = 19;
                            break;
                        }
                        case 30: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAddStates(56, 59);
                            break;
                        }
                        case 31: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 32: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(60, 62);
                            break;
                        }
                        case 36: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 20) {
                                kind = 20;
                            }
                            this.jjAddStates(63, 65);
                            break;
                        }
                        case 39: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 20) continue block221;
                            kind = 20;
                            break;
                        }
                        case 44: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 38) {
                                kind = 38;
                            }
                            this.jjstateSet[this.jjnewStateCnt++] = 44;
                            break;
                        }
                        case 47: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 39) {
                                kind = 39;
                            }
                            this.jjstateSet[this.jjnewStateCnt++] = 47;
                            break;
                        }
                        case 51: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 40) continue block221;
                            kind = 40;
                            break;
                        }
                        case 52: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 40) {
                                kind = 40;
                            }
                            this.jjCheckNAddStates(66, 69);
                            break;
                        }
                        case 53: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 40) {
                                kind = 40;
                            }
                            this.jjCheckNAdd(53);
                            break;
                        }
                        case 54: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(70, 72);
                            break;
                        }
                        case 55: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block221;
                            kind = 51;
                            break;
                        }
                        case 56: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block221;
                            kind = 52;
                            break;
                        }
                        case 59: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(73, 76);
                            break;
                        }
                        case 60: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(77, 79);
                            break;
                        }
                        case 63: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 10) continue block221;
                            kind = 10;
                            break;
                        }
                        case 67: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjAddStates(137, 138);
                            break;
                        }
                        case 71: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 11) continue block221;
                            kind = 11;
                            break;
                        }
                        case 78: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(78, 80);
                            break;
                        }
                        case 81: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(32, 34);
                            break;
                        }
                        case 85: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjAddStates(139, 140);
                            break;
                        }
                        case 89: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 42) continue block221;
                            kind = 42;
                            break;
                        }
                        case 90: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAddStates(86, 89);
                            break;
                        }
                        case 91: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAdd(91);
                            break;
                        }
                        case 92: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(90, 92);
                            break;
                        }
                        case 94: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(94, 95);
                            break;
                        }
                        case 99: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(35, 37);
                            break;
                        }
                        case 104: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjAddStates(141, 142);
                            break;
                        }
                        case 108: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 43) continue block221;
                            kind = 43;
                            break;
                        }
                        case 109: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAddStates(103, 106);
                            break;
                        }
                        case 110: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAdd(110);
                            break;
                        }
                        case 111: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(107, 109);
                            break;
                        }
                        case 113: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(0, 6);
                            break;
                        }
                        case 114: 
                        case 116: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 45) {
                                kind = 45;
                            }
                            this.jjCheckNAddStates(110, 112);
                            break;
                        }
                        case 117: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjstateSet[this.jjnewStateCnt++] = 118;
                            break;
                        }
                        case 119: 
                        case 131: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(113, 116);
                            break;
                        }
                        case 120: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjstateSet[this.jjnewStateCnt++] = 121;
                            break;
                        }
                        case 122: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddTwoStates(122, 123);
                            break;
                        }
                        case 126: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 46) continue block221;
                            kind = 46;
                            break;
                        }
                        case 127: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 46) {
                                kind = 46;
                            }
                            this.jjCheckNAddStates(120, 123);
                            break;
                        }
                        case 128: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            if (kind > 46) {
                                kind = 46;
                            }
                            this.jjCheckNAdd(128);
                            break;
                        }
                        case 129: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block221;
                            this.jjCheckNAddStates(124, 126);
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block221;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 133 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private int jjMoveStringLiteralDfa0_4() {
        return this.jjMoveNfa_4(0, 0);
    }

    private int jjMoveNfa_4(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 25;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block46: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x2400L & l) != 0L) {
                                if (kind > 51) {
                                    kind = 51;
                                }
                            } else if (this.curChar == 32) {
                                if (kind > 52) {
                                    kind = 52;
                                }
                            } else if (this.curChar == 46) {
                                this.jjstateSet[this.jjnewStateCnt++] = 19;
                            } else if (this.curChar == 45) {
                                this.jjstateSet[this.jjnewStateCnt++] = 12;
                            } else if (this.curChar == 35) {
                                if (kind > 1) {
                                    kind = 1;
                                }
                                this.jjCheckNAddStates(20, 22);
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 21;
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block46;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block46;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block46;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if (this.curChar != 45) break;
                            this.jjCheckNAddStates(143, 145);
                            break;
                        }
                        case 6: {
                            if (this.curChar != 10 || kind <= 19) continue block46;
                            kind = 19;
                            break;
                        }
                        case 7: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 6;
                            break;
                        }
                        case 8: {
                            if ((0x2400L & l) == 0L || kind <= 19) continue block46;
                            kind = 19;
                            break;
                        }
                        case 9: {
                            if (this.curChar != 32) continue block46;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAddStates(146, 149);
                            break;
                        }
                        case 10: {
                            if (this.curChar != 32) continue block46;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 11: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(150, 152);
                            break;
                        }
                        case 12: {
                            if (this.curChar != 45) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 5;
                            break;
                        }
                        case 13: {
                            if (this.curChar != 45) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 12;
                            break;
                        }
                        case 14: {
                            if (this.curChar != 46) continue block46;
                            if (kind > 20) {
                                kind = 20;
                            }
                            this.jjCheckNAddStates(153, 155);
                            break;
                        }
                        case 15: {
                            if (this.curChar != 32) continue block46;
                            if (kind > 20) {
                                kind = 20;
                            }
                            this.jjCheckNAddStates(153, 155);
                            break;
                        }
                        case 16: {
                            if (this.curChar != 10 || kind <= 20) continue block46;
                            kind = 20;
                            break;
                        }
                        case 17: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 16;
                            break;
                        }
                        case 18: {
                            if ((0x2400L & l) == 0L || kind <= 20) continue block46;
                            kind = 20;
                            break;
                        }
                        case 19: {
                            if (this.curChar != 46) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 14;
                            break;
                        }
                        case 20: {
                            if (this.curChar != 46) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 19;
                            break;
                        }
                        case 21: {
                            if (this.curChar != 10 || kind <= 51) continue block46;
                            kind = 51;
                            break;
                        }
                        case 22: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 21;
                            break;
                        }
                        case 23: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block46;
                            kind = 51;
                            break;
                        }
                        case 24: {
                            if (this.curChar != 32 || kind <= 52) continue block46;
                            kind = 52;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        case 1: {
                            kind = 1;
                            this.jjAddStates(20, 22);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block48: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block48;
                            kind = 52;
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block48;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block48;
                            kind = 1;
                            break;
                        }
                        case 8: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 19) continue block48;
                            kind = 19;
                            break;
                        }
                        case 9: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block48;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAddStates(146, 149);
                            break;
                        }
                        case 10: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block48;
                            if (kind > 19) {
                                kind = 19;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 11: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block48;
                            this.jjCheckNAddStates(150, 152);
                            break;
                        }
                        case 15: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block48;
                            if (kind > 20) {
                                kind = 20;
                            }
                            this.jjAddStates(153, 155);
                            break;
                        }
                        case 18: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 20) continue block48;
                            kind = 20;
                            break;
                        }
                        case 23: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block48;
                            kind = 51;
                            break;
                        }
                        case 24: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block48;
                            kind = 52;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block48;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 25 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_3(int pos, long active0) {
        switch (pos) {
            default: 
        }
        return -1;
    }

    private final int jjStartNfa_3(int pos, long active0) {
        return this.jjMoveNfa_3(this.jjStopStringLiteralDfa_3(pos, active0), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_3() {
        switch (this.curChar) {
            case 34: {
                return this.jjStopAtPos(0, 34);
            }
        }
        return this.jjMoveNfa_3(0, 0);
    }

    private int jjMoveNfa_3(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 21;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block44: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) != 0L) {
                                if (kind > 33) {
                                    kind = 33;
                                }
                                this.jjCheckNAddTwoStates(5, 6);
                            } else if ((0x2400L & l) != 0L && kind > 51) {
                                kind = 51;
                            }
                            if (this.curChar == 32) {
                                if (kind > 52) {
                                    kind = 52;
                                }
                                this.jjCheckNAddTwoStates(19, 20);
                                break;
                            }
                            if (this.curChar == 13) {
                                this.jjstateSet[this.jjnewStateCnt++] = 10;
                                break;
                            }
                            if (this.curChar != 35) break;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block44;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block44;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block44;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) == 0L) continue block44;
                            if (kind > 33) {
                                kind = 33;
                            }
                            this.jjCheckNAddTwoStates(5, 6);
                            break;
                        }
                        case 8: {
                            if ((0x3FF000000000000L & l) == 0L) continue block44;
                            if (kind > 33) {
                                kind = 33;
                            }
                            this.jjCheckNAddStates(156, 158);
                            break;
                        }
                        case 9: {
                            if ((0x1800400000000L & l) == 0L) continue block44;
                            if (kind > 33) {
                                kind = 33;
                            }
                            this.jjCheckNAddTwoStates(5, 6);
                            break;
                        }
                        case 10: {
                            if (this.curChar != 10 || kind <= 51) continue block44;
                            kind = 51;
                            break;
                        }
                        case 11: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 10;
                            break;
                        }
                        case 12: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block44;
                            kind = 51;
                            break;
                        }
                        case 14: {
                            if (this.curChar != 32) break;
                            this.jjAddStates(159, 161);
                            break;
                        }
                        case 15: {
                            if (this.curChar != 10 || kind <= 31) continue block44;
                            kind = 31;
                            break;
                        }
                        case 16: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 15;
                            break;
                        }
                        case 17: {
                            if ((0x2400L & l) == 0L || kind <= 31) continue block44;
                            kind = 31;
                            break;
                        }
                        case 18: {
                            if (this.curChar != 32) continue block44;
                            if (kind > 52) {
                                kind = 52;
                            }
                            this.jjCheckNAddTwoStates(19, 20);
                            break;
                        }
                        case 19: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(19, 20);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                block45: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) != 0L) {
                                if (kind > 33) {
                                    kind = 33;
                                }
                                this.jjCheckNAddTwoStates(5, 6);
                                break;
                            }
                            if (this.curChar != 92) break;
                            if (kind > 32) {
                                kind = 32;
                            }
                            this.jjCheckNAddStates(162, 166);
                            break;
                        }
                        case 1: {
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 5: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) continue block45;
                            if (kind > 33) {
                                kind = 33;
                            }
                            this.jjCheckNAddTwoStates(5, 6);
                            break;
                        }
                        case 6: {
                            if (this.curChar != 92) break;
                            this.jjCheckNAddTwoStates(7, 9);
                            break;
                        }
                        case 7: {
                            if (this.curChar != 120) break;
                            this.jjCheckNAdd(8);
                            break;
                        }
                        case 8: {
                            if ((0x7E0000007EL & l) == 0L) continue block45;
                            if (kind > 33) {
                                kind = 33;
                            }
                            this.jjCheckNAddStates(156, 158);
                            break;
                        }
                        case 9: {
                            if ((0x55406490004000L & l) == 0L) continue block45;
                            if (kind > 33) {
                                kind = 33;
                            }
                            this.jjCheckNAddTwoStates(5, 6);
                            break;
                        }
                        case 13: {
                            if (this.curChar != 92) continue block45;
                            if (kind > 32) {
                                kind = 32;
                            }
                            this.jjCheckNAddStates(162, 166);
                            break;
                        }
                        case 20: {
                            if (this.curChar != 92 || kind <= 32) continue block45;
                            kind = 32;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block46: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 33) {
                                    kind = 33;
                                }
                                this.jjCheckNAddTwoStates(5, 6);
                            }
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block46;
                            if (kind > 52) {
                                kind = 52;
                            }
                            this.jjCheckNAddTwoStates(19, 20);
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block46;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block46;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block46;
                            if (kind > 33) {
                                kind = 33;
                            }
                            this.jjCheckNAddTwoStates(5, 6);
                            break;
                        }
                        case 12: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block46;
                            kind = 51;
                            break;
                        }
                        case 14: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block46;
                            this.jjAddStates(159, 161);
                            break;
                        }
                        case 17: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 31) continue block46;
                            kind = 31;
                            break;
                        }
                        case 18: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block46;
                            if (kind > 52) {
                                kind = 52;
                            }
                            this.jjCheckNAddTwoStates(19, 20);
                            break;
                        }
                        case 19: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block46;
                            this.jjCheckNAddTwoStates(19, 20);
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block46;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 21 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private int jjMoveStringLiteralDfa0_1() {
        return this.jjMoveNfa_1(0, 0);
    }

    private int jjMoveNfa_1(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 15;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block34: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xFFFFFFF6FFFFDBFFL & l) != 0L) {
                                if (kind > 47) {
                                    kind = 47;
                                }
                                this.jjCheckNAddStates(167, 169);
                            } else if ((0x2400L & l) != 0L) {
                                if (kind > 51) {
                                    kind = 51;
                                }
                            } else if (this.curChar == 32) {
                                if (kind > 52) {
                                    kind = 52;
                                }
                            } else if (this.curChar == 35) {
                                if (kind > 1) {
                                    kind = 1;
                                }
                                this.jjCheckNAddStates(20, 22);
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 11;
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block34;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block34;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block34;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if ((0xFFFFFFF6FFFFDBFFL & l) == 0L) continue block34;
                            if (kind > 47) {
                                kind = 47;
                            }
                            this.jjCheckNAddStates(167, 169);
                            break;
                        }
                        case 6: {
                            if ((0xFBFFFFF7FFFFDBFFL & l) == 0L) continue block34;
                            if (kind > 47) {
                                kind = 47;
                            }
                            this.jjCheckNAddStates(167, 169);
                            break;
                        }
                        case 7: {
                            if (this.curChar != 58) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 8;
                            break;
                        }
                        case 8: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) continue block34;
                            if (kind > 47) {
                                kind = 47;
                            }
                            this.jjCheckNAddStates(167, 169);
                            break;
                        }
                        case 9: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 10;
                            break;
                        }
                        case 10: {
                            if (this.curChar != 35) continue block34;
                            if (kind > 47) {
                                kind = 47;
                            }
                            this.jjCheckNAddStates(167, 169);
                            break;
                        }
                        case 11: {
                            if (this.curChar != 10 || kind <= 51) continue block34;
                            kind = 51;
                            break;
                        }
                        case 12: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 11;
                            break;
                        }
                        case 13: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block34;
                            kind = 51;
                            break;
                        }
                        case 14: {
                            if (this.curChar != 32 || kind <= 52) continue block34;
                            kind = 52;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 6: 
                        case 8: {
                            if (kind > 47) {
                                kind = 47;
                            }
                            this.jjCheckNAddStates(167, 169);
                            break;
                        }
                        case 1: {
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 9: {
                            this.jjstateSet[this.jjnewStateCnt++] = 10;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block36: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 47) {
                                    kind = 47;
                                }
                                this.jjCheckNAddStates(167, 169);
                            }
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block36;
                            kind = 52;
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block36;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block36;
                            kind = 1;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 8: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block36;
                            if (kind > 47) {
                                kind = 47;
                            }
                            this.jjCheckNAddStates(167, 169);
                            break;
                        }
                        case 9: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block36;
                            this.jjstateSet[this.jjnewStateCnt++] = 10;
                            break;
                        }
                        case 13: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block36;
                            kind = 51;
                            break;
                        }
                        case 14: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block36;
                            kind = 52;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block36;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 15 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_5(int pos, long active0) {
        switch (pos) {
            case 0: {
                if ((active0 & 0x10000000L) != 0L) {
                    return 109;
                }
                if ((active0 & 0x8000000L) != 0L) {
                    return 110;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_5(int pos, long active0) {
        return this.jjMoveNfa_5(this.jjStopStringLiteralDfa_5(pos, active0), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_5() {
        switch (this.curChar) {
            case 34: {
                return this.jjMoveStringLiteralDfa1_5(0x10000000L);
            }
            case 39: {
                return this.jjMoveStringLiteralDfa1_5(0x8000000L);
            }
            case 91: {
                return this.jjStopAtPos(0, 14);
            }
            case 93: {
                return this.jjStopAtPos(0, 16);
            }
            case 123: {
                return this.jjStopAtPos(0, 15);
            }
            case 125: {
                return this.jjStopAtPos(0, 17);
            }
        }
        return this.jjMoveNfa_5(0, 0);
    }

    private int jjMoveStringLiteralDfa1_5(long active0) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_5(0, active0);
            return 1;
        }
        switch (this.curChar) {
            case 34: {
                if ((active0 & 0x10000000L) == 0L) break;
                return this.jjStopAtPos(1, 28);
            }
            case 39: {
                if ((active0 & 0x8000000L) == 0L) break;
                return this.jjStartNfaWithStates_5(1, 27, 57);
            }
        }
        return this.jjStartNfa_5(0, active0);
    }

    private int jjStartNfaWithStates_5(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_5(state, pos + 1);
    }

    private int jjMoveNfa_5(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 109;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block188: do {
                    switch (this.jjstateSet[--i]) {
                        case 57: {
                            if (this.curChar == 39) {
                                this.jjCheckNAddStates(170, 172);
                            }
                            if (this.curChar != 39) break;
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(56, 58);
                            break;
                        }
                        case 0: {
                            if ((0x3BFFCB10FFFFDBFFL & l) != 0L) {
                                if (kind > 49) {
                                    kind = 49;
                                }
                                this.jjCheckNAddStates(173, 178);
                            } else if ((0x100002400L & l) != 0L) {
                                this.jjCheckNAddStates(7, 9);
                            } else if ((0x8400200000000000L & l) != 0L) {
                                this.jjAddStates(179, 180);
                            } else if (this.curChar == 34) {
                                this.jjCheckNAddStates(181, 184);
                            } else if (this.curChar == 39) {
                                this.jjCheckNAddStates(185, 188);
                            } else if (this.curChar == 37) {
                                this.jjAddStates(189, 190);
                            } else if (this.curChar == 44) {
                                if (kind > 18) {
                                    kind = 18;
                                }
                                this.jjCheckNAddStates(53, 55);
                            } else if (this.curChar == 42) {
                                this.jjCheckNAddTwoStates(23, 24);
                            } else if (this.curChar == 38) {
                                this.jjCheckNAdd(18);
                            } else if (this.curChar == 33) {
                                this.jjstateSet[this.jjnewStateCnt++] = 15;
                            } else if (this.curChar == 35) {
                                if (kind > 1) {
                                    kind = 1;
                                }
                                this.jjCheckNAddStates(20, 22);
                            }
                            if ((0x2400L & l) != 0L) {
                                if (kind > 51) {
                                    kind = 51;
                                }
                            } else if (this.curChar == 32) {
                                if (kind > 52) {
                                    kind = 52;
                                }
                            } else if (this.curChar == 33) {
                                this.jjCheckNAddStates(26, 31);
                            }
                            if (this.curChar != 13) break;
                            this.jjCheckNAddTwoStates(20, 54);
                            break;
                        }
                        case 109: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) != 0L) {
                                this.jjCheckNAddStates(191, 193);
                            }
                            if ((0xFFFFFFFBFFFFC9FFL & l) == 0L) break;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(72, 73);
                            break;
                        }
                        case 110: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) != 0L) {
                                this.jjCheckNAddStates(170, 172);
                            } else if (this.curChar == 39) {
                                this.jjstateSet[this.jjnewStateCnt++] = 60;
                            }
                            if ((0xFFFFFF7FFFFFDBFFL & l) != 0L) {
                                if (kind > 29) {
                                    kind = 29;
                                }
                                this.jjCheckNAddTwoStates(56, 58);
                                break;
                            }
                            if (this.curChar != 39) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 57;
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block188;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block188;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block188;
                            kind = 1;
                            break;
                        }
                        case 5: 
                        case 15: {
                            if (this.curChar != 33) break;
                            this.jjCheckNAddStates(26, 31);
                            break;
                        }
                        case 6: {
                            if (this.curChar != 60) break;
                            this.jjCheckNAddStates(38, 42);
                            break;
                        }
                        case 7: {
                            if ((0xAFFFFFFA00000000L & l) == 0L) break;
                            this.jjCheckNAddStates(38, 42);
                            break;
                        }
                        case 8: {
                            if (this.curChar != 62) break;
                            this.jjCheckNAddStates(43, 45);
                            break;
                        }
                        case 9: {
                            if (this.curChar != 10 || kind <= 9) continue block188;
                            kind = 9;
                            break;
                        }
                        case 10: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 9;
                            break;
                        }
                        case 11: {
                            if ((0x2400L & l) == 0L || kind <= 9) continue block188;
                            kind = 9;
                            break;
                        }
                        case 12: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAddStates(46, 49);
                            break;
                        }
                        case 13: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAdd(13);
                            break;
                        }
                        case 14: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(50, 52);
                            break;
                        }
                        case 16: {
                            if (this.curChar != 33) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 15;
                            break;
                        }
                        case 17: {
                            if (this.curChar != 38) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 18: {
                            if ((0x3FF200000000000L & l) == 0L) continue block188;
                            if (kind > 12) {
                                kind = 12;
                            }
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 19: {
                            if ((0x100002400L & l) == 0L) break;
                            this.jjCheckNAddStates(7, 9);
                            break;
                        }
                        case 20: {
                            if (this.curChar != 10) break;
                            this.jjCheckNAddStates(7, 9);
                            break;
                        }
                        case 21: {
                            if (this.curChar != 13) break;
                            this.jjCheckNAdd(20);
                            break;
                        }
                        case 22: {
                            if (this.curChar != 42) break;
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 23: {
                            if ((0x3BFFCB10FFFFDBFFL & l) == 0L) continue block188;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 24: {
                            if ((0x8400200000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 25;
                            break;
                        }
                        case 25: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) continue block188;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 26: {
                            if (this.curChar != 44) continue block188;
                            if (kind > 18) {
                                kind = 18;
                            }
                            this.jjCheckNAddStates(53, 55);
                            break;
                        }
                        case 27: {
                            if (this.curChar != 10 || kind <= 18) continue block188;
                            kind = 18;
                            break;
                        }
                        case 28: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 27;
                            break;
                        }
                        case 29: {
                            if ((0x2400L & l) == 0L || kind <= 18) continue block188;
                            kind = 18;
                            break;
                        }
                        case 30: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 18) {
                                kind = 18;
                            }
                            this.jjCheckNAddStates(56, 59);
                            break;
                        }
                        case 31: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 18) {
                                kind = 18;
                            }
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 32: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(60, 62);
                            break;
                        }
                        case 33: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block188;
                            kind = 51;
                            break;
                        }
                        case 34: {
                            if (this.curChar != 32 || kind <= 52) continue block188;
                            kind = 52;
                            break;
                        }
                        case 35: {
                            if (this.curChar != 37) break;
                            this.jjAddStates(189, 190);
                            break;
                        }
                        case 37: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(194, 197);
                            break;
                        }
                        case 38: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(198, 200);
                            break;
                        }
                        case 39: {
                            if (this.curChar != 10 || kind <= 10) continue block188;
                            kind = 10;
                            break;
                        }
                        case 40: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 39;
                            break;
                        }
                        case 41: {
                            if ((0x2400L & l) == 0L || kind <= 10) continue block188;
                            kind = 10;
                            break;
                        }
                        case 45: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(45, 46);
                            break;
                        }
                        case 46: {
                            if ((0x3FF400000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(201, 203);
                            break;
                        }
                        case 47: {
                            if (this.curChar != 10 || kind <= 11) continue block188;
                            kind = 11;
                            break;
                        }
                        case 48: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 47;
                            break;
                        }
                        case 49: {
                            if ((0x2400L & l) == 0L || kind <= 11) continue block188;
                            kind = 11;
                            break;
                        }
                        case 53: {
                            if (this.curChar != 13) break;
                            this.jjCheckNAddTwoStates(20, 54);
                            break;
                        }
                        case 54: {
                            if (this.curChar != 10 || kind <= 51) continue block188;
                            kind = 51;
                            break;
                        }
                        case 55: {
                            if (this.curChar != 39) break;
                            this.jjCheckNAddStates(185, 188);
                            break;
                        }
                        case 56: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) == 0L) continue block188;
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(56, 58);
                            break;
                        }
                        case 58: {
                            if (this.curChar != 39) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 57;
                            break;
                        }
                        case 59: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(170, 172);
                            break;
                        }
                        case 60: {
                            if (this.curChar != 39) break;
                            this.jjCheckNAddStates(170, 172);
                            break;
                        }
                        case 61: {
                            if (this.curChar != 39) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 60;
                            break;
                        }
                        case 62: {
                            if (this.curChar != 39) break;
                            this.jjCheckNAddTwoStates(63, 64);
                            break;
                        }
                        case 63: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(63, 64);
                            break;
                        }
                        case 64: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAddStates(204, 206);
                            break;
                        }
                        case 65: {
                            if (this.curChar != 10 || kind <= 42) continue block188;
                            kind = 42;
                            break;
                        }
                        case 66: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 65;
                            break;
                        }
                        case 67: {
                            if ((0x2400L & l) == 0L || kind <= 42) continue block188;
                            kind = 42;
                            break;
                        }
                        case 68: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAddStates(207, 210);
                            break;
                        }
                        case 69: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAdd(69);
                            break;
                        }
                        case 70: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(211, 213);
                            break;
                        }
                        case 71: {
                            if (this.curChar != 34) break;
                            this.jjCheckNAddStates(181, 184);
                            break;
                        }
                        case 72: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) == 0L) continue block188;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(72, 73);
                            break;
                        }
                        case 75: {
                            if ((0x3FF000000000000L & l) == 0L) continue block188;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddStates(214, 216);
                            break;
                        }
                        case 76: {
                            if ((0x1800400000000L & l) == 0L) continue block188;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(72, 73);
                            break;
                        }
                        case 77: {
                            if ((0xFFFFFFFBFFFFC9FFL & l) == 0L) break;
                            this.jjCheckNAddStates(191, 193);
                            break;
                        }
                        case 80: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(217, 220);
                            break;
                        }
                        case 81: {
                            if (this.curChar != 34) break;
                            this.jjCheckNAddTwoStates(82, 83);
                            break;
                        }
                        case 82: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(82, 83);
                            break;
                        }
                        case 83: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAddStates(221, 223);
                            break;
                        }
                        case 84: {
                            if (this.curChar != 10 || kind <= 43) continue block188;
                            kind = 43;
                            break;
                        }
                        case 85: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 84;
                            break;
                        }
                        case 86: {
                            if ((0x2400L & l) == 0L || kind <= 43) continue block188;
                            kind = 43;
                            break;
                        }
                        case 87: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAddStates(224, 227);
                            break;
                        }
                        case 88: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAdd(88);
                            break;
                        }
                        case 89: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(228, 230);
                            break;
                        }
                        case 90: {
                            if ((0x1800400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(191, 193);
                            break;
                        }
                        case 91: {
                            if ((0x3BFFCB10FFFFDBFFL & l) == 0L) continue block188;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddStates(173, 178);
                            break;
                        }
                        case 92: {
                            if ((0x7BFFEFF7FFFFDBFFL & l) == 0L) continue block188;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddTwoStates(92, 93);
                            break;
                        }
                        case 93: {
                            if ((0xFFFFFFFEFFFFFFFFL & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 94;
                            break;
                        }
                        case 94: {
                            if (this.curChar != 35) continue block188;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddTwoStates(92, 93);
                            break;
                        }
                        case 95: {
                            if ((0x7BFFEFF7FFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(231, 234);
                            break;
                        }
                        case 96: {
                            if ((0xFFFFFFFEFFFFFFFFL & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 97;
                            break;
                        }
                        case 97: {
                            if (this.curChar != 35) break;
                            this.jjCheckNAddStates(231, 234);
                            break;
                        }
                        case 98: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddTwoStates(98, 99);
                            break;
                        }
                        case 99: {
                            if (this.curChar != 58) break;
                            this.jjCheckNAddStates(235, 237);
                            break;
                        }
                        case 100: {
                            if (this.curChar != 10 || kind <= 50) continue block188;
                            kind = 50;
                            break;
                        }
                        case 101: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 100;
                            break;
                        }
                        case 102: {
                            if ((0x2400L & l) == 0L || kind <= 50) continue block188;
                            kind = 50;
                            break;
                        }
                        case 103: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 50) {
                                kind = 50;
                            }
                            this.jjCheckNAddStates(238, 241);
                            break;
                        }
                        case 104: {
                            if (this.curChar != 32) continue block188;
                            if (kind > 50) {
                                kind = 50;
                            }
                            this.jjCheckNAdd(104);
                            break;
                        }
                        case 105: {
                            if (this.curChar != 32) break;
                            this.jjCheckNAddStates(242, 244);
                            break;
                        }
                        case 106: {
                            if ((0x8400200000000000L & l) == 0L) break;
                            this.jjAddStates(179, 180);
                            break;
                        }
                        case 107: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) continue block188;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddTwoStates(92, 93);
                            break;
                        }
                        case 108: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(231, 234);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                block189: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xC7FFFFFED7FFFFFEL & l) == 0L) continue block189;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddStates(173, 178);
                            break;
                        }
                        case 109: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) != 0L) {
                                this.jjCheckNAddStates(191, 193);
                            } else if (this.curChar == 92) {
                                this.jjAddStates(245, 246);
                            }
                            if ((0xFFFFFFFFEFFFFFFFL & l) != 0L) {
                                if (kind > 30) {
                                    kind = 30;
                                }
                                this.jjCheckNAddTwoStates(72, 73);
                                break;
                            }
                            if (this.curChar != 92) break;
                            this.jjAddStates(247, 248);
                            break;
                        }
                        case 110: {
                            this.jjCheckNAddStates(170, 172);
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(56, 58);
                            break;
                        }
                        case 1: {
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 7: {
                            if ((0x47FFFFFEAFFFFFFFL & l) == 0L) break;
                            this.jjAddStates(38, 42);
                            break;
                        }
                        case 18: {
                            if ((0x7FFFFFE87FFFFFEL & l) == 0L) continue block189;
                            if (kind > 12) {
                                kind = 12;
                            }
                            this.jjstateSet[this.jjnewStateCnt++] = 18;
                            break;
                        }
                        case 23: {
                            if ((0xC7FFFFFED7FFFFFEL & l) == 0L) continue block189;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 25: {
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 36: {
                            if (this.curChar != 71) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 37;
                            break;
                        }
                        case 38: {
                            this.jjAddStates(198, 200);
                            break;
                        }
                        case 42: {
                            if (this.curChar != 65) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 36;
                            break;
                        }
                        case 43: {
                            if (this.curChar != 84) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 42;
                            break;
                        }
                        case 44: {
                            if (this.curChar != 76) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 45;
                            break;
                        }
                        case 50: {
                            if (this.curChar != 77) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 44;
                            break;
                        }
                        case 51: {
                            if (this.curChar != 65) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 50;
                            break;
                        }
                        case 52: {
                            if (this.curChar != 89) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 51;
                            break;
                        }
                        case 56: {
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(56, 58);
                            break;
                        }
                        case 59: {
                            this.jjCheckNAddStates(170, 172);
                            break;
                        }
                        case 72: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) continue block189;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(72, 73);
                            break;
                        }
                        case 73: {
                            if (this.curChar != 92) break;
                            this.jjAddStates(247, 248);
                            break;
                        }
                        case 74: {
                            if (this.curChar != 120) break;
                            this.jjCheckNAdd(75);
                            break;
                        }
                        case 75: {
                            if ((0x7E0000007EL & l) == 0L) continue block189;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddStates(214, 216);
                            break;
                        }
                        case 76: {
                            if ((0x55406490004000L & l) == 0L) continue block189;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(72, 73);
                            break;
                        }
                        case 77: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(191, 193);
                            break;
                        }
                        case 78: {
                            if (this.curChar != 92) break;
                            this.jjAddStates(245, 246);
                            break;
                        }
                        case 79: {
                            if (this.curChar != 120) break;
                            this.jjCheckNAdd(80);
                            break;
                        }
                        case 80: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(217, 220);
                            break;
                        }
                        case 90: {
                            if ((0x55406490004000L & l) == 0L) break;
                            this.jjCheckNAddStates(191, 193);
                            break;
                        }
                        case 92: {
                            if ((0xD7FFFFFFD7FFFFFFL & l) == 0L) continue block189;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddTwoStates(92, 93);
                            break;
                        }
                        case 93: {
                            this.jjstateSet[this.jjnewStateCnt++] = 94;
                            break;
                        }
                        case 95: {
                            if ((0xD7FFFFFFD7FFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(231, 234);
                            break;
                        }
                        case 96: {
                            this.jjstateSet[this.jjnewStateCnt++] = 97;
                            break;
                        }
                        case 107: {
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddTwoStates(92, 93);
                            break;
                        }
                        case 108: {
                            this.jjCheckNAddStates(231, 234);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block190: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_3(hiByte, i1, i2, l1, l2)) {
                                this.jjCheckNAddStates(7, 9);
                            }
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52) {
                                kind = 52;
                            }
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddStates(173, 178);
                            break;
                        }
                        case 109: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 30) {
                                    kind = 30;
                                }
                                this.jjCheckNAddTwoStates(72, 73);
                            }
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(191, 193);
                            break;
                        }
                        case 110: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 29) {
                                    kind = 29;
                                }
                                this.jjCheckNAddTwoStates(56, 58);
                            }
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(170, 172);
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block190;
                            kind = 1;
                            break;
                        }
                        case 11: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 9) continue block190;
                            kind = 9;
                            break;
                        }
                        case 12: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAddStates(46, 49);
                            break;
                        }
                        case 13: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 9) {
                                kind = 9;
                            }
                            this.jjCheckNAdd(13);
                            break;
                        }
                        case 14: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(50, 52);
                            break;
                        }
                        case 19: {
                            if (!YamlParserTokenManager.jjCanMove_3(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(7, 9);
                            break;
                        }
                        case 23: 
                        case 25: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 13) {
                                kind = 13;
                            }
                            this.jjCheckNAddTwoStates(23, 24);
                            break;
                        }
                        case 29: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 18) continue block190;
                            kind = 18;
                            break;
                        }
                        case 30: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 18) {
                                kind = 18;
                            }
                            this.jjCheckNAddStates(56, 59);
                            break;
                        }
                        case 31: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 18) {
                                kind = 18;
                            }
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 32: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(60, 62);
                            break;
                        }
                        case 33: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block190;
                            kind = 51;
                            break;
                        }
                        case 34: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block190;
                            kind = 52;
                            break;
                        }
                        case 37: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(194, 197);
                            break;
                        }
                        case 38: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(198, 200);
                            break;
                        }
                        case 41: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 10) continue block190;
                            kind = 10;
                            break;
                        }
                        case 45: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjAddStates(249, 250);
                            break;
                        }
                        case 49: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 11) continue block190;
                            kind = 11;
                            break;
                        }
                        case 56: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 29) {
                                kind = 29;
                            }
                            this.jjCheckNAddTwoStates(56, 58);
                            break;
                        }
                        case 59: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(170, 172);
                            break;
                        }
                        case 63: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjAddStates(251, 252);
                            break;
                        }
                        case 67: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 42) continue block190;
                            kind = 42;
                            break;
                        }
                        case 68: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAddStates(207, 210);
                            break;
                        }
                        case 69: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 42) {
                                kind = 42;
                            }
                            this.jjCheckNAdd(69);
                            break;
                        }
                        case 70: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(211, 213);
                            break;
                        }
                        case 72: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 30) {
                                kind = 30;
                            }
                            this.jjCheckNAddTwoStates(72, 73);
                            break;
                        }
                        case 77: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(191, 193);
                            break;
                        }
                        case 82: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjAddStates(253, 254);
                            break;
                        }
                        case 86: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 43) continue block190;
                            kind = 43;
                            break;
                        }
                        case 87: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAddStates(224, 227);
                            break;
                        }
                        case 88: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 43) {
                                kind = 43;
                            }
                            this.jjCheckNAdd(88);
                            break;
                        }
                        case 89: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(228, 230);
                            break;
                        }
                        case 91: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddStates(173, 178);
                            break;
                        }
                        case 92: 
                        case 107: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 49) {
                                kind = 49;
                            }
                            this.jjCheckNAddTwoStates(92, 93);
                            break;
                        }
                        case 93: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjstateSet[this.jjnewStateCnt++] = 94;
                            break;
                        }
                        case 95: 
                        case 108: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(231, 234);
                            break;
                        }
                        case 96: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjstateSet[this.jjnewStateCnt++] = 97;
                            break;
                        }
                        case 98: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddTwoStates(98, 99);
                            break;
                        }
                        case 102: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 50) continue block190;
                            kind = 50;
                            break;
                        }
                        case 103: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 50) {
                                kind = 50;
                            }
                            this.jjCheckNAddStates(238, 241);
                            break;
                        }
                        case 104: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            if (kind > 50) {
                                kind = 50;
                            }
                            this.jjCheckNAdd(104);
                            break;
                        }
                        case 105: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2)) continue block190;
                            this.jjCheckNAddStates(242, 244);
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block190;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 109 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_6(int pos, long active0) {
        switch (pos) {
            default: 
        }
        return -1;
    }

    private final int jjStartNfa_6(int pos, long active0) {
        return this.jjMoveNfa_6(this.jjStopStringLiteralDfa_6(pos, active0), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_6() {
        switch (this.curChar) {
            case 66: {
                return this.jjMoveStringLiteralDfa1_6(28L);
            }
            case 70: {
                return this.jjMoveStringLiteralDfa1_6(64L);
            }
            case 78: {
                return this.jjMoveStringLiteralDfa1_6(32L);
            }
        }
        return this.jjMoveNfa_6(0, 0);
    }

    private int jjMoveStringLiteralDfa1_6(long active0) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(0, active0);
            return 1;
        }
        switch (this.curChar) {
            case 65: {
                return this.jjMoveStringLiteralDfa2_6(active0, 64L);
            }
            case 76: {
                return this.jjMoveStringLiteralDfa2_6(active0, 28L);
            }
            case 85: {
                return this.jjMoveStringLiteralDfa2_6(active0, 32L);
            }
        }
        return this.jjStartNfa_6(0, active0);
    }

    private int jjMoveStringLiteralDfa2_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(0, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(1, active0);
            return 2;
        }
        switch (this.curChar) {
            case 76: {
                return this.jjMoveStringLiteralDfa3_6(active0, 96L);
            }
            case 79: {
                return this.jjMoveStringLiteralDfa3_6(active0, 28L);
            }
        }
        return this.jjStartNfa_6(1, active0);
    }

    private int jjMoveStringLiteralDfa3_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(1, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(2, active0);
            return 3;
        }
        switch (this.curChar) {
            case 67: {
                return this.jjMoveStringLiteralDfa4_6(active0, 28L);
            }
            case 76: {
                return this.jjMoveStringLiteralDfa4_6(active0, 32L);
            }
            case 83: {
                return this.jjMoveStringLiteralDfa4_6(active0, 64L);
            }
        }
        return this.jjStartNfa_6(2, active0);
    }

    private int jjMoveStringLiteralDfa4_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(2, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(3, active0);
            return 4;
        }
        switch (this.curChar) {
            case 69: {
                return this.jjMoveStringLiteralDfa5_6(active0, 64L);
            }
            case 75: {
                return this.jjMoveStringLiteralDfa5_6(active0, 28L);
            }
            case 95: {
                return this.jjMoveStringLiteralDfa5_6(active0, 32L);
            }
        }
        return this.jjStartNfa_6(3, active0);
    }

    private int jjMoveStringLiteralDfa5_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(3, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(4, active0);
            return 5;
        }
        switch (this.curChar) {
            case 83: {
                return this.jjMoveStringLiteralDfa6_6(active0, 32L);
            }
            case 95: {
                return this.jjMoveStringLiteralDfa6_6(active0, 92L);
            }
        }
        return this.jjStartNfa_6(4, active0);
    }

    private int jjMoveStringLiteralDfa6_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(4, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(5, active0);
            return 6;
        }
        switch (this.curChar) {
            case 67: {
                return this.jjMoveStringLiteralDfa7_6(active0, 32L);
            }
            case 69: {
                return this.jjMoveStringLiteralDfa7_6(active0, 16L);
            }
            case 77: {
                return this.jjMoveStringLiteralDfa7_6(active0, 8L);
            }
            case 83: {
                return this.jjMoveStringLiteralDfa7_6(active0, 68L);
            }
        }
        return this.jjStartNfa_6(5, active0);
    }

    private int jjMoveStringLiteralDfa7_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(5, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(6, active0);
            return 7;
        }
        switch (this.curChar) {
            case 65: {
                return this.jjMoveStringLiteralDfa8_6(active0, 40L);
            }
            case 69: {
                return this.jjMoveStringLiteralDfa8_6(active0, 4L);
            }
            case 78: {
                return this.jjMoveStringLiteralDfa8_6(active0, 16L);
            }
            case 84: {
                return this.jjMoveStringLiteralDfa8_6(active0, 64L);
            }
        }
        return this.jjStartNfa_6(6, active0);
    }

    private int jjMoveStringLiteralDfa8_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(6, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(7, active0);
            return 8;
        }
        switch (this.curChar) {
            case 65: {
                return this.jjMoveStringLiteralDfa9_6(active0, 64L);
            }
            case 68: {
                if ((active0 & 0x10L) == 0L) break;
                return this.jjStopAtPos(8, 4);
            }
            case 76: {
                return this.jjMoveStringLiteralDfa9_6(active0, 32L);
            }
            case 80: {
                return this.jjMoveStringLiteralDfa9_6(active0, 8L);
            }
            case 81: {
                return this.jjMoveStringLiteralDfa9_6(active0, 4L);
            }
        }
        return this.jjStartNfa_6(7, active0);
    }

    private int jjMoveStringLiteralDfa9_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(7, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(8, active0);
            return 9;
        }
        switch (this.curChar) {
            case 65: {
                return this.jjMoveStringLiteralDfa10_6(active0, 32L);
            }
            case 80: {
                return this.jjMoveStringLiteralDfa10_6(active0, 8L);
            }
            case 82: {
                return this.jjMoveStringLiteralDfa10_6(active0, 64L);
            }
            case 85: {
                return this.jjMoveStringLiteralDfa10_6(active0, 4L);
            }
        }
        return this.jjStartNfa_6(8, active0);
    }

    private int jjMoveStringLiteralDfa10_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(8, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(9, active0);
            return 10;
        }
        switch (this.curChar) {
            case 69: {
                return this.jjMoveStringLiteralDfa11_6(active0, 4L);
            }
            case 73: {
                return this.jjMoveStringLiteralDfa11_6(active0, 8L);
            }
            case 82: {
                if ((active0 & 0x20L) == 0L) break;
                return this.jjStopAtPos(10, 5);
            }
            case 84: {
                if ((active0 & 0x40L) == 0L) break;
                return this.jjStopAtPos(10, 6);
            }
        }
        return this.jjStartNfa_6(9, active0);
    }

    private int jjMoveStringLiteralDfa11_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(9, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(10, active0);
            return 11;
        }
        switch (this.curChar) {
            case 78: {
                return this.jjMoveStringLiteralDfa12_6(active0, 12L);
            }
        }
        return this.jjStartNfa_6(10, active0);
    }

    private int jjMoveStringLiteralDfa12_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(10, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(11, active0);
            return 12;
        }
        switch (this.curChar) {
            case 67: {
                return this.jjMoveStringLiteralDfa13_6(active0, 4L);
            }
            case 71: {
                return this.jjMoveStringLiteralDfa13_6(active0, 8L);
            }
        }
        return this.jjStartNfa_6(11, active0);
    }

    private int jjMoveStringLiteralDfa13_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(11, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(12, active0);
            return 13;
        }
        switch (this.curChar) {
            case 69: {
                return this.jjMoveStringLiteralDfa14_6(active0, 4L);
            }
            case 95: {
                return this.jjMoveStringLiteralDfa14_6(active0, 8L);
            }
        }
        return this.jjStartNfa_6(12, active0);
    }

    private int jjMoveStringLiteralDfa14_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(12, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(13, active0);
            return 14;
        }
        switch (this.curChar) {
            case 83: {
                return this.jjMoveStringLiteralDfa15_6(active0, 8L);
            }
            case 95: {
                return this.jjMoveStringLiteralDfa15_6(active0, 4L);
            }
        }
        return this.jjStartNfa_6(13, active0);
    }

    private int jjMoveStringLiteralDfa15_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(13, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(14, active0);
            return 15;
        }
        switch (this.curChar) {
            case 83: {
                return this.jjMoveStringLiteralDfa16_6(active0, 4L);
            }
            case 84: {
                return this.jjMoveStringLiteralDfa16_6(active0, 8L);
            }
        }
        return this.jjStartNfa_6(14, active0);
    }

    private int jjMoveStringLiteralDfa16_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(14, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(15, active0);
            return 16;
        }
        switch (this.curChar) {
            case 65: {
                return this.jjMoveStringLiteralDfa17_6(active0, 8L);
            }
            case 84: {
                return this.jjMoveStringLiteralDfa17_6(active0, 4L);
            }
        }
        return this.jjStartNfa_6(15, active0);
    }

    private int jjMoveStringLiteralDfa17_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(15, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(16, active0);
            return 17;
        }
        switch (this.curChar) {
            case 65: {
                return this.jjMoveStringLiteralDfa18_6(active0, 4L);
            }
            case 82: {
                return this.jjMoveStringLiteralDfa18_6(active0, 8L);
            }
        }
        return this.jjStartNfa_6(16, active0);
    }

    private int jjMoveStringLiteralDfa18_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(16, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(17, active0);
            return 18;
        }
        switch (this.curChar) {
            case 82: {
                return this.jjMoveStringLiteralDfa19_6(active0, 4L);
            }
            case 84: {
                if ((active0 & 8L) == 0L) break;
                return this.jjStopAtPos(18, 3);
            }
        }
        return this.jjStartNfa_6(17, active0);
    }

    private int jjMoveStringLiteralDfa19_6(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_6(17, old0);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(18, active0);
            return 19;
        }
        switch (this.curChar) {
            case 84: {
                if ((active0 & 4L) == 0L) break;
                return this.jjStopAtPos(19, 2);
            }
        }
        return this.jjStartNfa_6(18, active0);
    }

    private int jjMoveNfa_6(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 9;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block24: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x2400L & l) != 0L) {
                                if (kind > 51) {
                                    kind = 51;
                                }
                            } else if (this.curChar == 32) {
                                if (kind > 52) {
                                    kind = 52;
                                }
                            } else if (this.curChar == 35) {
                                if (kind > 1) {
                                    kind = 1;
                                }
                                this.jjCheckNAddStates(20, 22);
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 5;
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block24;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block24;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block24;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if (this.curChar != 10 || kind <= 51) continue block24;
                            kind = 51;
                            break;
                        }
                        case 6: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 5;
                            break;
                        }
                        case 7: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block24;
                            kind = 51;
                            break;
                        }
                        case 8: {
                            if (this.curChar != 32 || kind <= 52) continue block24;
                            kind = 52;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        case 1: {
                            kind = 1;
                            this.jjAddStates(20, 22);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block26: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block26;
                            kind = 52;
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block26;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block26;
                            kind = 1;
                            break;
                        }
                        case 7: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block26;
                            kind = 51;
                            break;
                        }
                        case 8: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block26;
                            kind = 52;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block26;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 9 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private int jjMoveStringLiteralDfa0_0() {
        return this.jjMoveNfa_0(0, 0);
    }

    private int jjMoveNfa_0(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 11;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block28: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) != 0L) {
                                if (kind > 48) {
                                    kind = 48;
                                }
                                this.jjCheckNAdd(6);
                            } else if ((0x2400L & l) != 0L) {
                                if (kind > 51) {
                                    kind = 51;
                                }
                            } else if (this.curChar == 32 && kind > 52) {
                                kind = 52;
                            }
                            if (this.curChar == 13) {
                                this.jjstateSet[this.jjnewStateCnt++] = 7;
                                break;
                            }
                            if (this.curChar != 35) break;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block28;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block28;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block28;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if ((0xFFFFFFFEFFFFDBFFL & l) == 0L) continue block28;
                            if (kind > 48) {
                                kind = 48;
                            }
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block28;
                            if (kind > 48) {
                                kind = 48;
                            }
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 7: {
                            if (this.curChar != 10 || kind <= 51) continue block28;
                            kind = 51;
                            break;
                        }
                        case 8: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 7;
                            break;
                        }
                        case 9: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block28;
                            kind = 51;
                            break;
                        }
                        case 10: {
                            if (this.curChar != 32 || kind <= 52) continue block28;
                            kind = 52;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 6: {
                            if (kind > 48) {
                                kind = 48;
                            }
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 1: {
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block30: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 48) {
                                    kind = 48;
                                }
                                this.jjCheckNAdd(6);
                            }
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block30;
                            kind = 52;
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block30;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block30;
                            kind = 1;
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block30;
                            if (kind > 48) {
                                kind = 48;
                            }
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 9: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block30;
                            kind = 51;
                            break;
                        }
                        case 10: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block30;
                            kind = 52;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block30;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 11 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_2(int pos, long active0) {
        switch (pos) {
            default: 
        }
        return -1;
    }

    private final int jjStartNfa_2(int pos, long active0) {
        return this.jjMoveNfa_2(this.jjStopStringLiteralDfa_2(pos, active0), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_2() {
        switch (this.curChar) {
            case 39: {
                return this.jjStartNfaWithStates_2(0, 36, 6);
            }
        }
        return this.jjMoveNfa_2(0, 0);
    }

    private int jjStartNfaWithStates_2(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_2(state, pos + 1);
    }

    private int jjMoveNfa_2(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 12;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block29: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) != 0L) {
                                if (kind > 35) {
                                    kind = 35;
                                }
                                this.jjCheckNAddTwoStates(5, 7);
                            } else if ((0x2400L & l) != 0L) {
                                if (kind > 51) {
                                    kind = 51;
                                }
                            } else if (this.curChar == 39) {
                                this.jjstateSet[this.jjnewStateCnt++] = 6;
                            }
                            if (this.curChar == 32) {
                                if (kind <= 52) break;
                                kind = 52;
                                break;
                            }
                            if (this.curChar == 13) {
                                this.jjstateSet[this.jjnewStateCnt++] = 8;
                                break;
                            }
                            if (this.curChar != 35) break;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) continue block29;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjCheckNAddStates(20, 22);
                            break;
                        }
                        case 2: {
                            if (this.curChar != 10 || kind <= 1) continue block29;
                            kind = 1;
                            break;
                        }
                        case 3: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) == 0L || kind <= 1) continue block29;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) == 0L) continue block29;
                            if (kind > 35) {
                                kind = 35;
                            }
                            this.jjCheckNAddTwoStates(5, 7);
                            break;
                        }
                        case 6: {
                            if (this.curChar != 39) continue block29;
                            if (kind > 35) {
                                kind = 35;
                            }
                            this.jjCheckNAddTwoStates(5, 7);
                            break;
                        }
                        case 7: {
                            if (this.curChar != 39) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 6;
                            break;
                        }
                        case 8: {
                            if (this.curChar != 10 || kind <= 51) continue block29;
                            kind = 51;
                            break;
                        }
                        case 9: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 8;
                            break;
                        }
                        case 10: {
                            if ((0x2400L & l) == 0L || kind <= 51) continue block29;
                            kind = 51;
                            break;
                        }
                        case 11: {
                            if (this.curChar != 32 || kind <= 52) continue block29;
                            kind = 52;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 5: {
                            if (kind > 35) {
                                kind = 35;
                            }
                            this.jjCheckNAddTwoStates(5, 7);
                            break;
                        }
                        case 1: {
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block31: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                                if (kind > 35) {
                                    kind = 35;
                                }
                                this.jjCheckNAddTwoStates(5, 7);
                            }
                            if (YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51) {
                                kind = 51;
                            }
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block31;
                            kind = 52;
                            break;
                        }
                        case 1: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block31;
                            if (kind > 1) {
                                kind = 1;
                            }
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 4: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 1) continue block31;
                            kind = 1;
                            break;
                        }
                        case 5: {
                            if (!YamlParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block31;
                            if (kind > 35) {
                                kind = 35;
                            }
                            this.jjCheckNAddTwoStates(5, 7);
                            break;
                        }
                        case 10: {
                            if (!YamlParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2) || kind <= 51) continue block31;
                            kind = 51;
                            break;
                        }
                        case 11: {
                            if (!YamlParserTokenManager.jjCanMove_2(hiByte, i1, i2, l1, l2) || kind <= 52) continue block31;
                            kind = 52;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block31;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 12 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    protected Token jjFillToken() {
        String im = jjstrLiteralImages[this.jjmatchedKind];
        String curTokenImage = im == null ? this.input_stream.GetImage() : im;
        int beginLine = this.input_stream.getBeginLine();
        int beginColumn = this.input_stream.getBeginColumn();
        int endLine = this.input_stream.getEndLine();
        int endColumn = this.input_stream.getEndColumn();
        Token t = Token.newToken(this.jjmatchedKind, curTokenImage);
        t.beginLine = beginLine;
        t.endLine = endLine;
        t.beginColumn = beginColumn;
        t.endColumn = endColumn;
        return t;
    }

    private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec2[i2] & l2) != 0L;
            }
        }
        return (jjbitVec0[i1] & l1) != 0L;
    }

    private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec3[i2] & l2) != 0L;
            }
            case 32: {
                return (jjbitVec4[i2] & l2) != 0L;
            }
        }
        return false;
    }

    private static final boolean jjCanMove_2(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec5[i2] & l2) != 0L;
            }
            case 22: {
                return (jjbitVec6[i2] & l2) != 0L;
            }
            case 24: {
                return (jjbitVec7[i2] & l2) != 0L;
            }
            case 32: {
                return (jjbitVec8[i2] & l2) != 0L;
            }
            case 48: {
                return (jjbitVec9[i2] & l2) != 0L;
            }
            case 254: {
                return (jjbitVec10[i2] & l2) != 0L;
            }
        }
        return false;
    }

    private static final boolean jjCanMove_3(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec11[i2] & l2) != 0L;
            }
            case 22: {
                return (jjbitVec6[i2] & l2) != 0L;
            }
            case 24: {
                return (jjbitVec7[i2] & l2) != 0L;
            }
            case 32: {
                return (jjbitVec12[i2] & l2) != 0L;
            }
            case 48: {
                return (jjbitVec9[i2] & l2) != 0L;
            }
            case 254: {
                return (jjbitVec10[i2] & l2) != 0L;
            }
        }
        return false;
    }

    public Token getNextToken() {
        Token specialToken = null;
        int curPos = 0;
        while (true) {
            Token matchedToken;
            try {
                this.curChar = this.input_stream.BeginToken();
            }
            catch (Exception e) {
                this.jjmatchedKind = 0;
                this.jjmatchedPos = -1;
                matchedToken = this.jjFillToken();
                matchedToken.specialToken = specialToken;
                this.CommonTokenAction(matchedToken);
                return matchedToken;
            }
            this.image = this.jjimage;
            this.image.setLength(0);
            this.jjimageLen = 0;
            switch (this.curLexState) {
                case 0: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_0();
                    break;
                }
                case 1: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_1();
                    break;
                }
                case 2: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_2();
                    break;
                }
                case 3: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_3();
                    break;
                }
                case 4: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_4();
                    break;
                }
                case 5: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_5();
                    break;
                }
                case 6: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_6();
                    break;
                }
                case 7: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_7();
                }
            }
            if (this.jjmatchedKind == Integer.MAX_VALUE) break;
            if (this.jjmatchedPos + 1 < curPos) {
                this.input_stream.backup(curPos - this.jjmatchedPos - 1);
            }
            if ((jjtoToken[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) != 0L) {
                matchedToken = this.jjFillToken();
                matchedToken.specialToken = specialToken;
                this.TokenLexicalActions(matchedToken);
                if (jjnewLexState[this.jjmatchedKind] != -1) {
                    this.curLexState = jjnewLexState[this.jjmatchedKind];
                }
                this.CommonTokenAction(matchedToken);
                return matchedToken;
            }
            if ((jjtoSpecial[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) != 0L) {
                matchedToken = this.jjFillToken();
                if (specialToken == null) {
                    specialToken = matchedToken;
                } else {
                    matchedToken.specialToken = specialToken;
                    specialToken = specialToken.next = matchedToken;
                }
                this.SkipLexicalActions(matchedToken);
            } else {
                this.SkipLexicalActions(null);
            }
            if (jjnewLexState[this.jjmatchedKind] == -1) continue;
            this.curLexState = jjnewLexState[this.jjmatchedKind];
        }
        int error_line = this.input_stream.getEndLine();
        int error_column = this.input_stream.getEndColumn();
        String error_after = null;
        boolean EOFSeen = false;
        try {
            this.input_stream.readChar();
            this.input_stream.backup(1);
        }
        catch (IOException e1) {
            EOFSeen = true;
            String string = error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
            if (this.curChar == 10 || this.curChar == 13) {
                ++error_line;
                error_column = 0;
            }
            ++error_column;
        }
        if (!EOFSeen) {
            this.input_stream.backup(1);
            error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
        }
        throw new TokenMgrException(EOFSeen, this.curLexState, error_line, error_column, error_after, this.curChar, 0);
    }

    void SkipLexicalActions(Token matchedToken) {
        switch (this.jjmatchedKind) {
            case 1: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.ignorableComment(matchedToken);
                break;
            }
            case 51: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.ignorableWhiteSpace(matchedToken);
                break;
            }
            case 52: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.ignorableWhiteSpace(matchedToken);
                break;
            }
        }
    }

    void MoreLexicalActions() {
        this.lengthOfMatch = this.jjmatchedPos + 1;
        this.jjimageLen += this.lengthOfMatch;
        switch (this.jjmatchedKind) {
            default: 
        }
    }

    void TokenLexicalActions(Token matchedToken) {
        switch (this.jjmatchedKind) {
            case 14: {
                this.image.append(jjstrLiteralImages[14]);
                this.lengthOfMatch = jjstrLiteralImages[14].length();
                ++this.flowSequenceNesting;
                break;
            }
            case 15: {
                this.image.append(jjstrLiteralImages[15]);
                this.lengthOfMatch = jjstrLiteralImages[15].length();
                ++this.flowMappingeNesting;
                break;
            }
            case 16: {
                this.image.append(jjstrLiteralImages[16]);
                this.lengthOfMatch = jjstrLiteralImages[16].length();
                --this.flowSequenceNesting;
                if (this.insideFlow()) break;
                this.SwitchTo(7);
                break;
            }
            case 17: {
                this.image.append(jjstrLiteralImages[17]);
                this.lengthOfMatch = jjstrLiteralImages[17].length();
                --this.flowMappingeNesting;
                if (this.insideFlow()) break;
                this.SwitchTo(7);
                break;
            }
            case 34: {
                this.image.append(jjstrLiteralImages[34]);
                this.lengthOfMatch = jjstrLiteralImages[34].length();
                if (this.insideFlow()) {
                    this.SwitchTo(5);
                    break;
                }
                this.SwitchTo(7);
                break;
            }
            case 36: {
                this.image.append(jjstrLiteralImages[36]);
                this.lengthOfMatch = jjstrLiteralImages[36].length();
                if (this.insideFlow()) {
                    this.SwitchTo(5);
                    break;
                }
                this.SwitchTo(7);
                break;
            }
            case 45: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                if (matchedToken.image.startsWith("--- ") || matchedToken.image.startsWith("... ")) {
                    this.backup(matchedToken.image.length());
                    matchedToken.kind = 6;
                    matchedToken.image = "FALSE_START";
                    matchedToken.beginColumn = 0;
                    this.SwitchTo(4);
                    break;
                }
                this.SwitchTo(1);
                break;
            }
            case 47: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                if (!this.isIndentedScalarFinished(matchedToken)) break;
                this.SwitchTo(7);
                break;
            }
            case 48: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                if (!this.isIndentedScalarFinished(matchedToken)) break;
                this.SwitchTo(7);
                break;
            }
        }
    }

    private void jjCheckNAdd(int state) {
        if (this.jjrounds[state] != this.jjround) {
            this.jjstateSet[this.jjnewStateCnt++] = state;
            this.jjrounds[state] = this.jjround;
        }
    }

    private void jjAddStates(int start, int end) {
        do {
            this.jjstateSet[this.jjnewStateCnt++] = jjnextStates[start];
        } while (start++ != end);
    }

    private void jjCheckNAddTwoStates(int state1, int state2) {
        this.jjCheckNAdd(state1);
        this.jjCheckNAdd(state2);
    }

    private void jjCheckNAddStates(int start, int end) {
        do {
            this.jjCheckNAdd(jjnextStates[start]);
        } while (start++ != end);
    }

    public YamlParserTokenManager(JavaCharStream stream) {
        this.input_stream = stream;
    }

    public YamlParserTokenManager(JavaCharStream stream, int lexState) {
        this.ReInit(stream);
        this.SwitchTo(lexState);
    }

    public void ReInit(JavaCharStream stream) {
        this.jjnewStateCnt = 0;
        this.jjmatchedPos = 0;
        this.curLexState = this.defaultLexState;
        this.input_stream = stream;
        this.ReInitRounds();
    }

    private void ReInitRounds() {
        this.jjround = -2147483647;
        int i = 133;
        while (i-- > 0) {
            this.jjrounds[i] = Integer.MIN_VALUE;
        }
    }

    public void ReInit(JavaCharStream stream, int lexState) {
        this.ReInit(stream);
        this.SwitchTo(lexState);
    }

    public void SwitchTo(int lexState) {
        if (lexState >= 8 || lexState < 0) {
            throw new TokenMgrException("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", 2);
        }
        this.curLexState = lexState;
    }
}

