/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.util.ArrayList;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.xliff2.util.PropertiesMapper;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Unit;

public class X2ToOkpConverter {
    private final LocaleId trgLoc;

    public X2ToOkpConverter(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public ITextUnit convert(Unit unit) {
        TextUnit tu = new TextUnit(unit.getId());
        tu.setName(unit.getName());
        tu.setType(unit.getType());
        TextContainer tc = tu.getSource();
        this.convert(unit, tc, false);
        boolean hasTarget = false;
        for (Part part : unit) {
            if (!part.hasTarget()) continue;
            hasTarget = true;
            break;
        }
        if (hasTarget) {
            tc = tu.createTarget(this.trgLoc, false, 0);
            this.convert(unit, tc, true);
        }
        PropertiesMapper.fixMissingTargetCodeProperties(tu);
        return tu;
    }

    private void convert(Unit unit, TextContainer dest, boolean isTarget) {
        boolean first = true;
        ArrayList<TextPart> textParts = new ArrayList<TextPart>();
        int segId = 1;
        for (Part part : unit) {
            TextPart convert = this.convert(first, part, dest, isTarget, segId);
            textParts.add(convert);
            PropertiesMapper.setPartProperties(part, convert);
            first = false;
            ++segId;
        }
        dest.setParts(textParts.toArray(new TextPart[0]));
    }

    private TextPart convert(boolean first, Part part, TextContainer dest, boolean isTarget, int segId) {
        TextPart tp;
        if (part.isSegment()) {
            Segment seg = new Segment(String.valueOf(segId));
            tp = seg;
        } else {
            tp = new TextPart();
        }
        if (isTarget) {
            if (part.hasTarget()) {
                this.convert(part.getTarget(), tp);
            }
        } else {
            this.convert(part.getSource(), tp);
        }
        return tp;
    }

    private void convert(Fragment frag, TextPart part) {
        TextFragment tf = part.text;
        for (Object obj : frag) {
            if (obj instanceof String) {
                tf.append((String)obj);
                continue;
            }
            if (obj instanceof CTag) {
                CTag ctag = (CTag)obj;
                Code code = new Code(ctag.getType());
                PropertiesMapper.setCodeProperties(ctag, code);
                tf.append(code);
                continue;
            }
            if (!(obj instanceof MTag)) continue;
            tf.append("[MARKER]");
        }
    }
}

