/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.XLIFFNote;
import net.sf.okapi.common.annotation.XLIFFNoteAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Okp2X2Converter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean originalWasX2;
    private final LocaleId trgLoc;

    public Okp2X2Converter(boolean originalWasX2, LocaleId trgLoc) {
        this.originalWasX2 = originalWasX2;
        this.trgLoc = trgLoc;
    }

    public Unit convert(ITextUnit tu) {
        Unit unit = new Unit(tu.getId());
        unit.setName(tu.getName());
        unit.setType(tu.getType());
        Okp2X2Converter.convertNotesFromXliff12ToXliff2(tu.getAnnotation(XLIFFNoteAnnotation.class), unit);
        TextContainer srcTc = tu.getSource();
        TextContainer trgTc = tu.getTarget(this.trgLoc);
        TextPart trgPart = null;
        for (int i = 0; i < srcTc.count(); ++i) {
            TextPart srcPart = srcTc.get(i);
            if (i < trgTc.count()) {
                trgPart = trgTc.get(i);
            }
            this.convert(srcPart, trgPart, unit);
        }
        return unit;
    }

    public static void convertNotesFromXliff12ToXliff2(XLIFFNoteAnnotation xl12Notes, IWithNotes xl2NotesAware) {
        if (xl12Notes != null) {
            for (XLIFFNote n1 : xl12Notes) {
                XLIFFNote.Priority pr;
                String fr;
                Note n2 = new Note(n1.getNoteText());
                XLIFFNote.Annotates an = n1.getAnnotates();
                if (an != null) {
                    switch (an) {
                        case SOURCE: {
                            n2.setAppliesTo(Note.AppliesTo.SOURCE);
                            break;
                        }
                        case TARGET: {
                            n2.setAppliesTo(Note.AppliesTo.TARGET);
                            break;
                        }
                    }
                }
                if ((fr = n1.getFrom()) != null && !fr.isEmpty()) {
                    n2.setCategory(fr);
                }
                if ((pr = n1.getPriority()) != null) {
                    n2.setPriority(pr.value());
                }
                xl2NotesAware.addNote(n2);
            }
        }
    }

    private void convert(TextPart srcPart, TextPart trgPart, Unit destUnit) {
        Part destPart = srcPart.isSegment() ? destUnit.appendSegment() : destUnit.appendIgnorable();
        this.convert(srcPart.getContent(), destPart.getSource(), false);
        if (trgPart != null) {
            this.convert(trgPart.getContent(), destPart.getTarget(Part.GetTarget.CREATE_EMPTY), true);
        }
        if (destPart.isSegment()) {
            Segment seg = (Segment)srcPart;
            destPart.setId(seg.getId());
        }
    }

    private void convert(TextFragment oriFrag, Fragment destFrag, boolean isTarget) {
        if (!oriFrag.hasCode()) {
            destFrag.setCodedText(oriFrag.getCodedText());
            return;
        }
        String ct = oriFrag.getCodedText();
        destFrag.setCodedText(ct);
        block5: for (int i = 0; i < ct.length(); ++i) {
            Code code;
            char ch = ct.charAt(i);
            if (!TextFragment.isMarker(ch)) continue;
            String id = (code = oriFrag.getCode(ct.charAt(++i))).getOriginalId() != null ? code.getOriginalId() : "" + code.getId();
            switch (code.getTagType()) {
                case OPENING: {
                    destFrag.delete(i - 1, i + 1);
                    CTag ctag = destFrag.insert(TagType.OPENING, code.getType(), id, code.getData(), i - 1, false, true);
                    ctag.setDisp(code.getDisplayText());
                    ctag.setCanCopy(code.isCloneable());
                    ctag.setCanDelete(code.isDeleteable());
                    continue block5;
                }
                case CLOSING: {
                    destFrag.delete(i - 1, i + 1);
                    CTag ctag = destFrag.insert(TagType.CLOSING, code.getType(), id, code.getData(), i - 1, true, true);
                    ctag.setDisp(code.getDisplayText());
                    ctag.setCanCopy(code.isCloneable());
                    ctag.setCanDelete(code.isDeleteable());
                    continue block5;
                }
                case PLACEHOLDER: {
                    destFrag.delete(i - 1, i + 1);
                    CTag ctag = destFrag.insert(TagType.STANDALONE, code.getType(), id, code.getData(), i - 1, false, true);
                    ctag.setDisp(code.getDisplayText());
                    ctag.setCanCopy(code.isCloneable());
                    ctag.setCanDelete(code.isDeleteable());
                }
            }
        }
    }
}

