/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.txml;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider,
ISimplifierRulesParameters {
    public static final String ALLOWEMPTYOUTPUTTARGET = "allowEmptyOutputTarget";

    public boolean getAllowEmptyOutputTarget() {
        return this.getBoolean(ALLOWEMPTYOUTPUTTARGET);
    }

    public void setAllowEmptyOutputTarget(boolean allowEmptyOutputTarget) {
        this.setBoolean(ALLOWEMPTYOUTPUTTARGET, allowEmptyOutputTarget);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public void reset() {
        super.reset();
        this.setAllowEmptyOutputTarget(true);
        this.setSimplifierRules(null);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(ALLOWEMPTYOUTPUTTARGET, "Allow empty target segments in output", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("TXML Filter Parameters", true, false);
        desc.addCheckboxPart(paramDesc.get(ALLOWEMPTYOUTPUTTARGET));
        return desc;
    }
}

