/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.spliced;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.filters.plaintext.base.BasePlainTextFilter;
import net.sf.okapi.filters.plaintext.spliced.Parameters;
import net.sf.okapi.lib.extra.filters.TextProcessingResult;

public class SplicedLinesFilter
extends BasePlainTextFilter {
    public static final String FILTER_NAME = "okf_plaintext_spliced";
    public static final String FILTER_CONFIG = "okf_plaintext_spliced";
    public static final String FILTER_CONFIG_UNDERSCORE = "okf_plaintext_spliced_underscore";
    public static final String FILTER_CONFIG_BACKSLASH = "okf_plaintext_spliced_backslash";
    public static final String FILTER_CONFIG_CUSTOM = "okf_plaintext_spliced_custom";
    private Parameters params;
    private List<TextContainer> splicedLines;
    private boolean merging = false;

    public SplicedLinesFilter() {
        this.setName("okf_plaintext_spliced");
        this.setParameters(new Parameters());
        this.addConfiguration(true, "okf_plaintext_spliced", "Spliced Lines", "Extracts as one line the consecutive lines with a predefined splicer character at the end.", "okf_plaintext_spliced.fprm");
        this.addConfiguration(false, FILTER_CONFIG_BACKSLASH, "Spliced Lines (Backslash)", "Spliced lines filter with the backslash character (\\) used as the splicer.", "okf_plaintext_spliced_backslash.fprm");
        this.addConfiguration(false, FILTER_CONFIG_UNDERSCORE, "Spliced Lines (Underscore)", "Spliced lines filter with the underscore character (_) used as the splicer.", "okf_plaintext_spliced_underscore.fprm");
        this.addConfiguration(false, FILTER_CONFIG_CUSTOM, "Spliced Lines (Custom)", "Spliced lines filter with a user-defined splicer.", "okf_plaintext_spliced_custom.fprm");
    }

    @Override
    protected void component_init() {
        this.params = this.getParameters(Parameters.class);
        super.component_init();
        if (this.splicedLines == null) {
            this.splicedLines = new ArrayList<TextContainer>();
        } else {
            this.splicedLines.clear();
        }
    }

    @Override
    protected TextProcessingResult component_exec(TextContainer lineContainer) {
        if (lineContainer == null) {
            return super.component_exec(lineContainer);
        }
        if (this.splicedLines == null) {
            return super.component_exec(lineContainer);
        }
        if (TextUnitUtil.endsWith(lineContainer.getFirstContent(), this.params.splicer)) {
            this.merging = true;
            this.splicedLines.add(lineContainer);
            return TextProcessingResult.DELAYED_DECISION;
        }
        if (this.merging) {
            this.merging = false;
            this.splicedLines.add(lineContainer);
            return this.mergeLines() ? TextProcessingResult.ACCEPTED : TextProcessingResult.REJECTED;
        }
        return super.component_exec(lineContainer);
    }

    @Override
    protected void component_idle(boolean lastChance) {
        if (this.merging) {
            this.mergeLines();
        }
        super.component_idle(lastChance);
    }

    @Override
    protected void component_done() {
        if (this.splicedLines != null) {
            this.splicedLines.clear();
        }
        this.merging = false;
        super.component_done();
    }

    private boolean mergeLines() {
        if (this.splicedLines == null) {
            return false;
        }
        if (this.splicedLines.isEmpty()) {
            return false;
        }
        if (this.params == null) {
            return false;
        }
        if (Util.isEmpty(this.params.splicer)) {
            return false;
        }
        TextContainer mergedLine = new TextContainer();
        TextFragment mergedTF = mergedLine.getFirstContent();
        int len = this.params.splicer.length();
        for (TextContainer curLine : this.splicedLines) {
            TextFragment curTF = curLine.getFirstContent();
            int pos = TextUnitUtil.lastIndexOf(curLine.getFirstContent(), this.params.splicer);
            if (pos > -1) {
                if (this.params.createPlaceholders) {
                    curTF.changeToCode(pos, pos + len, TextFragment.TagType.PLACEHOLDER, "line splicer");
                } else {
                    curTF.remove(pos, pos + len);
                }
            }
            if (mergedLine.isEmpty()) {
                mergedLine.setProperty(curLine.getProperty("line_number"));
            } else if (this.params.createPlaceholders) {
                mergedTF.append(new Code(TextFragment.TagType.PLACEHOLDER, "line break", this.getLineBreak()));
            }
            mergedTF.append(curTF);
        }
        this.sendAsSource(mergedLine);
        this.splicedLines.clear();
        return true;
    }
}

