/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.regex;

import java.net.URL;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.plaintext.regex.Parameters;
import net.sf.okapi.filters.regex.RegexFilter;
import net.sf.okapi.filters.regex.Rule;
import net.sf.okapi.lib.extra.filters.AbstractBaseFilter;

public class RegexPlainTextFilter
extends AbstractBaseFilter {
    public static final String FILTER_NAME = "okf_plaintext_regex";
    public static final String FILTER_MIME = "text/plain";
    public static final String FILTER_CONFIG = "okf_plaintext_regex";
    public static final String FILTER_CONFIG_LINES = "okf_plaintext_regex_lines";
    public static final String FILTER_CONFIG_PARAGRAPHS = "okf_plaintext_regex_paragraphs";
    private InlineCodeFinder codeFinder = new InlineCodeFinder();
    private RegexFilter regex = new RegexFilter();
    private Parameters params;
    private int lineNumber = 0;
    private RawDocument input;

    public RegexPlainTextFilter() {
        this.setParameters(new Parameters());
        this.addConfiguration(true, "okf_plaintext_regex", "Plain Text (Regex)", "Plain Text Filter using regex-based linebreak search. Detects a wider range of linebreaks at the price of lower speed and extra memory usage.", "okf_plaintext_regex.fprm");
        this.addConfiguration(false, FILTER_CONFIG_LINES, "Plain Text (Regex, Line=Paragraph)", "Plain Text Filter using regex-based linebreak search. Extracts by lines.", "okf_plaintext_regex_lines.fprm");
        this.addConfiguration(false, FILTER_CONFIG_PARAGRAPHS, "Plain Text (Regex, Block=Paragraph)", "Plain Text Filter using regex-based linebreak search. Extracts by paragraphs.", "okf_plaintext_regex_paragraphs.fprm");
        net.sf.okapi.filters.regex.Parameters regexParams = new net.sf.okapi.filters.regex.Parameters();
        this.regex.setParameters(regexParams);
        URL url = RegexPlainTextFilter.class.getResource("def_line_extraction_rule.fprm");
        if (url == null) {
            return;
        }
        regexParams.load(url, false);
    }

    public void setRule(String rule, int sourceGroup, int regexOptions) {
        if (rule == null) {
            return;
        }
        if (rule.isEmpty()) {
            return;
        }
        Rule regexRule = this._getFirstRegexRule();
        if (regexRule == null) {
            return;
        }
        regexRule.setExpression(rule);
        regexRule.setSourceGroup(sourceGroup);
        net.sf.okapi.filters.regex.Parameters rp = this._getRegexParams();
        if (rp == null) {
            return;
        }
        rp.setRegexOptions(regexOptions);
        rp.compileRules();
        if (this.params == null) {
            return;
        }
        this.params.rule = rule;
        this.params.sourceGroup = sourceGroup;
        this.params.regexOptions = regexOptions;
    }

    public net.sf.okapi.filters.regex.Parameters getRegexParameters() {
        return this._getRegexParams();
    }

    @Override
    public void cancel() {
        if (this.input != null) {
            this.input.close();
        }
        if (this.regex != null) {
            this.regex.cancel();
        }
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        if (this.regex != null) {
            this.regex.close();
        }
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return this.regex != null ? this.regex.createFilterWriter() : null;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return this.regex != null ? this.regex.createSkeletonWriter() : null;
    }

    @Override
    public String getMimeType() {
        return FILTER_MIME;
    }

    @Override
    public String getName() {
        return "okf_plaintext_regex";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.regex != null && this.regex.hasNext();
    }

    @Override
    public Event next() {
        Event event = this.regex.next();
        if (event == null) {
            return event;
        }
        IResource res = event.getResource();
        if (res == null) {
            return event;
        }
        if (event.getEventType() == EventType.TEXT_UNIT) {
            ITextUnit textUnit = event.getTextUnit();
            textUnit.setMimeType(this.getMimeType());
            ((ITextUnit)res).setSourceProperty(new Property("line_number", String.valueOf(++this.lineNumber), true));
            if (this.params.useCodeFinder && this.codeFinder != null) {
                TextContainer source = textUnit.getSource();
                if (source == null) {
                    return event;
                }
                this.codeFinder.process(source.getFirstContent());
            }
        }
        return event;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.lineNumber = 0;
        if (input == null) {
            throw new OkapiBadFilterInputException("Input RawDocument is not defined.");
        }
        if (this.regex != null) {
            this.regex.open(input, generateSkeleton);
        }
        if (this.params.useCodeFinder && this.codeFinder != null) {
            this.codeFinder.fromString(this.params.codeFinderRules);
            this.codeFinder.compile();
        }
    }

    @Override
    public void setParameters(IParameters params) {
        super.setParameters(params);
        if (params instanceof Parameters) {
            this.params = (Parameters)params;
            if (this.params != null) {
                this.setRule(this.params.rule, this.params.sourceGroup, this.params.regexOptions);
            }
        }
    }

    @Override
    protected void component_done() {
    }

    @Override
    protected void component_init() {
    }

    private net.sf.okapi.filters.regex.Parameters _getRegexParams() {
        if (this.regex == null) {
            return null;
        }
        net.sf.okapi.filters.regex.Parameters punk = this.regex.getParameters();
        return punk instanceof net.sf.okapi.filters.regex.Parameters ? punk : null;
    }

    private Rule _getFirstRegexRule() {
        net.sf.okapi.filters.regex.Parameters regexParams = this._getRegexParams();
        if (regexParams == null) {
            return null;
        }
        if (regexParams.getRules() == null) {
            return null;
        }
        if (regexParams.getRules().isEmpty()) {
            return null;
        }
        return regexParams.getRules().get(0);
    }
}

