/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.paragraphs;

import java.util.LinkedList;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.plaintext.base.BasePlainTextFilter;
import net.sf.okapi.filters.plaintext.paragraphs.Parameters;
import net.sf.okapi.lib.extra.filters.TextProcessingResult;

public class ParaPlainTextFilter
extends BasePlainTextFilter {
    public static final String FILTER_NAME = "okf_plaintext_paragraphs";
    public static final String FILTER_CONFIG = "okf_plaintext_paragraphs";
    public static final String FILTER_CONFIG_LINES = "okf_plaintext_paragraphs_lines";
    private Parameters params;
    private LinkedList<TextContainer> bufferedLines;
    private boolean merging = false;

    public ParaPlainTextFilter() {
        this.setName("okf_plaintext_paragraphs");
        this.setParameters(new Parameters());
        this.addConfiguration(true, "okf_plaintext_paragraphs", "Plain Text (Paragraphs)", "Text files extracted by paragraphs (separated by 1 or more empty lines).", "okf_plaintext_paragraphs.fprm");
        this.addConfiguration(false, FILTER_CONFIG_LINES, "Plain Text (Lines)", "Text files extracted by lines (each line is a text unit).", "okf_plaintext_paragraphs_lines.fprm");
    }

    @Override
    protected void component_init() {
        this.params = this.getParameters(Parameters.class);
        super.component_init();
        if (!this.params.extractParagraphs) {
            return;
        }
        if (this.bufferedLines == null) {
            this.bufferedLines = new LinkedList();
        } else {
            this.bufferedLines.clear();
        }
    }

    @Override
    protected TextProcessingResult component_exec(TextContainer lineContainer) {
        if (this.bufferedLines == null || !this.params.extractParagraphs) {
            return super.component_exec(lineContainer);
        }
        if (!lineContainer.isEmpty()) {
            this.merging = true;
            this.bufferedLines.add(lineContainer);
            return TextProcessingResult.DELAYED_DECISION;
        }
        if (this.merging) {
            this.merging = false;
            return this.mergeLines(true) ? TextProcessingResult.ACCEPTED : TextProcessingResult.REJECTED;
        }
        return super.component_exec(lineContainer);
    }

    @Override
    protected void component_idle(boolean lastChance) {
        if (this.merging) {
            this.mergeLines(false);
        }
        super.component_idle(lastChance);
    }

    @Override
    protected void component_done() {
        if (this.bufferedLines != null && this.params.extractParagraphs) {
            this.bufferedLines.clear();
        }
        this.merging = false;
        super.component_done();
    }

    private boolean mergeLines(boolean addLinebreak) {
        if (!this.params.extractParagraphs) {
            return false;
        }
        if (this.bufferedLines == null) {
            return false;
        }
        if (this.bufferedLines.isEmpty()) {
            return false;
        }
        TextContainer mergedLine = new TextContainer();
        TextFragment tf = mergedLine.getFirstContent();
        while (this.bufferedLines.size() > 0) {
            TextContainer curLine = this.bufferedLines.poll();
            if (mergedLine.isEmpty()) {
                mergedLine.setProperty(curLine.getProperty("line_number"));
            } else {
                switch (this.params.wrapMode) {
                    case PLACEHOLDERS: {
                        tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "line break", this.getLineBreak()));
                        break;
                    }
                    case SPACES: {
                        tf.append(' ');
                        break;
                    }
                    default: {
                        tf.append('\n');
                    }
                }
            }
            tf.append(curLine.getFirstContent());
        }
        this.sendAsSource(mergedLine);
        if (addLinebreak) {
            this.sendAsSkeleton(this.getLineBreak());
        }
        return true;
    }
}

