/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinition;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.WordStyleDefinition;
import net.sf.okapi.filters.openxml.WordStyleDefinitionsReader;

class WordStyleDefinitions
implements StyleDefinitions {
    static final String STYLES = "styles";
    static final String DOC_DEFAULTS = "docDefaults";
    static final String LATENT_STYLES = "latentStyles";
    static final String STYLE = "style";
    private final ConditionalParameters conditionalParameters;
    private final XMLInputFactory inputFactory;
    private final XMLEventFactory eventFactory;
    private StartDocument startDocument;
    private StartElement startElement;
    private StyleDefinition documentDefaults;
    private StyleDefinition latentStyles;
    private Map<StyleType, String> defaultStylesByStyleTypes;
    private Map<String, StyleType> styleTypesByStyleIds;
    private Map<String, String> parentStylesByStyleIds;
    private Map<String, String> linkedStylesByStyleIds;
    private Map<String, WordStyleDefinition> stylesByStyleIds;
    private EndElement endElement;
    private EndDocument endDocument;
    private Ids ids;
    private String placedId;

    WordStyleDefinitions(ConditionalParameters conditionalParameters, XMLInputFactory inputFactory, XMLEventFactory eventFactory) {
        this.conditionalParameters = conditionalParameters;
        this.inputFactory = inputFactory;
        this.eventFactory = eventFactory;
    }

    @Override
    public void readWith(Reader reader) throws XMLStreamException {
        this.defaultStylesByStyleTypes = new EnumMap<StyleType, String>(StyleType.class);
        this.styleTypesByStyleIds = new HashMap<String, StyleType>();
        this.parentStylesByStyleIds = new HashMap<String, String>();
        this.linkedStylesByStyleIds = new HashMap<String, String>();
        this.stylesByStyleIds = new LinkedHashMap<String, WordStyleDefinition>();
        this.ids = new Ids(new IdGenerator(STYLE, STYLE), this);
        WordStyleDefinitionsReader styleDefinitionsReader = new WordStyleDefinitionsReader(this.conditionalParameters, this.inputFactory, this.eventFactory, reader);
        this.startDocument = styleDefinitionsReader.readStartDocument();
        this.startElement = styleDefinitionsReader.readStartElement();
        this.documentDefaults = styleDefinitionsReader.readDocumentDefaults();
        this.latentStyles = styleDefinitionsReader.readLatent();
        while (styleDefinitionsReader.hasNextGeneral()) {
            this.place(styleDefinitionsReader.readNextGeneral());
        }
        this.endElement = styleDefinitionsReader.readEndElement();
        this.endDocument = styleDefinitionsReader.readEndDocument();
    }

    private void place(WordStyleDefinition styleDefinition) {
        if (styleDefinition.isDefault()) {
            this.defaultStylesByStyleTypes.put(styleDefinition.type(), styleDefinition.id());
        }
        this.styleTypesByStyleIds.put(styleDefinition.id(), styleDefinition.type());
        this.parentStylesByStyleIds.put(styleDefinition.id(), styleDefinition.parentId());
        this.linkedStylesByStyleIds.put(styleDefinition.id(), styleDefinition.linkedId());
        this.stylesByStyleIds.put(styleDefinition.id(), styleDefinition);
    }

    @Override
    public void place(String parentId, RunProperties runProperties) {
        this.placedId = this.ids.next(parentId, runProperties);
        if (this.stylesByStyleIds.containsKey(this.placedId)) {
            return;
        }
        WordStyleDefinition.General styleDefinition = new WordStyleDefinition.General(this.conditionalParameters, this.eventFactory, this.startElementForGeneral(this.placedId));
        styleDefinition.parentId(this.ids.parent());
        styleDefinition.runProperties(runProperties);
        this.place(styleDefinition);
    }

    @Override
    public String placedId() {
        return this.placedId;
    }

    private StartElement startElementForGeneral(String id) {
        List<Attribute> attributes = Arrays.asList(this.eventFactory.createAttribute(new QName(this.startElement.getName().getNamespaceURI(), "type", this.startElement.getName().getPrefix()), StyleType.PARAGRAPH.toString()), this.eventFactory.createAttribute(new QName(this.startElement.getName().getNamespaceURI(), "styleId", this.startElement.getName().getPrefix()), id));
        return this.eventFactory.createStartElement(new QName(this.startElement.getName().getNamespaceURI(), STYLE, this.startElement.getName().getPrefix()), attributes.iterator(), null);
    }

    @Override
    public RunProperties combinedRunProperties(String paragraphStyle, String runStyle, RunProperties runProperties) {
        RunProperties combinedRunProperties = RunProperties.copiedRunProperties(this.documentDefaults.runProperties(), false, false, true);
        combinedRunProperties = combinedRunProperties.combineDistinct(this.getParagraphStyleProperties(paragraphStyle), StyleDefinitions.TraversalStage.VERTICAL);
        combinedRunProperties = combinedRunProperties.combineDistinct(this.getRunStyleProperties(runStyle, paragraphStyle), StyleDefinitions.TraversalStage.VERTICAL);
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedToggleRunProperties(this.documentDefaults.runProperties()), StyleDefinitions.TraversalStage.DOCUMENT_DEFAULT);
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedRunProperties(runProperties, false, true, false), StyleDefinitions.TraversalStage.DIRECT);
        return combinedRunProperties;
    }

    private RunProperties getParagraphStyleProperties(String paragraphStyle) {
        return this.getPropertiesByTypeAndStyle(StyleType.PARAGRAPH, paragraphStyle, null);
    }

    private RunProperties getRunStyleProperties(String runStyle, String linkedStyle) {
        return this.getPropertiesByTypeAndStyle(StyleType.CHARACTER, runStyle, linkedStyle);
    }

    private RunProperties getPropertiesByTypeAndStyle(StyleType styleType, String styleId, String linkedStyleId) {
        if (null == styleId || !this.styleTypesByStyleIds.containsKey(styleId) || !this.styleTypesByStyleIds.get(styleId).equals((Object)styleType)) {
            String defaultStyleId = this.defaultStylesByStyleTypes.get((Object)styleType);
            return this.combineParentStyleProperties(styleType, defaultStyleId, RunProperties.emptyRunProperties());
        }
        return this.combineLinkedAndParentStyleProperties(styleType, styleId, linkedStyleId, RunProperties.emptyRunProperties());
    }

    private RunProperties combineLinkedAndParentStyleProperties(StyleType styleType, String styleId, String linkedStyleId, RunProperties runProperties) {
        if (null == linkedStyleId || StyleType.CHARACTER != styleType || null == this.linkedStylesByStyleIds.get(linkedStyleId) || StyleType.PARAGRAPH != this.styleTypesByStyleIds.get(linkedStyleId)) {
            return this.combineParentStyleProperties(styleType, styleId, runProperties);
        }
        RunProperties paragraphProperties = this.combineParentStyleProperties(StyleType.PARAGRAPH, this.linkedStylesByStyleIds.get(linkedStyleId), RunProperties.emptyRunProperties());
        RunProperties characterProperties = this.combineParentStyleProperties(StyleType.CHARACTER, styleId, RunProperties.emptyRunProperties());
        return paragraphProperties.combineDistinct(characterProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
    }

    private RunProperties combineParentStyleProperties(StyleType styleType, String styleId, RunProperties runProperties) {
        if (null == this.stylesByStyleIds.get(styleId)) {
            return runProperties;
        }
        if (null == this.parentStylesByStyleIds.get(styleId) || this.styleTypesByStyleIds.get(this.parentStylesByStyleIds.get(styleId)) != styleType) {
            return RunProperties.copiedRunProperties(this.stylesByStyleIds.get(styleId).runProperties()).combineDistinct(runProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
        }
        return this.combineParentStyleProperties(styleType, this.parentStylesByStyleIds.get(styleId), RunProperties.copiedRunProperties(this.stylesByStyleIds.get(styleId).runProperties())).combineDistinct(runProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
    }

    @Override
    public Markup toMarkup() {
        Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
        markup.addComponent(new MarkupComponent.General(Collections.singletonList(this.startDocument)));
        markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
        markup.addMarkup(this.documentDefaults.toMarkup());
        markup.addMarkup(this.latentStyles.toMarkup());
        for (Map.Entry<String, WordStyleDefinition> entry : this.stylesByStyleIds.entrySet()) {
            markup.addMarkup(entry.getValue().toMarkup());
        }
        markup.addComponent(new MarkupComponent.End(this.endElement));
        markup.addComponent(new MarkupComponent.General(Collections.singletonList(this.endDocument)));
        return markup;
    }

    private static class Ids {
        private final IdGenerator idGenerator;
        private final WordStyleDefinitions styleDefinitions;
        private String parent;

        Ids(IdGenerator idGenerator, WordStyleDefinitions styleDefinitions) {
            this.idGenerator = idGenerator;
            this.styleDefinitions = styleDefinitions;
        }

        String next(String paragraphStyle, RunProperties runProperties) {
            if (null != paragraphStyle && this.styleDefinitions.stylesByStyleIds.containsKey(paragraphStyle)) {
                return this.parentBased(StyleType.PARAGRAPH, paragraphStyle, runProperties);
            }
            return this.defaultBased(StyleType.PARAGRAPH, runProperties);
        }

        private String parentBased(StyleType type, String parentId, RunProperties runProperties) {
            this.parent = parentId;
            Optional<String> existing = this.styleDefinitions.stylesByStyleIds.entrySet().stream().filter(e -> type == ((WordStyleDefinition)e.getValue()).type()).filter(e -> parentId.equals(((WordStyleDefinition)e.getValue()).parentId())).filter(e -> runProperties.equals(((WordStyleDefinition)e.getValue()).runProperties())).map(e -> (String)e.getKey()).findFirst();
            return existing.orElseGet(() -> this.parentBasedGenerated(parentId));
        }

        private String parentBasedGenerated(String parentId) {
            String parentBasedId;
            do {
                parentBasedId = this.idGenerator.createId(parentId);
            } while (this.styleDefinitions.stylesByStyleIds.containsKey(parentBasedId));
            return parentBasedId;
        }

        private String defaultBased(StyleType type, RunProperties runProperties) {
            String defaultStyle = (String)this.styleDefinitions.defaultStylesByStyleTypes.get((Object)type);
            if (null != defaultStyle) {
                return this.parentBased(type, defaultStyle, runProperties);
            }
            return this.documentDefaultBased(type, runProperties);
        }

        private String documentDefaultBased(StyleType type, RunProperties runProperties) {
            this.parent = null;
            Optional<String> existing = this.styleDefinitions.stylesByStyleIds.entrySet().stream().filter(e -> type == ((WordStyleDefinition)e.getValue()).type()).filter(e -> null == ((WordStyleDefinition)e.getValue()).parentId()).filter(e -> runProperties.equals(((WordStyleDefinition)e.getValue()).runProperties())).map(e -> (String)e.getKey()).findFirst();
            return existing.orElseGet(() -> this.documentDefaultBasedGenerated());
        }

        private String documentDefaultBasedGenerated() {
            return this.idGenerator.createIdNotInList(new ArrayList<String>(this.styleDefinitions.stylesByStyleIds.keySet()));
        }

        String parent() {
            return this.parent;
        }
    }
}

