/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.PresentationNotesStyleDefinition;
import net.sf.okapi.filters.openxml.StyleDefinitionsReader;

class PresentationNotesStyleDefinitionsReader
implements StyleDefinitionsReader {
    private static final String NOTES_STYLE = "notesStyle";
    private static final String DEF_RPR = "defRPr";
    private static final String UNEXPECTED_STRUCTURE = "Unexpected notes style structure: ";
    private final ConditionalParameters conditionalParameters;
    private final XMLInputFactory inputFactory;
    private final XMLEventFactory eventFactory;
    private final Reader reader;
    private final List<String> paragraphLevels;
    private final Cache cache;

    PresentationNotesStyleDefinitionsReader(ConditionalParameters conditionalParameters, XMLInputFactory inputFactory, XMLEventFactory eventFactory, Reader reader) {
        this.conditionalParameters = conditionalParameters;
        this.inputFactory = inputFactory;
        this.eventFactory = eventFactory;
        this.reader = reader;
        this.paragraphLevels = Arrays.asList("lvl1pPr", "lvl2pPr", "lvl3pPr", "lvl4pPr", "lvl5pPr", "lvl6pPr", "lvl7pPr", "lvl8pPr", "lvl9pPr");
        this.cache = new Cache();
    }

    @Override
    public StartDocument readStartDocument() throws XMLStreamException {
        if (this.cache.hasStartDocument()) {
            return this.cache.startDocument;
        }
        this.cache.eventReader = this.inputFactory.createXMLEventReader(this.reader);
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (!event.isStartDocument()) continue;
            this.cache.startDocument = (StartDocument)event;
            return this.cache.startDocument;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the start document event is absent"));
    }

    private boolean hasStartElement() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readStartDocument();
        }
        if (this.cache.hasStartElement()) {
            return true;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.peek();
            if (event.isStartElement() && NOTES_STYLE.equals(event.asStartElement().getName().getLocalPart())) {
                return true;
            }
            this.cache.eventReader.nextEvent();
        }
        return false;
    }

    @Override
    public StartElement readStartElement() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readStartDocument();
        }
        if (this.cache.hasStartElement()) {
            return this.cache.startElement;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (!event.isStartElement() || !NOTES_STYLE.equals(event.asStartElement().getName().getLocalPart())) continue;
            this.cache.startElement = event.asStartElement();
            return this.cache.startElement;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the start element is absent"));
    }

    PresentationNotesStyleDefinition readDocumentDefaults() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            if (this.hasStartElement()) {
                this.readStartElement();
            } else {
                return new PresentationNotesStyleDefinition.Empty();
            }
        }
        if (this.cache.hasDocumentDefaults()) {
            return this.cache.documentDefaults;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(DEF_RPR)) {
                this.cache.documentDefaults = new PresentationNotesStyleDefinition.ParagraphDefault(this.conditionalParameters, this.eventFactory, event.asStartElement());
                this.cache.documentDefaults.readWith(this.cache.eventReader);
                return this.cache.documentDefaults;
            }
            if (event.isStartElement() && this.paragraphLevels.contains(event.asStartElement().getName().getLocalPart())) {
                this.cache.paragraphStyleStartElement = event.asStartElement();
                break;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(NOTES_STYLE)) continue;
            break;
        }
        return new PresentationNotesStyleDefinition.Empty();
    }

    boolean hasNextParagraphLevel() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readDocumentDefaults();
        }
        if (this.cache.hasParagraphStyleStartElement()) {
            return true;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.peek();
            if (event.isStartElement() && this.paragraphLevels.contains(event.asStartElement().getName().getLocalPart())) {
                return true;
            }
            if (event.isEndElement() && NOTES_STYLE.equals(event.asEndElement().getName().getLocalPart())) {
                this.cache.eventReader.nextEvent();
                return false;
            }
            this.cache.eventReader.nextEvent();
        }
        return false;
    }

    PresentationNotesStyleDefinition readNextParagraphLevel() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readDocumentDefaults();
        }
        if (this.cache.hasParagraphStyleStartElement()) {
            PresentationNotesStyleDefinition styleDefinition = this.presentationNotesStyleDefinition(this.cache.paragraphStyleStartElement);
            styleDefinition.readWith(this.cache.eventReader);
            this.cache.invalidateParagraphStyleStartElement();
            return styleDefinition;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (event.isStartElement() && this.paragraphLevels.contains(event.asStartElement().getName().getLocalPart())) {
                PresentationNotesStyleDefinition styleDefinition = this.presentationNotesStyleDefinition(event.asStartElement());
                styleDefinition.readWith(this.cache.eventReader);
                return styleDefinition;
            }
            if (!event.isEndElement() || !NOTES_STYLE.equals(event.asEndElement().getName().getLocalPart())) continue;
            return new PresentationNotesStyleDefinition.Empty();
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the notes-style-start and notes-style-end elements are absent"));
    }

    private PresentationNotesStyleDefinition presentationNotesStyleDefinition(StartElement paragraphStyleStartElement) {
        return new PresentationNotesStyleDefinition.ParagraphLevel(new PresentationNotesStyleDefinition.ParagraphDefault(this.conditionalParameters, this.eventFactory, paragraphStyleStartElement));
    }

    @Override
    public EndElement readEndElement() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EndDocument readEndDocument() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    static class Cache {
        private XMLEventReader eventReader;
        private StartDocument startDocument;
        private StartElement startElement;
        private PresentationNotesStyleDefinition documentDefaults;
        private StartElement paragraphStyleStartElement;

        Cache() {
        }

        boolean hasEventReader() {
            return null != this.eventReader;
        }

        boolean hasStartDocument() {
            return null != this.startDocument;
        }

        boolean hasStartElement() {
            return null != this.startElement;
        }

        boolean hasDocumentDefaults() {
            return null != this.documentDefaults;
        }

        boolean hasParagraphStyleStartElement() {
            return null != this.paragraphStyleStartElement;
        }

        void invalidateParagraphStyleStartElement() {
            this.paragraphStyleStartElement = null;
        }
    }
}

