/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinition;

interface PresentationNotesStyleDefinition
extends StyleDefinition {
    public static final String EMPTY = "";

    public String id();

    public static class ParagraphLevel
    implements PresentationNotesStyleDefinition {
        private static final int ID_BEGIN_INDEX = 3;
        private static final int ID_END_INDEX = 4;
        private final ParagraphDefault paragraphDefault;
        private String id;

        ParagraphLevel(ParagraphDefault paragraphDefault) {
            this.paragraphDefault = paragraphDefault;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.id = this.readId();
            this.paragraphDefault.readWith(reader);
        }

        private String readId() {
            return this.paragraphDefault.startElement.getName().getLocalPart().substring(3, 4);
        }

        @Override
        public RunProperties runProperties() {
            return this.paragraphDefault.runProperties();
        }

        @Override
        public Markup toMarkup() {
            return this.paragraphDefault.toMarkup();
        }
    }

    public static class ParagraphDefault
    implements PresentationNotesStyleDefinition {
        private static final String DEF_RPR = "defRPr";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private RunProperties defaultRunProperties;

        ParagraphDefault(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public String id() {
            return PresentationNotesStyleDefinition.EMPTY;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isEndElement()) {
                    if (!event.asEndElement().getName().equals(this.startElement.getName())) continue;
                    if (null == this.defaultRunProperties) {
                        this.defaultRunProperties = RunProperties.emptyRunProperties();
                    }
                    return;
                }
                if (!event.isStartElement() || !DEF_RPR.equals(event.asStartElement().getName().getLocalPart())) continue;
                this.defaultRunProperties = this.readDefaultRunProperties(event.asStartElement(), reader);
            }
        }

        private RunProperties readDefaultRunProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(startElement, reader, this.eventFactory, this.conditionalParameters);
            return new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
        }

        @Override
        public RunProperties runProperties() {
            return this.defaultRunProperties;
        }

        @Override
        public Markup toMarkup() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Empty
    implements PresentationNotesStyleDefinition {
        @Override
        public String id() {
            return PresentationNotesStyleDefinition.EMPTY;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public RunProperties runProperties() {
            return new RunProperties.Empty();
        }

        @Override
        public Markup toMarkup() {
            return new Markup.Empty();
        }
    }
}

