/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ExcelCommentPart;
import net.sf.okapi.filters.openxml.ExcelFormulaPart;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.ExcelWorkbook;
import net.sf.okapi.filters.openxml.ExcelWorksheetWriter;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringsPart;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class ExcelDocument
implements Document {
    private static final String COMMENTS = "/comments";
    private static final String DRAWINGS = "/drawing";
    private static final String CHART = "/chart";
    private static final String DIAGRAM_DATA = "/diagramData";
    private static final String SHARED_STRINGS = "/sharedStrings";
    private static final String STYLES = "/styles";
    private final Document.General generalDocument;
    private Enumeration<? extends ZipEntry> entries;
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final Map<String, String> sharedStrings;
    private LinkedHashMap<ZipEntry, String> postponedParts;
    private SharedStringMap sharedStringMap = new SharedStringMap();
    private List<String> worksheetEntryNames = null;
    private ExcelStyles styles;
    private Relationships workbookRels;
    private Map<String, ExcelWorkbook.Sheet> worksheets = new HashMap<String, ExcelWorkbook.Sheet>();
    private Map<String, Boolean> tableVisibility = new HashMap<String, Boolean>();
    private Map<String, String> sheetsByComment = new HashMap<String, String>();
    private Map<String, String> sheetsByDrawing = new HashMap<String, String>();
    private Map<String, String> drawingsByChart = new HashMap<String, String>();
    private Map<String, String> drawingsByDiagramData = new HashMap<String, String>();

    ExcelDocument(Document.General generalDocument, EncoderManager encoderManager, IFilter subfilter) {
        this.generalDocument = generalDocument;
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.sharedStrings = new HashMap<String, String>();
        this.postponedParts = new LinkedHashMap();
    }

    private boolean isModifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml".equals(contentType);
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.workbookRels = this.generalDocument.relationshipsForPartName(this.generalDocument.mainPartName());
        this.worksheetEntryNames = this.findWorksheets();
        this.entries = this.entries();
        this.styles = this.parseStyles();
        this.sheetsByComment = this.findComments(this.worksheetEntryNames);
        this.sheetsByDrawing = this.findDrawings(this.worksheetEntryNames);
        this.drawingsByChart = this.findCharts(this.sheetsByDrawing.keySet());
        this.drawingsByDiagramData = this.findDiagramData(this.sheetsByDrawing.keySet());
        return this.generalDocument.startDocumentEvent();
    }

    private Enumeration<? extends ZipEntry> entries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.generalDocument.entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        ArrayList<String> worksheetsAndSharedStrings = new ArrayList<String>(this.worksheetEntryNames);
        worksheetsAndSharedStrings.addAll(this.findSharedStrings());
        entryList.sort(new ZipEntryComparator(worksheetsAndSharedStrings));
        return Collections.enumeration(entryList);
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type;
        switch (type = this.generalDocument.contentTypeFor(entry)) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": 
            case "application/vnd.openxmlformats-officedocument.drawing+xml": 
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPostponedTranslatables() {
        return true;
    }

    @Override
    public void updatePostponedTranslatables(String key, String value) {
        this.sharedStrings.put(key, value);
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements() || !this.postponedParts.isEmpty();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        if (!this.entries.hasMoreElements()) {
            return this.nextPostponedPart();
        }
        ZipEntry entry = this.entries.nextElement();
        String contentType = this.generalDocument.contentTypeFor(entry);
        if (this.isPartHidden(entry.getName(), contentType)) {
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (!this.isTranslatablePart(entry.getName(), contentType)) {
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) {
                if (this.isSheetHidden(entry.getName())) {
                    return new ModifiablePart(this.generalDocument, entry, new ByteArrayInputStream(new ExcelWorksheetWriter(this.generalDocument, entry, this.sharedStringMap, this.styles, this.tableVisibility, this.findWorksheetNumber(entry.getName()), true, this.worksheets.get(entry.getName()).getName()).toString().getBytes(OpenXMLFilter.ENCODING)));
                }
                this.postponedParts.put(entry, new ExcelWorksheetWriter(this.generalDocument, entry, this.sharedStringMap, this.styles, this.tableVisibility, this.findWorksheetNumber(entry.getName()), false, this.worksheets.get(entry.getName()).getName()).toString());
                return this.nextPart();
            }
            if (this.isModifiablePart(contentType)) {
                return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        StyleDefinitions.Empty styleDefinitions = new StyleDefinitions.Empty();
        StyleOptimisation.Bypass styleOptimisation = new StyleOptimisation.Bypass();
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": {
                return new SharedStringsPart(this.generalDocument, entry, styleDefinitions, styleOptimisation, this.encoderManager, this.subfilter, this.sharedStringMap);
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return new ExcelCommentPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
            }
        }
        ParseType parseType = null;
        switch (contentType) {
            case "application/vnd.openxmlformats-package.core-properties+xml": {
                parseType = ParseType.MSWORDDOCPROPERTIES;
                break;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
                parseType = ParseType.MSEXCEL;
            }
        }
        if (ParseType.MSWORDDOCPROPERTIES.equals((Object)parseType) || ParseType.MSEXCEL.equals((Object)parseType)) {
            ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
            contentFilter.setUpConfig(parseType);
            return new DefaultPart(this.generalDocument, entry, contentFilter);
        }
        return new ExcelFormulaPart(this.generalDocument, entry, this.sharedStrings, this.generalDocument.inputStreamFor(entry));
    }

    private boolean isSheetHidden(String entryName) {
        ExcelWorkbook.Sheet sheet = this.worksheets.get(entryName);
        return sheet != null && !sheet.visible;
    }

    private Part nextPostponedPart() throws IOException, XMLStreamException {
        Iterator<Map.Entry<ZipEntry, String>> iterator = this.postponedParts.entrySet().iterator();
        Map.Entry<ZipEntry, String> mapEntry = iterator.next();
        iterator.remove();
        return new ModifiablePart(this.generalDocument, mapEntry.getKey(), new ByteArrayInputStream(new ExcelFormulaPart(this.generalDocument, mapEntry.getKey(), this.sharedStrings, new ByteArrayInputStream(mapEntry.getValue().getBytes(OpenXMLFilter.ENCODING))).getModifiedContent().getBytes(OpenXMLFilter.ENCODING)));
    }

    private boolean isTranslatablePart(String entryName, String contentType) {
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml".equals(contentType)) {
            Boolean b = this.tableVisibility.get(entryName);
            return b != null ? b : false;
        }
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return true;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": 
            case "application/vnd.ms-excel.sheet.macroEnabled.main+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelSheetNames();
            }
            case "application/vnd.openxmlformats-package.core-properties+xml": {
                return this.generalDocument.conditionalParameters().getTranslateDocProperties();
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.generalDocument.conditionalParameters().getTranslateComments();
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelDrawings();
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelDiagramData();
            }
        }
        return false;
    }

    private ExcelWorkbook parseWorkbook(String partName) throws IOException, XMLStreamException {
        XMLEventReader r = this.generalDocument.inputFactory().createXMLEventReader(this.generalDocument.getPartReader(partName));
        return new ExcelWorkbook().parseFrom(r, this.generalDocument.conditionalParameters());
    }

    private ExcelStyles parseStyles() throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        Relationships.Rel stylesRel = this.workbookRels.getRelByType(namespaceUri.concat(STYLES)).get(0);
        ExcelStyles styles = new ExcelStyles();
        styles.parse(this.generalDocument.inputFactory().createXMLEventReader(this.generalDocument.getPartReader(stylesRel.target)));
        return styles;
    }

    List<String> findWorksheets() throws IOException, XMLStreamException {
        ArrayList<String> worksheetNames = new ArrayList<String>();
        ExcelWorkbook workbook = this.parseWorkbook(this.generalDocument.mainPartName());
        List<ExcelWorkbook.Sheet> sheets = workbook.getSheets();
        for (ExcelWorkbook.Sheet sheet : sheets) {
            Relationships.Rel sheetRel = this.workbookRels.getRelById(sheet.relId);
            worksheetNames.add(sheetRel.target);
            this.worksheets.put(sheetRel.target, sheet);
        }
        return worksheetNames;
    }

    List<String> findSharedStrings() throws IOException, XMLStreamException {
        String sharedStringsNamespaceUri;
        Relationships rels = this.generalDocument.relationshipsForPartName(this.generalDocument.mainPartName());
        List<Relationships.Rel> r = rels.getRelByType(sharedStringsNamespaceUri = this.generalDocument.documentRelationshipsNamespace().uri().concat(SHARED_STRINGS));
        if (r == null) {
            return Collections.emptyList();
        }
        if (r.size() != 1) {
            throw new OkapiBadFilterInputException(String.format("%s: %s", "Unexpected number of relationships", sharedStringsNamespaceUri));
        }
        return Collections.singletonList(r.get((int)0).target);
    }

    private int findWorksheetNumber(String worksheetEntryName) {
        for (int i = 0; i < this.worksheetEntryNames.size(); ++i) {
            if (!worksheetEntryName.equals(this.worksheetEntryNames.get(i))) continue;
            return i + 1;
        }
        throw new IllegalStateException("No worksheet entry with name " + worksheetEntryName + " in " + this.worksheetEntryNames);
    }

    private boolean isPartHidden(String entryName, String contentType) {
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.isCommentHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.isDrawingHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isChartHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isDiagramDataHidden(entryName);
            }
        }
        return false;
    }

    private boolean isCommentHidden(String entryName) {
        if (!this.sheetsByComment.containsKey(entryName)) {
            return false;
        }
        String sheetEntryName = this.sheetsByComment.get(entryName);
        return this.isSheetHidden(sheetEntryName);
    }

    private boolean isDrawingHidden(String entryName) {
        if (!this.sheetsByDrawing.containsKey(entryName)) {
            return false;
        }
        String sheetEntryName = this.sheetsByDrawing.get(entryName);
        return this.isSheetHidden(sheetEntryName);
    }

    private boolean isChartHidden(String entryName) {
        if (!this.drawingsByChart.containsKey(entryName)) {
            return false;
        }
        String drawingEntryName = this.drawingsByChart.get(entryName);
        return this.isDrawingHidden(drawingEntryName);
    }

    private boolean isDiagramDataHidden(String entryName) {
        if (!this.drawingsByDiagramData.containsKey(entryName)) {
            return false;
        }
        String drawingEntryName = this.drawingsByDiagramData.get(entryName);
        return this.isDrawingHidden(drawingEntryName);
    }

    private Map<String, String> findComments(List<String> sheetEntryNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(sheetEntryNames, namespaceUri.concat(COMMENTS));
    }

    private Map<String, String> findDrawings(List<String> sheetEntryNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(sheetEntryNames, namespaceUri.concat(DRAWINGS));
    }

    private Map<String, String> findCharts(Set<String> drawingEntryNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(new ArrayList<String>(drawingEntryNames), namespaceUri.concat(CHART));
    }

    private Map<String, String> findDiagramData(Set<String> drawingEntryNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(new ArrayList<String>(drawingEntryNames), namespaceUri.concat(DIAGRAM_DATA));
    }

    @Override
    public void close() throws IOException {
    }
}

