/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;

interface BlockProperties
extends MarkupComponent,
Nameable {
    public static final String TBL_PR = "tblPr";
    public static final String TR_PR = "trPr";
    public static final String TC_PR = "tcPr";
    public static final String TBL_STYLE_PR = "tblStylePr";

    public StartElement startElement();

    public List<Attribute> attributes();

    public List<BlockProperty> properties();

    public boolean isEmpty();

    public static class Default
    implements BlockProperties {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final EndElement endElement;
        private final List<Attribute> attributes;
        private final List<BlockProperty> properties;

        Default(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, List<BlockProperty> properties) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.endElement = endElement;
            this.attributes = new ArrayList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                this.attributes.add(iterator.next());
            }
            this.properties = new ArrayList<BlockProperty>(properties);
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.attributes().iterator(), this.startElement.getNamespaces()));
            for (BlockProperty property : this.properties) {
                events.addAll(property.getEvents());
            }
            events.add(this.endElement);
            return events;
        }

        @Override
        public StartElement startElement() {
            return this.startElement;
        }

        @Override
        public List<Attribute> attributes() {
            return this.attributes;
        }

        @Override
        public List<BlockProperty> properties() {
            return this.properties;
        }

        @Override
        public boolean isEmpty() {
            return this.attributes.isEmpty() && this.properties.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            String prefix = this.startElement.getName().getPrefix();
            if (!prefix.isEmpty()) {
                builder.append(prefix).append(":");
            }
            builder.append(this.startElement.getName().getLocalPart()).append(" ").append("(").append(this.attributes.size()).append(")").append(this.toString(this.attributes)).append(" ").append("(").append(this.properties.size()).append(")").append(this.properties);
            return builder.toString();
        }

        private String toString(List<Attribute> attributes) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (Attribute attribute : attributes) {
                String prefix = attribute.getName().getPrefix();
                if (!prefix.isEmpty()) {
                    builder.append(prefix).append(":");
                }
                builder.append(attribute.getName().getLocalPart()).append("=\"");
                builder.append(attribute.getValue()).append("\"");
            }
            builder.append("]");
            return builder.toString();
        }
    }

    public static class Empty
    implements BlockProperties {
        private final StartElement startElement;

        Empty(StartElement startElement) {
            this.startElement = startElement;
        }

        @Override
        public StartElement startElement() {
            return this.startElement;
        }

        @Override
        public List<Attribute> attributes() {
            return Collections.emptyList();
        }

        @Override
        public List<BlockProperty> properties() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.startElement.getName().getLocalPart().concat("(No properties)");
        }
    }
}

