/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mosestext;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.mosestext.FilterWriterParameters;

public class MosesTextFilterWriter
implements IFilterWriter {
    private OutputStream output;
    private String srcOutputPath;
    private String trgOutputPath;
    private OutputStreamWriter srcWriter;
    private OutputStreamWriter trgWriter;
    private LocaleId trgLoc;
    private FilterWriterParameters params;
    private final String lineBreak = System.getProperty("line.separator");

    public MosesTextFilterWriter() {
        this.params = new FilterWriterParameters();
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        try {
            if (this.srcWriter != null) {
                this.srcWriter.close();
                this.srcWriter = null;
            }
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
            if (this.trgWriter != null) {
                this.trgWriter.close();
                this.trgWriter = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public String getName() {
        return "MosesTextFilterWriter";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case END_DOCUMENT: {
                this.close();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.srcOutputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.srcOutputPath = null;
        this.output = output;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (FilterWriterParameters)params;
    }

    private void processStartDocument(StartDocument sd) {
        try {
            String srcLCode = sd.getLocale().toString();
            if (this.output == null) {
                Util.createDirectories(this.srcOutputPath);
                this.output = new BufferedOutputStream(new FileOutputStream(this.srcOutputPath));
            }
            this.srcWriter = new OutputStreamWriter(this.output, StandardCharsets.UTF_8);
            if (this.params.getSourceAndTarget()) {
                String ext = Util.getExtension(this.srcOutputPath);
                this.trgOutputPath = ext.equals("." + srcLCode) ? Util.getDirectoryName(this.srcOutputPath) + File.separator + Util.getFilename(this.srcOutputPath, false) + "." + this.trgLoc.toString() : this.srcOutputPath + "." + this.trgLoc.toString();
                this.trgWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.trgOutputPath)), StandardCharsets.UTF_8);
            } else {
                this.trgWriter = null;
            }
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
    }

    private void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        try {
            ISegments srcSegs = tu.getSource().getSegments();
            ISegments trgSegs = null;
            if (tu.hasTarget(this.trgLoc)) {
                trgSegs = tu.getTargetSegments(this.trgLoc);
            }
            for (Segment seg : srcSegs) {
                Segment trgSeg;
                this.srcWriter.write(this.toMosesText(seg.text));
                this.srcWriter.write(this.lineBreak);
                if (this.trgWriter == null) continue;
                if (trgSegs != null && (trgSeg = trgSegs.get(seg.id)) != null) {
                    this.trgWriter.write(this.toMosesText(trgSeg.text));
                }
                this.trgWriter.write(this.lineBreak);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private String toMosesText(TextFragment frag) {
        boolean escapeGT = false;
        int quoteMode = 0;
        String codedText = frag.getCodedText();
        List<Code> codes = frag.getCodes();
        StringBuilder tmp = new StringBuilder();
        block16: for (int i = 0; i < codedText.length(); ++i) {
            switch (codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(codedText.charAt(++i));
                    Code code = codes.get(index);
                    if (code.getType().equals("mrk")) {
                        tmp.append(code.getOuterData());
                        continue block16;
                    }
                    tmp.append(String.format("<g id=\"%d\">", code.getId()));
                    continue block16;
                }
                case 57602: {
                    int index = TextFragment.toIndex(codedText.charAt(++i));
                    Code code = codes.get(index);
                    if (code.getType().equals("mrk")) {
                        tmp.append(code.getOuterData());
                        continue block16;
                    }
                    tmp.append("</g>");
                    continue block16;
                }
                case 57603: {
                    int index = TextFragment.toIndex(codedText.charAt(++i));
                    Code code = codes.get(index);
                    if (code.getTagType() == TextFragment.TagType.OPENING) {
                        tmp.append(String.format("<bx id=\"%d\"/>", code.getId()));
                        continue block16;
                    }
                    if (code.getTagType() == TextFragment.TagType.CLOSING) {
                        tmp.append(String.format("<ex id=\"%d\"/>", code.getId()));
                        continue block16;
                    }
                    tmp.append(String.format("<x id=\"%d\"/>", code.getId()));
                    continue block16;
                }
                case 62: {
                    if (escapeGT) {
                        tmp.append("&gt;");
                        continue block16;
                    }
                    if (i > 0 && codedText.charAt(i - 1) == ']') {
                        tmp.append("&gt;");
                        continue block16;
                    }
                    tmp.append('>');
                    continue block16;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block16;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block16;
                }
                case 13: {
                    tmp.append("&#13;");
                    continue block16;
                }
                case 34: {
                    if (quoteMode > 0) {
                        tmp.append("&quot;");
                        continue block16;
                    }
                    tmp.append('\"');
                    continue block16;
                }
                case 39: {
                    switch (quoteMode) {
                        case 1: {
                            tmp.append("&apos;");
                            continue block16;
                        }
                        case 2: {
                            tmp.append("&#39;");
                            continue block16;
                        }
                    }
                    tmp.append(codedText.charAt(i));
                    continue block16;
                }
                case 10: {
                    tmp.append("<lb/>");
                    continue block16;
                }
                default: {
                    tmp.append(codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }
}

