/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class MIFEncoder
implements IEncoder {
    private CharsetEncoder charsetEncoder;
    private IParameters parameters;
    private String encoding;
    private String lineBreak;

    @Override
    public void reset() {
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.parameters = params;
        this.encoding = encoding;
        this.lineBreak = lineBreak;
        this.charsetEncoder = Charset.forName(encoding).newEncoder();
    }

    @Override
    public String encode(String text, EncoderContext context) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            escaped.append(this.encode(text.charAt(i), context));
        }
        return escaped.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        switch (value) {
            case '\t': {
                return "\\t";
            }
            case '>': {
                return "\\>";
            }
            case '\'': {
                return "\\q";
            }
            case '`': {
                return "\\Q";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            return this.encode(new String(Character.toChars(value)), context);
        }
        return this.encode((char)value, context);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.charsetEncoder;
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }
}

