/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.filters.mif.Document;
import net.sf.okapi.filters.mif.Parameters;
import net.sf.okapi.filters.mif.Statement;
import net.sf.okapi.filters.mif.Token;

final class Extracts {
    private static final String DEFAULT_LINE_BREAK = "\n";
    private static final Set<String> MASTER_PAGES = new HashSet<String>(Arrays.asList("LeftMasterPage", "RightMasterPage", "OtherMasterPage"));
    private static final Set<String> REFERENCE_PAGES = Collections.singleton("ReferencePage");
    private static final Set<String> BODY_PAGES = Collections.singleton("BodyPage");
    private static final Set<String> HIDDEN_PAGES = Collections.singleton("HiddenPage");
    private static final String MIF_FILE = "MIFFile";
    private static final String PAGE = "Page";
    private static final String PAGE_TYPE = "PageType";
    private static final String TEXT_RECT = "TextRect";
    private static final String ID = "ID";
    private static final String ANCHORED_FRAMES = "AFrames";
    private static final String FRAME = "Frame";
    private static final String TABLES = "Tbls";
    private static final String TEXT_FLOW = "TextFlow";
    private static final String TABLE = "Tbl";
    private static final String PARA = "Para";
    private static final String PARA_LINE = "ParaLine";
    private static final String TEXT_RECT_ID = "TextRectID";
    private static final String ANCHORED_FRAME = "AFrame";
    private static final String ANCHORED_TABLE = "ATbl";
    private static final String TABLE_ID = "TblID";
    private static final String TABLE_TITLE = "TblTitle";
    private static final String TABLE_TITLE_CONTENT = "TblTitleContent";
    private static final String TABLE_HEADER = "TblH";
    private static final String TABLE_ROW = "Row";
    private static final String TABLE_CELL = "Cell";
    private static final String TABLE_CELL_CONTENT = "CellContent";
    private static final String TABLE_BODY = "TblBody";
    private static final String PGF_TAG = "PgfTag";
    private static final String PGF_NUM_STRING = "PgfNumString";
    private static final String PGF = "Pgf";
    private static final String PGF_NUM_FORMAT = "PgfNumFormat";
    private final Parameters parameters;
    private final Set<String> extractableTextFlows;
    private final Set<String> extractableTables;
    private final Set<String> extractableParagraphFormatTags;
    private String lineBreak;

    Extracts(Parameters parameters, Set<String> extractableTextFlows, Set<String> extractableTables, Set<String> extractableParagraphFormatTags) {
        this.parameters = parameters;
        this.extractableTextFlows = extractableTextFlows;
        this.extractableTables = extractableTables;
        this.extractableParagraphFormatTags = extractableParagraphFormatTags;
    }

    String lineBreak() {
        return Objects.isNull(this.lineBreak) ? DEFAULT_LINE_BREAK : this.lineBreak;
    }

    boolean isTextFlowExtractable(String textFlowNumber) {
        return this.extractableTextFlows.contains(textFlowNumber);
    }

    boolean isTableExtractable(String tableId) {
        return this.extractableTables.contains(tableId);
    }

    boolean isParagraphFormatTagExtractable(String paragraphFormatTag) {
        return this.extractableParagraphFormatTags.contains(paragraphFormatTag);
    }

    void from(Document document) {
        LinkedHashSet<String> textRects = new LinkedHashSet<String>();
        LinkedList<Statement> anchoredFrames = new LinkedList<Statement>();
        LinkedList<Statement> tables = new LinkedList<Statement>();
        LinkedHashMap<String, Statement> textFlows = new LinkedHashMap<String, Statement>();
        boolean pagesSpecified = false;
        Document.Version documentVersion = null;
        int textFlowNumber = 0;
        while (document.hasNext()) {
            String identity;
            Statement statement = (Statement)document.next();
            if (Objects.isNull(this.lineBreak) && Statement.Type.COMMENT == statement.statementType()) {
                this.identifyLineBreak(statement);
                continue;
            }
            if (Statement.Type.MARKUP != statement.statementType()) continue;
            switch (identity = statement.firstTokenOf(Token.Type.IDENTITY).toString()) {
                case "MIFFile": {
                    documentVersion = new Document.Version(statement.firstTokenOf(Token.Type.LITERAL).toString());
                    documentVersion.validate();
                    break;
                }
                case "Page": {
                    pagesSpecified = true;
                    textRects.addAll(this.pageTextRectsFrom(statement));
                    break;
                }
                case "AFrames": {
                    anchoredFrames.addAll(statement.statementsWith(FRAME));
                    break;
                }
                case "Tbls": {
                    tables.addAll(statement.statementsWith(TABLE));
                    break;
                }
                case "TextFlow": {
                    textFlows.put(String.valueOf(++textFlowNumber), statement);
                }
            }
        }
        if (Objects.isNull(documentVersion)) {
            throw new OkapiIOException("The provided document type is unsupported.");
        }
        this.extractableTextFlows.clear();
        this.extractableTables.clear();
        this.extractableParagraphFormatTags.clear();
        Map<String, Statement> anchoredTables = this.anchoredTables(tables);
        if (!pagesSpecified) {
            Map<String, Statement> referentTables = this.referentTables(textFlows, anchoredTables);
            this.addExtractableTextFlowsAndTables(textFlows, referentTables);
            return;
        }
        this.scanForExtractableTextFlowsAndTables(textFlows, textRects, this.anchoredFrameTextRects(anchoredFrames), anchoredTables);
        this.scanForExtractableParagraphFormatTags(textFlows, anchoredTables);
    }

    private void identifyLineBreak(Statement statement) {
        String value = statement.firstTokenOf(Token.Type.END).toString();
        this.lineBreak = value.equals(DEFAULT_LINE_BREAK) ? value : value.concat(DEFAULT_LINE_BREAK);
    }

    private Set<String> pageTextRectsFrom(Statement statement) {
        String pageType = statement.firstStatementWith(PAGE_TYPE).firstTokenOf(Token.Type.LITERAL).toString();
        if (this.parameters.getExtractMasterPages() && MASTER_PAGES.contains(pageType) || this.parameters.getExtractReferencePages() && REFERENCE_PAGES.contains(pageType) || this.parameters.getExtractBodyPages() && BODY_PAGES.contains(pageType) || this.parameters.getExtractHiddenPages() && HIDDEN_PAGES.contains(pageType)) {
            return statement.statementsWith(TEXT_RECT).stream().map(s -> s.firstStatementWith(ID).firstTokenOf(Token.Type.LITERAL).toString()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Map<String, Set<String>> anchoredFrameTextRects(List<Statement> anchoredFrames) {
        return anchoredFrames.stream().map(s -> new AbstractMap.SimpleEntry(s.firstStatementWith(ID).firstTokenOf(Token.Type.LITERAL).toString(), s.statementsWith(TEXT_RECT).stream().map(tr -> tr.firstStatementWith(ID).firstTokenOf(Token.Type.LITERAL).toString()).collect(Collectors.toSet()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Statement> anchoredTables(List<Statement> anchoredTables) {
        return anchoredTables.stream().map(s -> new AbstractMap.SimpleEntry<String, Statement>(s.firstStatementWith(TABLE_ID).firstTokenOf(Token.Type.LITERAL).toString(), (Statement)s)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void addExtractableTextFlowsAndTables(Map<String, Statement> textFlows, Map<String, Statement> tables) {
        this.extractableTextFlows.addAll(textFlows.keySet());
        this.extractableTables.addAll(tables.keySet());
        this.extractableTables.addAll(this.tableReferencesOf(tables.values(), ANCHORED_TABLE));
    }

    private void scanForExtractableTextFlowsAndTables(Map<String, Statement> textFlows, Set<String> textRects, Map<String, Set<String>> anchoredFrameTextRects, Map<String, Statement> anchoredTables) {
        Map<String, Statement> referentTextFlows = this.referentTextFlows(textFlows, textRects);
        Map<String, Statement> referentTables = this.referentTables(referentTextFlows, anchoredTables);
        this.addExtractableTextFlowsAndTables(referentTextFlows, referentTables);
        Set<String> referentTextRects = this.referentTextRects(referentTextFlows, referentTables, anchoredFrameTextRects);
        if (!referentTextRects.isEmpty()) {
            this.scanForExtractableTextFlowsAndTables(textFlows, referentTextRects, anchoredFrameTextRects, anchoredTables);
        }
    }

    private Map<String, Statement> referentTextFlows(Map<String, Statement> textFlows, Set<String> textRects) {
        return textFlows.entrySet().stream().filter(e -> ((Statement)e.getValue()).statementsWith(PARA).stream().anyMatch(p -> p.statementsWith(PARA_LINE).stream().anyMatch(pl -> textRects.contains(pl.firstStatementWith(TEXT_RECT_ID).firstTokenOf(Token.Type.LITERAL).toString())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Statement> referentTables(Map<String, Statement> frameTextFlows, Map<String, Statement> anchoredTables) {
        Set<String> anchoredTableReferences = this.anchoredReferences(frameTextFlows.values(), ANCHORED_TABLE);
        return anchoredTables.entrySet().stream().filter(e -> anchoredTableReferences.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Set<String> tableReferencesOf(Collection<Statement> referentTables, String referenceName) {
        LinkedHashSet<String> references = new LinkedHashSet<String>();
        references.addAll(this.anchoredReferences(this.tableTitleContentFlows(referentTables), referenceName));
        references.addAll(this.anchoredReferences(this.tableContentFlowsOf(referentTables, TABLE_HEADER), referenceName));
        references.addAll(this.anchoredReferences(this.tableContentFlowsOf(referentTables, TABLE_BODY), referenceName));
        return references;
    }

    private List<Statement> tableTitleContentFlows(Collection<Statement> referentTables) {
        return referentTables.stream().map(s -> s.statementsWith(TABLE_TITLE)).flatMap(Collection::stream).map(s -> s.statementsWith(TABLE_TITLE_CONTENT)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Statement> tableContentFlowsOf(Collection<Statement> referentTables, String rootIdentity) {
        return referentTables.stream().map(s -> s.statementsWith(rootIdentity)).flatMap(Collection::stream).map(s -> s.statementsWith(TABLE_ROW)).flatMap(Collection::stream).map(s -> s.statementsWith(TABLE_CELL)).flatMap(Collection::stream).map(s -> s.statementsWith(TABLE_CELL_CONTENT)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Set<String> referentTextRects(Map<String, Statement> referentTextFlows, Map<String, Statement> referentTables, Map<String, Set<String>> anchoredFrameTextRects) {
        LinkedHashSet<String> anchoredFrameReferences = new LinkedHashSet<String>();
        anchoredFrameReferences.addAll(this.anchoredReferences(referentTextFlows.values(), ANCHORED_FRAME));
        anchoredFrameReferences.addAll(this.tableReferencesOf(referentTables.values(), ANCHORED_FRAME));
        return anchoredFrameReferences.stream().filter(s -> anchoredFrameTextRects.keySet().contains(s)).map(s -> (Set)anchoredFrameTextRects.get(s)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> anchoredReferences(Collection<Statement> contentFlows, String referenceName) {
        return contentFlows.stream().map(v -> v.statementsWith(PARA)).flatMap(Collection::stream).map(s -> s.statementsWith(PARA_LINE)).flatMap(Collection::stream).map(s -> s.statementsWith(referenceName)).flatMap(Collection::stream).map(s -> s.firstTokenOf(Token.Type.LITERAL).toString()).collect(Collectors.toSet());
    }

    private void scanForExtractableParagraphFormatTags(Map<String, Statement> textFlows, Map<String, Statement> anchoredTables) {
        LinkedList paragraphs = new LinkedList();
        paragraphs.addAll(textFlows.entrySet().stream().filter(e -> this.extractableTextFlows.contains(e.getKey())).map(e -> (Statement)e.getValue()).map(s -> s.statementsWith(PARA)).flatMap(Collection::stream).collect(Collectors.toList()));
        List<Statement> tables = anchoredTables.entrySet().stream().filter(e -> this.extractableTables.contains(e.getKey())).map(e -> (Statement)e.getValue()).collect(Collectors.toList());
        LinkedList<Statement> tableContentFlows = new LinkedList<Statement>();
        tableContentFlows.addAll(this.tableTitleContentFlows(tables));
        tableContentFlows.addAll(this.tableContentFlowsOf(tables, TABLE_HEADER));
        tableContentFlows.addAll(this.tableContentFlowsOf(tables, TABLE_BODY));
        paragraphs.addAll(tableContentFlows.stream().map(s -> s.statementsWith(PARA)).flatMap(Collection::stream).collect(Collectors.toList()));
        this.extractableParagraphFormatTags.addAll(paragraphs.stream().filter(s -> Statement.Type.EMPTY != s.firstStatementWith(PGF_TAG).statementType()).filter(s -> Statement.Type.EMPTY != s.firstStatementWith(PGF_NUM_STRING).statementType()).filter(s -> Statement.Type.EMPTY == s.firstStatementWith(PGF).firstStatementWith(PGF_NUM_FORMAT).statementType()).map(s -> s.firstStatementWith(PGF_TAG).firstTokenOf(Token.Type.LITERAL).toString()).collect(Collectors.toSet()));
    }
}

