/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.filters.mif.Statement;
import net.sf.okapi.filters.mif.Statements;

interface Document
extends Iterator<Statement> {
    public Statement currentMarkup();

    public static final class Version {
        private static final String UNSUPPORTED_DOCUMENT_VERSION = "Unsupported document version: ";
        private static Pattern PATTERN = Pattern.compile("^(\\d+\\.?\\d{0,2})");
        private static final double MIN_SUPPORTED_VERSION = 8.0;
        private final String value;

        Version(String value) {
            this.value = value;
        }

        void validate() {
            Matcher m = PATTERN.matcher(this.value);
            if (!m.lookingAt()) {
                throw new OkapiBadFilterInputException(UNSUPPORTED_DOCUMENT_VERSION.concat(this.value));
            }
            if (Double.valueOf(this.value) < 8.0) {
                throw new OkapiBadFilterInputException(UNSUPPORTED_DOCUMENT_VERSION.concat(this.value));
            }
        }
    }

    public static class Default
    implements Document {
        private static final Set<Character> WHITESPACES = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
        private final Statements statements;
        private final Reader reader;
        private final Queue<Statement> readStatements;

        Default(Statements statements, Reader reader, Queue<Statement> readStatements) {
            this.statements = statements;
            this.reader = reader;
            this.readStatements = readStatements;
        }

        @Override
        public boolean hasNext() {
            if (null != this.readStatements.peek()) {
                return true;
            }
            try {
                int ch;
                StringBuilder sb = new StringBuilder();
                while (true) {
                    if (-1 == (ch = this.reader.read())) {
                        if (0 == sb.length()) {
                            return false;
                        }
                        this.readStatements.add(this.statements.empty(sb));
                        return true;
                    }
                    if (!WHITESPACES.contains(Character.valueOf((char)ch))) break;
                    sb.append((char)ch);
                }
                if (0 != sb.length()) {
                    this.readStatements.add(this.statements.empty(sb));
                }
                this.readStatements.add(this.statements.fromFirstCharacter((char)ch));
                return true;
            }
            catch (IOException e) {
                throw new OkapiIOException("I/O error at reading: ".concat(e.getMessage()), e);
            }
        }

        @Override
        public Statement next() {
            return this.readStatements.poll();
        }

        @Override
        public Statement currentMarkup() {
            try {
                return this.statements.partialMarkup();
            }
            catch (IOException e) {
                throw new OkapiIOException("I/O error at reading: ".concat(e.getMessage()), e);
            }
        }
    }
}

