/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.idml.Accumulator;
import net.sf.okapi.filters.idml.DocumentPartEventBuilder;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.Story;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StoryChildElementsEventsAccumulator;

class StoryEventsAccumulator
implements Accumulator<Event> {
    private final Story story;
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator documentPartIdGenerator;
    private final IdGenerator textUnitIdGenerator;
    private List<Event> events;

    StoryEventsAccumulator(Story story, Parameters parameters, XMLEventFactory eventFactory, IdGenerator documentPartIdGenerator, IdGenerator textUnitIdGenerator) {
        this.story = story;
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.documentPartIdGenerator = documentPartIdGenerator;
        this.textUnitIdGenerator = textUnitIdGenerator;
        this.events = new ArrayList<Event>();
    }

    @Override
    public List<Event> accumulate() throws XMLStreamException {
        DocumentPartEventBuilder documentPartEventBuilder = new DocumentPartEventBuilder(this.documentPartIdGenerator);
        documentPartEventBuilder.addMarkupRange(Collections.singletonList(this.story.getStartDocumentEvent()));
        documentPartEventBuilder.addMarkupRangeStartElement(this.story.getWrappingStoryStartElement());
        documentPartEventBuilder.addMarkupRangeStartElement(this.story.getStoryStartElement());
        this.events.add(documentPartEventBuilder.build());
        ListIterator<StoryChildElement> storyChildElementIterator = this.story.getChildElements().listIterator();
        List<Event> storyChildElementEvents = new StoryChildElementsEventsAccumulator(this.parameters, this.eventFactory, this.documentPartIdGenerator, this.textUnitIdGenerator, storyChildElementIterator).accumulate();
        this.events.addAll(storyChildElementEvents);
        documentPartEventBuilder = new DocumentPartEventBuilder(this.documentPartIdGenerator);
        documentPartEventBuilder.addMarkupRangeEndElement(this.story.getStoryEndElement());
        documentPartEventBuilder.addMarkupRangeEndElement(this.story.getWrappingStoryEndElement());
        documentPartEventBuilder.addMarkupRange(Collections.singletonList(this.story.getEndDocumentEvent()));
        this.events.add(documentPartEventBuilder.build());
        return this.events;
    }
}

