/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.filters.idml.Accumulator;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StoryChildElementsEventsAccumulator;
import net.sf.okapi.filters.idml.StyledTextReferenceSkeleton;

class ReferentEventsAccumulator
implements Accumulator<Event> {
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final StoryChildElement.StyledTextReferenceElement styledTextReferenceElement;
    private final String parentId;
    private final IdGenerator idGenerator;
    private IdGenerator referentIdGenerator;

    ReferentEventsAccumulator(Parameters parameters, XMLEventFactory eventFactory, StoryChildElement.StyledTextReferenceElement styledTextReferenceElement, String parentId, IdGenerator idGenerator) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.styledTextReferenceElement = styledTextReferenceElement;
        this.parentId = parentId;
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Event> accumulate() throws XMLStreamException {
        ArrayList<Event> events = new ArrayList<Event>();
        ArrayList<Event> referentEvents = new ArrayList<Event>();
        StartGroup startGroup = this.createStartGroup();
        events.add(new Event(EventType.START_GROUP, startGroup));
        if (this.styledTextReferenceElement instanceof StoryChildElement.StyledTextReferenceElement.Table) {
            for (StoryChildElement.StyledTextReferenceElement.Table.Cell cell : ((StoryChildElement.StyledTextReferenceElement.Table)this.styledTextReferenceElement).getCells()) {
                this.referentIdGenerator = this.getReferentIdGenerator(startGroup.getId(), cell.getStartElement().getName().getLocalPart());
                referentEvents.addAll(new ReferentEventsAccumulator(this.parameters, this.eventFactory, cell, startGroup.getId(), this.referentIdGenerator).accumulate());
            }
        } else {
            IdGenerator documentPartIdGenerator = new IdGenerator(startGroup.getId(), "dp");
            IdGenerator textUnitIdGenerator = new IdGenerator(startGroup.getId(), "tu");
            ListIterator<StoryChildElement> storyChildElementIterator = this.styledTextReferenceElement.getStoryChildElements().listIterator();
            referentEvents.addAll(new StoryChildElementsEventsAccumulator(this.parameters, this.eventFactory, documentPartIdGenerator, textUnitIdGenerator, storyChildElementIterator).accumulate());
        }
        events.addAll(referentEvents);
        events.add(new Event(EventType.END_GROUP, new Ending(startGroup.getId())));
        return events;
    }

    private StartGroup createStartGroup() {
        StartGroup startGroup = new StartGroup(this.parentId, this.idGenerator.createId(), true);
        startGroup.setSkeleton(new StyledTextReferenceSkeleton(this.styledTextReferenceElement));
        return startGroup;
    }

    private IdGenerator getReferentIdGenerator(String parentId, String prefix) {
        if (null != this.referentIdGenerator) {
            return this.referentIdGenerator;
        }
        return new IdGenerator(parentId, prefix);
    }
}

