/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.GeometryPath;
import net.sf.okapi.filters.idml.MarkupRange;

class Property
extends MarkupRange.MarkupRangeElement {
    Property(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement) {
        super(startElement, innerEvents, endElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        Property that = (Property)o;
        return Objects.equals(this.getStartElement(), that.getStartElement()) && Objects.equals(this.getInnerEvents(), that.getInnerEvents()) && Objects.equals(this.getEndElement(), that.getEndElement());
    }

    public int hashCode() {
        return Objects.hash(this.getStartElement(), this.getInnerEvents(), this.getEndElement());
    }

    static class PathGeometryProperty
    extends Property {
        private final List<GeometryPath> geometryPaths;

        PathGeometryProperty(StartElement startElement, List<GeometryPath> geometryPaths, EndElement endElement) {
            super(startElement, Collections.emptyList(), endElement);
            this.geometryPaths = geometryPaths;
        }

        @Override
        List<XMLEvent> getInnerEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            for (GeometryPath geometryPath : this.geometryPaths) {
                events.addAll(geometryPath.getEvents());
            }
            return events;
        }

        List<GeometryPath> getGeometryPaths() {
            return this.geometryPaths;
        }

        static class PathGeometryPropertyBuilder
        extends PropertyBuilder {
            private List<GeometryPath> geometryPaths = new ArrayList<GeometryPath>();

            PathGeometryPropertyBuilder() {
            }

            PathGeometryPropertyBuilder addGeometryPath(GeometryPath geometryPath) {
                this.geometryPaths.add(geometryPath);
                return this;
            }

            @Override
            public PathGeometryProperty build() {
                return new PathGeometryProperty(this.startElement, this.geometryPaths, this.endElement);
            }
        }
    }

    static class PropertyBuilder
    extends MarkupRange.MarkupRangeElement.MarkupRangeElementBuilder {
        PropertyBuilder() {
        }

        @Override
        public Property build() {
            return new Property(this.startElement, this.innerEvents, this.endElement);
        }
    }
}

