/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Eventive;

class GeometryPath
implements Eventive {
    private final StartElement startElement;
    private final StartElement pathPointArrayStartElement;
    private final List<PathPoint> pathPoints;
    private final EndElement pathPointArrayEndElement;
    private final EndElement endElement;

    GeometryPath(StartElement startElement, StartElement pathPointArrayStartElement, List<PathPoint> pathPoints, EndElement pathPointArrayEndElement, EndElement endElement) {
        this.startElement = startElement;
        this.pathPointArrayStartElement = pathPointArrayStartElement;
        this.pathPoints = pathPoints;
        this.pathPointArrayEndElement = pathPointArrayEndElement;
        this.endElement = endElement;
    }

    StartElement getStartElement() {
        return this.startElement;
    }

    StartElement getPathPointArrayStartElement() {
        return this.pathPointArrayStartElement;
    }

    List<PathPoint> getPathPoints() {
        return this.pathPoints;
    }

    EndElement getPathPointArrayEndElement() {
        return this.pathPointArrayEndElement;
    }

    EndElement getEndElement() {
        return this.endElement;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        for (PathPoint pathPoint : this.pathPoints) {
            events.addAll(pathPoint.getEvents());
        }
        return events;
    }

    static class PathPoint
    implements Eventive {
        private final StartElement startElement;
        private final EndElement endElement;

        PathPoint(StartElement startElement, EndElement endElement) {
            this.startElement = startElement;
            this.endElement = endElement;
        }

        StartElement getStartElement() {
            return this.startElement;
        }

        EndElement getEndElement() {
            return this.endElement;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Arrays.asList(this.startElement, this.endElement);
        }
    }

    static class GeometryPathBuilder
    implements Builder<GeometryPath> {
        private StartElement startElement;
        private StartElement pathPointArrayStartElement;
        private List<PathPoint> pathPoints = new ArrayList<PathPoint>();
        private EndElement pathPointArrayEndElement;
        private EndElement endElement;

        GeometryPathBuilder() {
        }

        GeometryPathBuilder setStartElement(StartElement startElement) {
            this.startElement = startElement;
            return this;
        }

        GeometryPathBuilder setPathPointArrayStartElement(StartElement pathPointArrayStartElement) {
            this.pathPointArrayStartElement = pathPointArrayStartElement;
            return this;
        }

        GeometryPathBuilder addPathPoint(PathPoint pathPoint) {
            this.pathPoints.add(pathPoint);
            return this;
        }

        GeometryPathBuilder setPathPointArrayEndElement(EndElement pathPointArrayEndElement) {
            this.pathPointArrayEndElement = pathPointArrayEndElement;
            return this;
        }

        GeometryPathBuilder setEndElement(EndElement endElement) {
            this.endElement = endElement;
            return this;
        }

        @Override
        public GeometryPath build() {
            return new GeometryPath(this.startElement, this.pathPointArrayStartElement, this.pathPoints, this.pathPointArrayEndElement, this.endElement);
        }
    }
}

