/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.doxygen.DoxygenParameter;
import net.sf.okapi.filters.doxygen.Parameters;

public class DoxygenCommand
implements Iterable<DoxygenParameter> {
    private Map<String, Object> data;
    private String name;
    private String rawCommand;
    private Parameters filterParams;

    public DoxygenCommand(Map<String, Object> data, String commandName, String rawCommand, Parameters filterParams) {
        this.data = data;
        this.name = commandName != null ? commandName : "";
        this.rawCommand = rawCommand != null ? rawCommand : "";
        this.filterParams = filterParams;
    }

    public boolean isInline() {
        Boolean inline = (Boolean)this.data.get("inline");
        return inline != null ? inline : false;
    }

    public TextFragment.TagType getTagType() {
        if (this.isFinalHtmlTag()) {
            return TextFragment.TagType.CLOSING;
        }
        String type = (String)this.data.get("type");
        return type != null ? TextFragment.TagType.valueOf(type) : null;
    }

    public boolean hasParameters() {
        return !this.isFinalHtmlTag() && this.data.get("parameters") != null;
    }

    public boolean hasTranslatableParameters() {
        if (!this.hasParameters()) {
            return false;
        }
        for (DoxygenParameter param : this) {
            if (!param.isTranslatable()) continue;
            return true;
        }
        return false;
    }

    public ParameterIterator iterator() {
        Object params = this.data.get("parameters");
        if (this.isFinalHtmlTag()) {
            params = null;
        }
        return new ParameterIterator((ArrayList)params);
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalName() {
        String pair;
        if (this.getTagType() == TextFragment.TagType.CLOSING && (pair = this.getPair()) != null) {
            return pair;
        }
        return this.name;
    }

    public boolean hasPair() {
        return this.getPair() != null;
    }

    public String getPair() {
        if (this.isHtmlTag()) {
            return this.name;
        }
        return (String)this.data.get("pair");
    }

    public boolean isTranslatable() {
        Boolean translatable = (Boolean)this.data.get("translatable");
        return translatable != null ? translatable : true;
    }

    public boolean isPreserveWhitespace() {
        Boolean preserve = (Boolean)this.data.get("preserve_whitespace");
        return preserve != null ? preserve.booleanValue() : this.filterParams.isPreserveWhitespace();
    }

    private boolean isHtmlTag() {
        return this.rawCommand.startsWith("<");
    }

    private boolean isFinalHtmlTag() {
        return this.rawCommand.startsWith("</");
    }

    public static class ParameterIterator
    implements Iterator<DoxygenParameter> {
        private ArrayList<Map<String, Object>> data;
        private int i = 0;

        public ParameterIterator(ArrayList v) {
            this.data = v;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.data != null && this.i < this.data.size();
        }

        @Override
        public DoxygenParameter next() {
            return new DoxygenParameter(this.data.get(this.i++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            return this.data.size();
        }
    }
}

