/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.connectors.microsoft.TranslateRequest;

class GetTranslationsArrayRequest {
    private String category;
    private List<String> texts;
    private String srcLang;
    private String trgLang;
    private int maxHits;
    private static final String XML_MIME_TYPE = "text/html";

    GetTranslationsArrayRequest(List<String> texts, String srcLang, String trgLang, int maxHits, String category) {
        this.texts = texts;
        this.category = category;
        this.srcLang = srcLang;
        this.trgLang = trgLang;
        this.maxHits = maxHits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof GetTranslationsArrayRequest)) {
            return false;
        }
        GetTranslationsArrayRequest r = (GetTranslationsArrayRequest)o;
        return Objects.equals(this.category, r.category) && Objects.equals(this.texts, r.texts) && Objects.equals(this.srcLang, r.srcLang) && Objects.equals(this.trgLang, r.trgLang) && Objects.equals(this.maxHits, r.maxHits);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.texts, this.srcLang, this.trgLang, this.maxHits);
    }

    @Deprecated
    public String toXML() {
        StringWriter sw = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(sw);
        xmlWriter.writeStartDocument();
        xmlWriter.writeStartElement("GetTranslationsArrayRequest");
        xmlWriter.writeElementString("AppId", "");
        xmlWriter.writeElementString("From", this.srcLang);
        xmlWriter.writeStartElement("Options");
        xmlWriter.writeAttributeString("xmlns:o", "http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2");
        xmlWriter.writeElementString("o:Category", this.category);
        xmlWriter.writeElementString("o:ContentType", XML_MIME_TYPE);
        xmlWriter.writeElementString("o:ReservedFlags", "");
        xmlWriter.writeElementString("o:State", "");
        xmlWriter.writeElementString("o:Uri", "");
        xmlWriter.writeElementString("o:User", "");
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("Texts");
        xmlWriter.writeAttributeString("xmlns:s", "http://schemas.microsoft.com/2003/10/Serialization/Arrays");
        for (String text : this.texts) {
            xmlWriter.writeStartElement("s:string");
            xmlWriter.writeString(text);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        xmlWriter.writeElementString("To", this.trgLang);
        xmlWriter.writeElementString("MaxTranslations", String.valueOf(this.maxHits));
        xmlWriter.writeEndElement();
        xmlWriter.writeEndDocument();
        xmlWriter.close();
        return sw.toString();
    }

    public String toJSON() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<TranslateRequest> translateRequests = new ArrayList<TranslateRequest>();
        for (String text : this.texts) {
            translateRequests.add(new TranslateRequest(text));
        }
        return objectMapper.writeValueAsString(translateRequests);
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (JsonProcessingException e) {
            return "(deserialization error):" + e.toString();
        }
    }

    public int getNumRequests() {
        return this.texts.size();
    }

    public String getText(int index) {
        return this.texts.get(index);
    }
}

