/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.lingo24;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.lingo24.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Lingo24Connector
extends BaseConnector {
    private static final String BASE_URL = "https://api.lingo24.com/mt/v1/translate";
    private static final String BASE_QUERY = "?user_key=%s&source=%s&target=%s";
    private static final String QPARAM = "&q=";
    private Parameters params = new Parameters();
    private JSONParser parser;
    private QueryUtil util = new QueryUtil();

    public Lingo24Connector() {
        this.parser = new JSONParser();
    }

    @Override
    public String getName() {
        return "Lingo24 Premium MT";
    }

    @Override
    public String getSettingsDisplay() {
        return "Lingo24 URL: https://api.lingo24.com/mt/v1/translate";
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment fragment) {
        this.current = -1;
        try {
            if (!fragment.hasText(false)) {
                return 0;
            }
            if (Util.isEmpty(this.params.getUserKey())) {
                throw new OkapiException("You must have a Lingo24 API user_key to use this connector.");
            }
            String qtext = this.util.toCodedHTML(fragment);
            String urlString = BASE_URL + String.format(BASE_QUERY, this.params.getUserKey(), this.srcCode, this.trgCode);
            URL url = new URL(urlString + QPARAM + URLEncoder.encode(qtext, "UTF-8"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new OkapiException(String.format("Error: response code %d\n" + conn.getResponseMessage(), code));
            }
            JSONObject object = (JSONObject)this.parser.parse((Reader)new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            JSONObject map = object;
            if (map.containsKey("errors")) {
                JSONArray errorsArray = (JSONArray)map.get("errors");
                StringBuilder errorsString = new StringBuilder("");
                for (Object entry : errorsArray) {
                    errorsString.append(entry).append("; ");
                }
                throw new OkapiException(String.format("Response from server with errors: %s", errorsString));
            }
            String translation = (String)map.get("translation");
            this.result = new QueryResult();
            this.result.weight = this.getWeight();
            this.result.source = fragment;
            this.result.target = fragment.hasCode() ? new TextFragment(this.util.fromCodedHTML(translation, fragment, true), fragment.getClonedCodes()) : new TextFragment(this.util.fromCodedHTML(translation, fragment, true));
            this.result.setFuzzyScore(95);
            this.result.origin = this.getName();
            this.result.matchType = MatchType.MT;
            this.current = 0;
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the server.\n" + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

