/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;

public class GoogleQueryBuilder<T> {
    private static final int QUERY_LIMIT = 2048;
    private static final String QPARAM = "&q=";
    private StringBuilder sb;
    private String baseUrl;
    private GoogleMTv2Parameters params;
    private final String srcCode;
    private final String tgtCode;
    private List<String> sourceTexts = new ArrayList<String>();
    private List<T> sources = new ArrayList<T>();

    public GoogleQueryBuilder(String baseUrl, GoogleMTv2Parameters params, String srcCode, String tgtCode) {
        this.baseUrl = baseUrl;
        this.params = params;
        this.srcCode = srcCode;
        this.tgtCode = tgtCode;
        this.reset();
    }

    public void reset() {
        this.sb = new StringBuilder(this.baseUrl).append("?key=").append(this.params.getApiKey()).append("&source=").append(this.srcCode).append("&target=").append(this.tgtCode);
        if (this.params.getUsePBMT()) {
            this.sb.append("&model=base");
        }
        this.sourceTexts.clear();
        this.sources.clear();
    }

    public boolean hasCapacity(String sourceText) {
        int additionalLen = QPARAM.length() + Util.URLEncodeUTF8(sourceText).length();
        return this.sb.length() + additionalLen < 2048;
    }

    public void addQuery(String sourceText, T source) {
        if (!this.hasCapacity(sourceText)) {
            throw new IllegalStateException("Query too long to add '" + sourceText + "'");
        }
        this.sb.append(QPARAM).append(Util.URLEncodeUTF8(sourceText));
        this.sourceTexts.add(sourceText);
        this.sources.add(source);
    }

    public List<String> getSourceTexts() {
        return this.sourceTexts;
    }

    public List<T> getSources() {
        return this.sources;
    }

    public int getSourceCount() {
        return this.sourceTexts.size();
    }

    public String getQuery() {
        return this.sb.toString();
    }
}

