/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinedriver;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.BaseContext;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipelinedriver.DocumentData;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.resource.RawDocument;

public class BatchItemContext
extends BaseContext
implements IBatchItemContext {
    private static final int INITIAL_CAPACITY = 2;
    private List<DocumentData> list = new ArrayList<DocumentData>(2);

    public BatchItemContext() {
    }

    public BatchItemContext(RawDocument rawDoc, URI outputURI, String outputEncoding) {
        this();
        this.add(rawDoc, outputURI, outputEncoding);
    }

    public BatchItemContext(RawDocument rawDoc, URI outputURI, String outputEncoding, RawDocument ... rawDocs) {
        this();
        this.add(rawDoc, outputURI, outputEncoding);
        for (RawDocument rd : rawDocs) {
            DocumentData ddi = new DocumentData();
            ddi.rawDocument = rd;
            this.list.add(ddi);
        }
    }

    public BatchItemContext(URI inputURI, String defaultEncoding, String filterConfigId, URI outputURI, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this();
        DocumentData ddi = new DocumentData();
        ddi.rawDocument = new RawDocument(inputURI, defaultEncoding, sourceLocale, targetLocale);
        ddi.rawDocument.setFilterConfigId(filterConfigId);
        ddi.outputURI = outputURI;
        ddi.outputEncoding = outputEncoding;
        this.list.add(ddi);
    }

    public void add(DocumentData data) {
        this.list.add(data);
    }

    public void add(RawDocument rawDoc, URI outputURI, String outputEncoding) {
        DocumentData dd = new DocumentData();
        dd.rawDocument = rawDoc;
        dd.outputURI = outputURI;
        dd.outputEncoding = outputEncoding;
        this.list.add(dd);
    }

    @Override
    public String getFilterConfigurationId(int index) {
        if (this.list.size() <= index) {
            return null;
        }
        return this.list.get((int)index).rawDocument.getFilterConfigId();
    }

    @Override
    public String getOutputEncoding(int index) {
        if (this.list.size() <= index) {
            return null;
        }
        return this.list.get((int)index).outputEncoding;
    }

    @Override
    public URI getOutputURI(int index) {
        if (this.list.size() <= index) {
            return null;
        }
        return this.list.get((int)index).outputURI;
    }

    @Override
    public RawDocument getRawDocument(int index) {
        if (this.list.size() <= index) {
            return null;
        }
        return this.list.get((int)index).rawDocument;
    }

    @Override
    public LocaleId getSourceLocale(int index) {
        if (this.list.size() <= index) {
            return null;
        }
        return this.list.get((int)index).rawDocument.getSourceLocale();
    }

    @Override
    public LocaleId getTargetLocale(int index) {
        if (this.list.size() <= index) {
            return null;
        }
        return this.list.get((int)index).rawDocument.getTargetLocale();
    }
}

