/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.annotations.ConfigurationParameter;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;

public final class StepIntrospector {
    public static List<ConfigurationParameter> getStepParameters(IPipelineStep step) {
        Method[] methods;
        LinkedList<ConfigurationParameter> parameters = new LinkedList<ConfigurationParameter>();
        for (Method m : methods = step.getClass().getMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || !m.isAnnotationPresent(StepParameterMapping.class)) continue;
            StepParameterMapping a = m.getAnnotation(StepParameterMapping.class);
            parameters.add(new ConfigurationParameter(m, a.parameterType(), step));
        }
        return parameters;
    }

    public static List<String> getStepEventHandlers(IPipelineStep step) {
        Method[] methods;
        LinkedList<String> eventHandlers = new LinkedList<String>();
        for (Method m : methods = step.getClass().getDeclaredMethods()) {
            if (!m.getName().startsWith("handle") || m.getParameterTypes().length != 1 || !Arrays.asList(m.getParameterTypes()).contains(Event.class)) continue;
            eventHandlers.add(m.getName());
        }
        if (eventHandlers.size() <= 0) {
            throw new OkapiBadStepInputException("Steps must implement at least one handler method");
        }
        return eventHandlers;
    }
}

