/*===========================================================================
  Copyright (C) 2013 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
============================================================================*/

package net.sf.okapi.common;

/**
 * Defines commonly used namespaces and default prefixes.
 */
public final class Namespaces {

	public static final String XML_NS_URI       = "http://www.w3.org/XML/1998/namespace";
	public static final String XML_NS_PREFIX    = "xml";
	
	public static final String ITS_NS_URI       = "http://www.w3.org/2005/11/its";
	public static final String ITS_NS_PREFIX    = "its";
	
	public static final String ITSXLF_NS_URI    = "http://www.w3.org/ns/its-xliff/";
	public static final String ITSXLF_NS_PREFIX = "itsxlf";

	public static final String ITSX_NS_URI      = "http://www.w3.org/2008/12/its-extensions";
	public static final String ITSX_NS_PREFIX   = "itsx";
	
	public static final String XLINK_NS_URI     = "http://www.w3.org/1999/xlink";
	public static final String XLINK_NS_PREFIX  = "xlink";
	
	public static final String HTML_NS_URI      = "http://www.w3.org/1999/xhtml";
	public static final String HTML_NS_PREFIX   = "h";

	/**
	 * URI for the XLIFF 1.0 namespace.
	 */
	public static final String NS_XLIFF10       = "urn:oasis:names:tc:xliff:document:1.0";

	/**
	 * URI for the XLIFF 1.1 namespace.
	 */
	public static final String NS_XLIFF11       = "urn:oasis:names:tc:xliff:document:1.1";

	/**
	 * URI for the XLIFF 1.2 namespace.
	 */
	public static final String NS_XLIFF12       = "urn:oasis:names:tc:xliff:document:1.2";

	/**
	 * URI for the Okapi XLIFF extensions namespace.
	 */
	public static final String NS_XLIFFOKAPI    = "okapi-framework:xliff-extensions";
	
}
