/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;

public abstract class AbstractChecker {
    public static final Pattern WORDCHARS = Pattern.compile("[\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}\\p{Nd}]");
    public static final Pattern WORDCHARS_NONUMBERS = Pattern.compile("[\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}]");
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private URI currentDocId;
    private String currentSubDocId;
    private Parameters params;
    private List<Issue> issues;
    private List<String> sigList;
    private boolean monolingual;

    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.params = params;
        this.issues = issues;
    }

    public void processStartDocument(StartDocument sd, List<String> sigList) {
        this.currentDocId = new File(sd.getName()).toURI();
        this.sigList = sigList;
        this.monolingual = !sd.isMultilingual();
        this.currentSubDocId = null;
    }

    public void processStartSubDocument(StartSubDocument ssd) {
        this.currentSubDocId = ssd.getName();
        if (this.currentSubDocId == null) {
            this.currentSubDocId = ssd.getId();
        }
    }

    public abstract void processTextUnit(ITextUnit var1);

    public void addAnnotationAndReportIssue(IssueType issueType, ITextUnit tu, TextContainer tc, String segId, String comment, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, String srcOri, String trgOri, List<Code> codes) {
        this.addAnnotationAndReportIssue(issueType, tu, tc, segId, comment, srcStart, srcEnd, trgStart, trgEnd, severity, srcOri, trgOri, codes, null);
    }

    public void addAnnotationAndReportIssue(IssueType issueType, ITextUnit tu, TextContainer tc, String segId, String comment, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, String srcOri, String trgOri, List<Code> codes, String itsType) {
        this.reportIssue(issueType, tu, segId, comment, srcStart, srcEnd, trgStart, trgEnd, severity, srcOri, trgOri, codes);
        this.addAnnotation(tc, segId, issueType, comment, srcStart, srcEnd, trgStart, trgEnd, severity, codes, itsType);
    }

    public void addAnnotation(TextContainer tc, String segId, IssueType issueType, String comment, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, List<Code> codes) {
        IssueAnnotation ann = new IssueAnnotation(issueType, comment, severity, segId, srcStart, srcEnd, trgStart, trgEnd, codes);
        ITSLQIAnnotations.addAnnotations(tc, ann);
    }

    public void addAnnotation(TextContainer tc, String segId, IssueType issueType, String comment, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, List<Code> codes, String itsType) {
        IssueAnnotation ann = new IssueAnnotation(issueType, comment, severity, segId, srcStart, srcEnd, trgStart, trgEnd, codes);
        ITSLQIAnnotations.addAnnotations(tc, ann);
        if (itsType != null) {
            ann.setITSType(itsType);
        }
    }

    public void reportIssue(IssueType issueType, ITextUnit tu, String segId, String message, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, String srcOri, String trgOri, List<Code> codes) {
        Issue issue = new Issue(this.currentDocId, this.currentSubDocId, issueType, tu.getId(), segId, message, srcStart, srcEnd, trgStart, trgEnd, severity, tu.getName());
        issue.setCodes(codes);
        this.issues.add(issue);
        issue.setEnabled(true);
        issue.setSource(srcOri);
        issue.setTarget(trgOri);
        if (this.params != null && this.params.getIncludeTextContainers()) {
            issue.setContainers(tu, this.trgLoc);
        }
        if (this.sigList != null) {
            issue.setEnabled(!this.sigList.contains(issue.getSignature()));
        }
    }

    @Deprecated
    public void reportIssue(Issue init, ITextUnit tu, String srcOri, String trgOri, Object extra) {
        Issue issue = new Issue(this.currentDocId, this.currentSubDocId, init.getIssueType(), tu.getId(), init.getSegId(), init.getMessage(), init.getSourceStart(), init.getSourceEnd(), init.getTargetStart(), init.getTargetEnd(), init.getSeverity(), tu.getName());
        issue.setCodes(init.getCodes());
        this.issues.add(issue);
        issue.setEnabled(true);
        issue.setSource(srcOri);
        issue.setTarget(trgOri);
        if (this.sigList != null) {
            issue.setEnabled(!this.sigList.contains(issue.getSignature()));
        }
    }

    public void setAnnotationIds(TextContainer srcCont, TextContainer trgCont) {
        GenericAnnotations anns = srcCont.getAnnotation(GenericAnnotations.class);
        if (anns != null) {
            anns.setData(Util.makeId(UUID.randomUUID().toString()));
        }
        if ((anns = trgCont.getAnnotation(GenericAnnotations.class)) != null) {
            anns.setData(Util.makeId(UUID.randomUUID().toString()));
        }
    }

    public LocaleId getSrcLoc() {
        return this.srcLoc;
    }

    public LocaleId getTrgLoc() {
        return this.trgLoc;
    }

    public URI getCurrentDocId() {
        return this.currentDocId;
    }

    public String getCurrentSubDocId() {
        return this.currentSubDocId;
    }

    public Parameters getParams() {
        return this.params;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public List<String> getSigList() {
        return this.sigList;
    }

    public boolean isMonolingual() {
        return this.monolingual;
    }
}

