/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transtable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransTableFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String MIMETYPE = "text/x-transtable";
    private BufferedReader reader = null;
    private boolean canceled;
    private String encoding;
    private long line;
    private IdGenerator otherId;
    private String docName;
    private LinkedList<Event> queue;
    private LocaleId trgLoc;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private EncoderManager encoderManager;
    private boolean hasNext;
    private ITextUnit tu;
    private ISegments srcSegs;
    private ISegments trgSegs;
    private String currentTuId;
    private boolean needToRead;
    private String[] parts;
    private String[] ids;
    private RawDocument input;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    @Override
    public String getName() {
        return "okf_transtable";
    }

    @Override
    public String getDisplayName() {
        return "TransTable Filter";
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "Translation Table Default", "Default TransTable configuration."));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
            }
            if (this.queue.size() > 0) {
                return this.queue.poll();
            }
            while (true) {
                String tmp;
                if (this.needToRead) {
                    try {
                        tmp = this.reader.readLine();
                    }
                    catch (IOException e) {
                        throw new OkapiIOException("Error reading the table.", e);
                    }
                    if (tmp == null) {
                        this.hasNext = false;
                        if (this.tu != null) {
                            this.queue.add(new Event(EventType.TEXT_UNIT, this.tu));
                        }
                        Ending ending = new Ending(this.otherId.createId());
                        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                        return this.queue.poll();
                    }
                    ++this.line;
                    if (tmp.trim().length() == 0) continue;
                    this.parts = tmp.split("\t");
                    if (this.parts.length < 2) {
                        throw new OkapiIOException(String.format("Not enough fields in line %d.", this.line));
                    }
                    this.ids = this.parseCrumbs(this.unescape(this.parts[0]));
                }
                this.needToRead = true;
                if (!this.currentTuId.equals(this.ids[0])) {
                    if (this.tu != null) {
                        this.needToRead = false;
                        Event event = new Event(EventType.TEXT_UNIT, this.tu);
                        this.tu = null;
                        this.srcSegs = null;
                        this.trgSegs = null;
                        return event;
                    }
                    this.currentTuId = this.ids[0];
                    this.tu = new TextUnit(this.currentTuId);
                }
                tmp = this.unescape(this.parts[1]);
                TextFragment srcFrag = GenericContent.fromLetterCodedToFragment(tmp, null, false, true);
                if (this.srcSegs == null) {
                    this.srcSegs = this.tu.getSourceSegments();
                }
                if (this.ids[1] == null) {
                    this.ids[1] = "0";
                }
                this.srcSegs.append(new Segment(this.ids[1], srcFrag));
                if (this.parts.length <= 2) continue;
                tmp = this.unescape(this.parts[2]);
                TextFragment trgFrag = GenericContent.fromLetterCodedToFragment(tmp, null, false, true);
                trgFrag.alignCodeIds(srcFrag);
                if (this.trgSegs == null) {
                    this.tu.createTarget(this.trgLoc, false, 0);
                    this.trgSegs = this.tu.getTargetSegments(this.trgLoc);
                }
                this.trgSegs.append(new Segment(this.ids[1], trgFrag));
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException(String.format("Error parsing the table in line %d.", this.line));
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        String tmp;
        this.input = input;
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        this.encoding = input.getEncoding();
        this.reader = null;
        try {
            this.reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.encoding), e);
        }
        this.trgLoc = input.getTargetLocale();
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        this.otherId = new IdGenerator(null);
        this.line = 0L;
        this.hasNext = true;
        this.tu = null;
        this.currentTuId = "";
        this.needToRead = true;
        try {
            tmp = this.reader.readLine();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading header.", e);
        }
        if (Util.isEmpty(tmp)) {
            throw new OkapiIOException("Empty header line.");
        }
        ++this.line;
        String[] parts = tmp.split("\t");
        if (parts.length != 3) {
            throw new OkapiIOException("Unexpected header.");
        }
        parts[0] = this.unescape(parts[0]);
        parts[1] = this.unescape(parts[1]);
        parts[2] = this.unescape(parts[2]);
        if (!parts[0].startsWith("TransTable")) {
            throw new OkapiIOException("Invalid signature. This may not be a TransTable file.");
        }
        LocaleId srcLoc = LocaleId.fromString(parts[1]);
        if (!srcLoc.equals(input.getSourceLocale())) {
            this.logger.warn("The source locale declared in the file ('{}') is not the expected one ('{}')\n{} will be used.", new Object[]{srcLoc.toString(), input.getSourceLocale().toString(), input.getSourceLocale().toString()});
        }
        this.trgLoc = LocaleId.fromString(parts[2]);
        if (input.getTargetLocale() != null && !this.trgLoc.equals(input.getTargetLocale())) {
            this.logger.warn("The target locale declared in the file ('{}') is not the expected one ('{}')\n{} will be used.", new Object[]{this.trgLoc.toString(), input.getTargetLocale().toString(), input.getTargetLocale().toString()});
            this.trgLoc = input.getTargetLocale();
        }
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(this.otherId.createId());
        startDoc.setName(this.docName);
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLocale(input.getSourceLocale());
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setFilterId(this.getName());
        startDoc.setFilterParameters(this.getParameters());
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType(MIMETYPE);
        startDoc.setMimeType(MIMETYPE);
        startDoc.setMultilingual(true);
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
    }

    private String unescape(String text) {
        String tmp = text;
        if (tmp.startsWith("\"")) {
            tmp = tmp.substring(1);
        }
        if (tmp.endsWith("\"")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        tmp = tmp.replace("\\t", "\t");
        tmp = tmp.replace("\\n", "\n");
        return tmp;
    }

    private String[] parseCrumbs(String text) {
        if (!text.startsWith("okpCtx")) {
            throw new OkapiIOException(String.format("Error in ID pattern ('%s'", text));
        }
        int n = text.indexOf("tu=");
        if (n == -1) {
            throw new OkapiIOException(String.format("Error in ID pattern ('%s'", text));
        }
        String tmp = text.substring(n + "tu=".length()).trim();
        if (tmp.isEmpty()) {
            throw new OkapiIOException(String.format("Error in ID pattern ('%s'", text));
        }
        String[] res = new String[2];
        n = tmp.indexOf(58);
        if (n == -1) {
            res[0] = tmp;
        } else {
            res[0] = tmp.substring(0, n);
            res[1] = tmp.substring(n + 1 + "s=".length());
        }
        return res;
    }
}

