/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiUnexpectedRevisionException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface SkippableElements {
    public static final String OPERATION_IS_UNSUPPORTED = "The operation is unsupported.";

    public boolean canBeSkipped(StartElement var1, StartElement var2);

    public boolean canBeSkipped(EndElement var1);

    public void skip(StartElementContext var1) throws XMLStreamException;

    default public void skip(EndElement endElement) {
    }

    public static boolean isValuePresentInContextAwareSkippableElements(StartElement startElement, Map<QName, QName> contextAwareSkippableElements) {
        return contextAwareSkippableElements.containsValue(startElement.getName());
    }

    public static boolean isEntryPresentInContextAwareSkippableElements(StartElement startElement, StartElement parentStartElement, Map<QName, QName> contextAwareSkippableElements) {
        if (null == parentStartElement) {
            return false;
        }
        for (Map.Entry<QName, QName> entry : contextAwareSkippableElements.entrySet()) {
            if (!parentStartElement.getName().equals(entry.getKey()) || !startElement.getName().equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static final class RevisionProperty
    implements SkippableElements {
        private static final QName LOCAL_NUMBERING_PROPERTIES = Namespaces.WordProcessingML.getQName("numPr");
        private static final Map<QName, QName> CONTEXT_AWARE_REVISION_SKIPPABLE_ELEMENTS = new HashMap<QName, QName>();
        private static final Set<QName> REVISION_SKIPPABLE_ELEMENTS = new HashSet<QName>();
        private final Property propertySkippableElements;
        private final ConditionalParameters conditionalParameters;

        RevisionProperty(Property propertySkippableElements, ConditionalParameters conditionalParameters) {
            this.propertySkippableElements = propertySkippableElements;
            this.conditionalParameters = conditionalParameters;
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            if (!this.propertySkippableElements.canBeSkipped(startElement, parentStartElement)) {
                return false;
            }
            return this.conditionalParameters.getAutomaticallyAcceptRevisions() || !SkippableElements.isEntryPresentInContextAwareSkippableElements(startElement, parentStartElement, CONTEXT_AWARE_REVISION_SKIPPABLE_ELEMENTS);
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return this.propertySkippableElements.canBeSkipped(endElement);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            if (!startElementContext.getConditionalParameters().getAutomaticallyAcceptRevisions() && REVISION_SKIPPABLE_ELEMENTS.contains(startElementContext.getStartElement().getName())) {
                throw new OkapiUnexpectedRevisionException();
            }
            this.propertySkippableElements.skip(startElementContext);
        }

        static {
            CONTEXT_AWARE_REVISION_SKIPPABLE_ELEMENTS.put(LOCAL_NUMBERING_PROPERTIES, SkippableElement.RevisionProperty.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK.toName());
            CONTEXT_AWARE_REVISION_SKIPPABLE_ELEMENTS.put(Namespaces.WordProcessingML.getQName("tblPr"), SkippableElement.RevisionProperty.TABLE_PROPERTIES_CHANGE.toName());
            CONTEXT_AWARE_REVISION_SKIPPABLE_ELEMENTS.put(Namespaces.WordProcessingML.getQName("tblGrid"), SkippableElement.RevisionProperty.TABLE_GRID_CHANGE.toName());
            REVISION_SKIPPABLE_ELEMENTS.addAll(SkippableElement.RevisionProperty.toNames());
        }
    }

    public static final class Property
    implements SkippableElements {
        private static final Map<QName, QName> CONTEXT_AWARE_PROPERTY_SKIPPABLE_ELEMENTS = new HashMap<QName, QName>();
        private final Default defaultSkippableElements;

        Property(Default defaultSkippableElements, ConditionalParameters conditionalParameters) {
            this.defaultSkippableElements = defaultSkippableElements;
            if (conditionalParameters.getCleanupAggressively()) {
                this.defaultSkippableElements.add(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_BOLD);
                this.defaultSkippableElements.add(SkippableElement.RunProperty.RUN_PROPERTY_CHARACTER_SPACING);
                this.defaultSkippableElements.add(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_FONT_SIZE);
                this.defaultSkippableElements.add(SkippableElement.RunProperty.RUN_PROPERTY_CHARACTER_WIDTH);
            }
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            if (!this.defaultSkippableElements.canBeSkipped(startElement, parentStartElement)) {
                return false;
            }
            return !SkippableElements.isValuePresentInContextAwareSkippableElements(startElement, CONTEXT_AWARE_PROPERTY_SKIPPABLE_ELEMENTS) || SkippableElements.isEntryPresentInContextAwareSkippableElements(startElement, parentStartElement, CONTEXT_AWARE_PROPERTY_SKIPPABLE_ELEMENTS);
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            throw new UnsupportedOperationException(SkippableElements.OPERATION_IS_UNSUPPORTED);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            this.defaultSkippableElements.skip(startElementContext);
        }

        static {
            CONTEXT_AWARE_PROPERTY_SKIPPABLE_ELEMENTS.put(Namespaces.WordProcessingML.getQName("rPr"), SkippableElement.RunProperty.RUN_PROPERTY_CHARACTER_SPACING.toName());
        }
    }

    public static final class MoveFromRevisionCrossStructure
    implements SkippableElements {
        private final RevisionCrossStructure revisionCrossStructureSkippableElements;
        private final String structureName;
        private boolean structureCrossed;

        MoveFromRevisionCrossStructure(RevisionCrossStructure revisionCrossStructureSkippableElements, String structureName) {
            this.revisionCrossStructureSkippableElements = revisionCrossStructureSkippableElements;
            this.structureName = structureName;
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return this.revisionCrossStructureSkippableElements.canBeSkipped(startElement, parentStartElement);
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return this.revisionCrossStructureSkippableElements.canBeSkipped(endElement);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            this.revisionCrossStructureSkippableElements.skip(startElementContext);
            while (startElementContext.getEventReader().hasNext()) {
                XMLEvent e = startElementContext.getEventReader().nextEvent();
                if (e.isEndElement() && this.structureName.equals(e.asEndElement().getName().getLocalPart())) {
                    this.structureCrossed = true;
                }
                if (e.isStartElement() && this.structureName.equals(e.asStartElement().getName().getLocalPart())) {
                    this.structureCrossed = false;
                }
                if (!e.isStartElement() || !this.revisionCrossStructureSkippableElements.crossStructureSkippableElements.endSkippableElementName.equals(e.asStartElement().getName())) continue;
                this.revisionCrossStructureSkippableElements.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), startElementContext));
                return;
            }
            throw new IllegalStateException("Unexpected structure");
        }

        boolean isStructureCrossed() {
            return this.structureCrossed;
        }
    }

    public static final class RevisionCrossStructure
    implements SkippableElements {
        private static final Set<QName> REVISION_SKIPPABLE_ELEMENTS = new HashSet<QName>();
        private final CrossStructure crossStructureSkippableElements;

        RevisionCrossStructure(CrossStructure crossStructureSkippableElements) {
            this.crossStructureSkippableElements = crossStructureSkippableElements;
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return this.crossStructureSkippableElements.canBeSkipped(startElement, parentStartElement);
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return this.crossStructureSkippableElements.canBeSkipped(endElement);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            if (!startElementContext.getConditionalParameters().getAutomaticallyAcceptRevisions() && REVISION_SKIPPABLE_ELEMENTS.contains(startElementContext.getStartElement().getName())) {
                throw new OkapiUnexpectedRevisionException();
            }
            this.crossStructureSkippableElements.skip(startElementContext);
        }

        static {
            REVISION_SKIPPABLE_ELEMENTS.addAll(SkippableElement.RevisionCrossStructure.toNames());
        }
    }

    public static final class BookmarkCrossStructure
    implements SkippableElements {
        static final String SKIPPABLE_BOOKMARK_NAME = "_GoBack";
        private final CrossStructure crossStructureSkippableElements;
        private final String bookmarkName;

        BookmarkCrossStructure(CrossStructure crossStructureSkippableElements, String bookmarkName) {
            this.crossStructureSkippableElements = crossStructureSkippableElements;
            this.bookmarkName = bookmarkName;
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return this.crossStructureSkippableElements.startSkippableElementName.equals(startElement.getName()) && this.bookmarkName.equals(XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_NAME)) || this.crossStructureSkippableElements.endSkippableElementName.equals(startElement.getName()) && Objects.equals(this.crossStructureSkippableElements.identifier, XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_ID));
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return this.crossStructureSkippableElements.canBeSkipped(endElement);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            this.crossStructureSkippableElements.skip(startElementContext);
        }
    }

    public static final class CrossStructure
    implements SkippableElements {
        private static final int SUPPORTED_NUMBER_OF_SKIPPABLE_ELEMENTS = 2;
        private static final String START_SUFFIX = "Start";
        private static final String END_SUFFIX = "End";
        private final Default defaultSkippableElements;
        private final QName startSkippableElementName;
        private final QName endSkippableElementName;
        private String identifier;

        CrossStructure(Default defaultSkippableElements) {
            if (2 != defaultSkippableElements.skippableElementNames.size()) {
                throw new IllegalArgumentException(String.format("The provided number of skippable elements is invalid: '%d'. It must be equal to '%d'.", defaultSkippableElements.skippableElementNames.size(), 2));
            }
            this.defaultSkippableElements = defaultSkippableElements;
            Iterator namesIterator = defaultSkippableElements.skippableElementNames.iterator();
            this.startSkippableElementName = (QName)namesIterator.next();
            if (!this.startSkippableElementName.getLocalPart().endsWith(START_SUFFIX)) {
                throw new IllegalArgumentException(String.format("The start skippable element is invalid: '%s'. It must end with '%s'", this.startSkippableElementName, START_SUFFIX));
            }
            this.endSkippableElementName = (QName)namesIterator.next();
            if (!this.endSkippableElementName.getLocalPart().endsWith(END_SUFFIX)) {
                throw new IllegalArgumentException(String.format("The end skippable element is invalid: '%s'. It must end with '%s'.", this.endSkippableElementName, END_SUFFIX));
            }
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return this.startSkippableElementName.equals(startElement.getName()) || this.endSkippableElementName.equals(startElement.getName()) && Objects.equals(this.identifier, XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_ID));
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            throw new UnsupportedOperationException(SkippableElements.OPERATION_IS_UNSUPPORTED);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            this.defaultSkippableElements.skip(startElementContext);
            this.identifier = this.startSkippableElementName.equals(startElementContext.getStartElement().getName()) ? XMLEventHelpers.getAttributeValue(startElementContext.getStartElement(), XMLEventHelpers.WPML_ID) : null;
        }
    }

    public static final class RevisionInline
    implements SkippableElements {
        private static final Set<QName> REVISION_SKIPPABLE_ELEMENTS = new HashSet<QName>();
        private final Inline inlineSkippableElements;

        RevisionInline(Inline inlineSkippableElements) {
            this.inlineSkippableElements = inlineSkippableElements;
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return this.inlineSkippableElements.canBeSkipped(startElement, parentStartElement);
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return this.inlineSkippableElements.canBeSkipped(endElement);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            if (!startElementContext.getConditionalParameters().getAutomaticallyAcceptRevisions() && REVISION_SKIPPABLE_ELEMENTS.contains(startElementContext.getStartElement().getName())) {
                throw new OkapiUnexpectedRevisionException();
            }
            if (SkippableElement.RevisionInline.RUN_INSERTED_CONTENT.toName().equals(startElementContext.getStartElement().getName()) || SkippableElement.RevisionInline.RUN_MOVED_CONTENT_TO.toName().equals(startElementContext.getStartElement().getName())) {
                return;
            }
            this.inlineSkippableElements.skip(startElementContext);
        }

        static {
            REVISION_SKIPPABLE_ELEMENTS.addAll(SkippableElement.RevisionInline.toNames());
        }
    }

    public static final class Inline
    implements SkippableElements {
        private final Default defaultSkippableElements;

        Inline(Default defaultSkippableElements) {
            this.defaultSkippableElements = defaultSkippableElements;
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return this.defaultSkippableElements.canBeSkipped(startElement, parentStartElement);
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return this.defaultSkippableElements.canBeSkipped(endElement);
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            this.defaultSkippableElements.skip(startElementContext);
        }
    }

    public static final class Default
    implements SkippableElements {
        private final Set<QName> skippableElementNames;

        Default(SkippableElement ... skippableElements) {
            this.skippableElementNames = Arrays.stream(skippableElements).map(SkippableElement::toName).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return this.skippableElementNames.contains(startElement.getName());
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return this.skippableElementNames.contains(endElement.getName());
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
            while (startElementContext.getEventReader().hasNext()) {
                XMLEvent e = startElementContext.getEventReader().nextEvent();
                if (!XMLEventHelpers.isEndElement(e, startElementContext.getStartElement())) continue;
                return;
            }
            throw new IllegalStateException("Unexpected structure");
        }

        void add(SkippableElement skippableElement) {
            this.skippableElementNames.add(skippableElement.toName());
        }
    }

    public static final class Empty
    implements SkippableElements {
        @Override
        public boolean canBeSkipped(StartElement startElement, StartElement parentStartElement) {
            return false;
        }

        @Override
        public boolean canBeSkipped(EndElement endElement) {
            return false;
        }

        @Override
        public void skip(StartElementContext startElementContext) throws XMLStreamException {
        }
    }
}

