/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringsDenormalizer;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemParser;
import net.sf.okapi.filters.openxml.StringItemTextUnitMapper;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPartHandler;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class SharedStringsPartHandler
extends StyledTextPartHandler {
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final SharedStringMap sharedStringMap;
    private int sharedStringIndex = 0;

    SharedStringsPartHandler(ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, EncoderManager encoderManager, IFilter subfilter, SharedStringMap sharedStringMap) {
        super(cparams, zipFile, entry, styleDefinitions, styleOptimisation);
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.sharedStringMap = sharedStringMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event open(String documentId, String subDocumentId, LocaleId sourceLocale) throws IOException, XMLStreamException {
        this.documentId = documentId;
        this.subDocumentId = subDocumentId;
        this.sourceLocale = sourceLocale;
        SharedStringsDenormalizer deno = new SharedStringsDenormalizer(this.zipFile.getEventFactory(), this.sharedStringMap);
        XMLEventReader reader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8));
        File rewrittenStringsTable = File.createTempFile("sharedStrings", ".xml");
        XMLEventWriter writer = this.zipFile.getOutputFactory().createXMLEventWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rewrittenStringsTable), StandardCharsets.UTF_8));
        deno.process(reader, writer);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(rewrittenStringsTable));
        this.eventReader = XMLInputFactory.newInstance().createXMLEventReader(is);
        try {
            this.process();
        }
        finally {
            if (this.eventReader != null) {
                this.eventReader.close();
            }
            rewrittenStringsTable.delete();
        }
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    private void process() throws XMLStreamException {
        XMLEvent e = null;
        while (this.eventReader.hasNext()) {
            e = this.eventReader.nextEvent();
            if (XMLEventHelpers.isStringItemStartEvent(e) && this.sharedStringMap.isStringVisible(this.sharedStringIndex++)) {
                this.flushDocumentPart();
                StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.eventReader, this.zipFile.getEventFactory(), this.params);
                StringItem stringItem = new StringItemParser(startElementContext, this.nestedBlockId, this.styleDefinitions, this.styleOptimisation).parse();
                String cell = this.sharedStringMap.getStringCell(this.sharedStringIndex - 1);
                String worksheet = this.sharedStringMap.getStringWorksheet(this.sharedStringIndex - 1);
                List<ITextUnit> textUnits = new StringItemTextUnitMapper(stringItem, this.textUnitId, cell, worksheet).map();
                if (textUnits.isEmpty()) {
                    this.addBlockChunksToDocumentPart(stringItem.getChunks());
                    continue;
                }
                if (this.subfilter != null && !stringItem.isStyled()) {
                    this.addSubfilteredEvents(textUnits);
                    continue;
                }
                this.addTextUnitEvents(textUnits);
                continue;
            }
            this.addEventToDocumentPart(e);
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private void addTextUnitEvents(List<ITextUnit> textUnits) {
        for (ITextUnit tu : textUnits) {
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
        }
    }

    private void addSubfilteredEvents(List<ITextUnit> textUnits) {
        int subfilterIndex = 0;
        for (ITextUnit tu : textUnits) {
            SubFilter sf = new SubFilter(this.subfilter, this.encoderManager.getEncoder(), ++subfilterIndex, tu.getId(), tu.getName());
            Throwable throwable = null;
            try {
                this.filterEvents.addAll(sf.getEvents(new RawDocument(tu.getSource().getFirstContent().getText(), this.sourceLocale)));
                this.filterEvents.add(sf.createRefEvent(tu));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sf == null) continue;
                if (throwable != null) {
                    try {
                        sf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sf.close();
            }
        }
    }
}

