/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SharedStringMap {
    private ArrayList<Entry> entries = new ArrayList();
    private int nextIndex = 0;

    public Entry createEntryForString(int origIndex, boolean excluded) {
        Entry e = new Entry(origIndex, this.nextIndex++, excluded, null, null);
        this.entries.ensureCapacity(this.nextIndex);
        this.entries.add(e.newIndex, e);
        return e;
    }

    public Entry createEntryForString(int origIndex, boolean excluded, String cell, String worksheet) {
        Entry e = new Entry(origIndex, this.nextIndex++, excluded, cell, worksheet);
        this.entries.ensureCapacity(this.nextIndex);
        this.entries.add(e.newIndex, e);
        return e;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean isStringVisible(int index) {
        return !this.entries.get(index).excluded;
    }

    public String getStringCell(int index) {
        return this.entries.get(index).getCell();
    }

    public String getStringWorksheet(int index) {
        return this.entries.get(index).getWorksheet();
    }

    public static class Entry {
        private int origIndex;
        private int newIndex;
        private boolean excluded;
        private String cell;
        private String worksheet;

        Entry(int origIndex, int newIndex, boolean excluded) {
            this.origIndex = origIndex;
            this.newIndex = newIndex;
            this.excluded = excluded;
        }

        Entry(int origIndex, int newIndex, boolean excluded, String cell, String worksheet) {
            this.origIndex = origIndex;
            this.newIndex = newIndex;
            this.excluded = excluded;
            this.cell = cell;
            this.worksheet = worksheet;
        }

        public int getOriginalIndex() {
            return this.origIndex;
        }

        public int getNewIndex() {
            return this.newIndex;
        }

        public boolean getExcluded() {
            return this.excluded;
        }

        public String getCell() {
            return this.cell;
        }

        public String getWorksheet() {
            return this.worksheet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.origIndex == e.origIndex && this.newIndex == e.newIndex && this.excluded == e.excluded;
        }

        public int hashCode() {
            return Objects.hash(this.origIndex, this.newIndex, this.excluded);
        }

        public String toString() {
            return "SS Entry(" + this.origIndex + " --> " + this.newIndex + ", " + (this.excluded ? "excluded" : "visible") + ", " + this.cell + ", " + this.worksheet + ")";
        }
    }
}

