/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Eventive;
import net.sf.okapi.filters.idml.Property;

class Properties
implements Eventive {
    private final StartElement startElement;
    private final List<Property> properties;
    private final EndElement endElement;

    Properties(StartElement startElement, List<Property> properties, EndElement endElement) {
        this.startElement = startElement;
        this.properties = properties;
        this.endElement = endElement;
    }

    static Properties getEmptyProperties() {
        return new EmptyProperties();
    }

    static Property.PathGeometryProperty getPathGeometryProperty(List<Property> properties) {
        for (Property property : properties) {
            if (!(property instanceof Property.PathGeometryProperty)) continue;
            return (Property.PathGeometryProperty)property;
        }
        return null;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startElement);
        for (Property property : this.properties) {
            events.addAll(property.getEvents());
        }
        events.add(this.endElement);
        return events;
    }

    StartElement getStartElement() {
        return this.startElement;
    }

    List<Property> getProperties() {
        return this.properties;
    }

    EndElement getEndElement() {
        return this.endElement;
    }

    boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        Properties that = (Properties)o;
        return Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getProperties());
    }

    static class EmptyProperties
    extends Properties {
        EmptyProperties() {
            super(null, Collections.emptyList(), null);
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }
    }

    static class PropertiesBuilder
    implements Builder<Properties> {
        private StartElement startElement;
        private List<Property> properties = new ArrayList<Property>();
        private EndElement endElement;

        PropertiesBuilder() {
        }

        PropertiesBuilder setStartElement(StartElement startElement) {
            this.startElement = startElement;
            return this;
        }

        PropertiesBuilder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }

        PropertiesBuilder addProperties(List<Property> properties) {
            this.properties.addAll(properties);
            return this;
        }

        PropertiesBuilder setEndElement(EndElement endElement) {
            this.endElement = endElement;
            return this;
        }

        @Override
        public Properties build() {
            return new Properties(this.startElement, this.properties, this.endElement);
        }
    }
}

