/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.Document;
import net.sf.okapi.filters.idml.IDMLFilterWriter;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.SubDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class IDMLFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String START_DOCUMENT_ID = "sd";
    private static final String END_DOCUMENT_ID = "ed";
    static final String MIME_TYPE = "application/vnd.adobe.indesign-idml-package";
    static final String FILTER_ID = "okf_idml";
    private Parameters params = new Parameters();
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private NextAction nextAction;
    private RawDocument rawDocument;
    private EncoderManager encoderManager;
    private File tempFile;
    private URI documentUri;
    private Document document;
    private SubDocument subDocument;
    private LinkedList<Event> queue;

    public IDMLFilter() {
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        if (this.inputFactory.isPropertySupported("com.ctc.wstx.maxAttributeSize")) {
            this.inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", this.params.getMaxAttributeSize());
        }
    }

    @Override
    public void close() {
        if (this.rawDocument != null) {
            this.rawDocument.close();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        try {
            this.nextAction = NextAction.DONE;
            if (this.document != null) {
                this.document.close();
                this.document = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zipped output file.");
        }
        if (this.subDocument != null) {
            this.subDocument.close();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new IDMLFilterWriter(this.params, this.outputFactory, this.eventFactory);
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getName() {
        return FILTER_ID;
    }

    @Override
    public String getDisplayName() {
        return "IDML Filter";
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIME_TYPE, this.getClass().getName(), "IDML", "Adobe InDesign IDML documents", null, ".idml;"));
        return list;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null && !this.queue.isEmpty() || this.nextAction != NextAction.DONE;
    }

    @Override
    public Event next() {
        if (this.queue == null) {
            return null;
        }
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        try {
            switch (this.nextAction) {
                case OPEN_DOCUMENT: {
                    return this.openDocument();
                }
                case NEXT_IN_DOCUMENT: {
                    return this.nextInDocument();
                }
                case NEXT_IN_SUB_DOCUMENT: {
                    Event e = this.nextInSubDocument();
                    if (e != null) {
                        return e;
                    }
                    this.nextAction = NextAction.NEXT_IN_DOCUMENT;
                    return this.next();
                }
            }
            throw new OkapiException("Invalid next() call.");
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiException("An error occurred during extraction", e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument rawDocument, boolean generateSkeleton) {
        if (rawDocument == null) {
            throw new OkapiException("RawDocument is null");
        }
        this.rawDocument = rawDocument;
        if (rawDocument.getInputURI() != null) {
            this.open(rawDocument.getInputURI());
            this.logger.debug("\nOpening {}", (Object)rawDocument.getInputURI().toString());
        } else if (rawDocument.getStream() != null) {
            this.open(rawDocument.getStream());
        } else {
            throw new OkapiException("InputResource has no input defined.");
        }
    }

    void open(InputStream input) {
        this.tempFile = FileUtil.createTempFile("~okapi-23_IDMLFilter_");
        StreamUtil.copy(input, this.tempFile);
        this.open(Util.toURI(this.tempFile.getAbsolutePath()));
    }

    void open(URI inputURI) {
        this.documentUri = inputURI;
        this.nextAction = NextAction.OPEN_DOCUMENT;
        this.queue = new LinkedList();
        this.logger.debug("\nOpening {}", (Object)inputURI.toString());
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    private Event openDocument() {
        try {
            this.document = new Document(this.params, this.inputFactory, this.eventFactory);
            this.nextAction = NextAction.NEXT_IN_DOCUMENT;
            return this.document.open(START_DOCUMENT_ID, this.documentUri, this.rawDocument.getSourceLocale(), this.rawDocument.getEncoding(), this.createFilterWriter());
        }
        catch (ZipException e) {
            throw new OkapiIOException("Error opening zipped input file.");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading zipped input file.", e);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Error parsing XML content", e);
        }
    }

    private Event nextInDocument() throws IOException, XMLStreamException {
        if (this.document.hasNextSubDocument()) {
            this.subDocument = this.document.nextSubDocument();
            this.nextAction = NextAction.NEXT_IN_SUB_DOCUMENT;
            return this.subDocument.open();
        }
        this.close();
        Ending ending = new Ending(END_DOCUMENT_ID);
        return new Event(EventType.END_DOCUMENT, ending);
    }

    private Event nextInSubDocument() {
        if (this.subDocument.hasNextEvent()) {
            Event event = this.subDocument.nextEvent();
            switch (event.getEventType()) {
                case END_DOCUMENT: {
                    Ending ending = new Ending(this.subDocument.getId());
                    this.nextAction = NextAction.NEXT_IN_DOCUMENT;
                    ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.subDocument.getZipFile(), this.subDocument.getZipEntry());
                    this.subDocument.close();
                    return new Event(EventType.END_SUBDOCUMENT, ending, skel);
                }
            }
            this.subDocument.logEvent(event);
            return event;
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    private static enum NextAction {
        OPEN_DOCUMENT,
        NEXT_IN_DOCUMENT,
        NEXT_IN_SUB_DOCUMENT,
        DONE;

    }
}

