/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class DTDEncoder
implements IEncoder {
    private CharsetEncoder chsEnc;
    private String lineBreak;
    private String encoding;

    @Override
    public void reset() {
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.lineBreak = lineBreak;
        this.encoding = encoding;
        this.chsEnc = "utf-8".equalsIgnoreCase(encoding) || "utf-16".equalsIgnoreCase(encoding) ? null : Charset.forName(encoding).newEncoder();
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        StringBuilder sbTmp = new StringBuilder(text.length());
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sbTmp.append("&lt;");
                    continue block7;
                }
                case '&': {
                    sbTmp.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sbTmp.append("&quot;");
                    continue block7;
                }
                case '%': {
                    sbTmp.append("&#37;");
                    continue block7;
                }
                case '\n': {
                    sbTmp.append(this.lineBreak);
                    continue block7;
                }
                default: {
                    if (ch > '\u007f') {
                        if (Character.isHighSurrogate(ch)) {
                            int cp = text.codePointAt(i++);
                            String tmp = new String(Character.toChars(cp));
                            if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                                sbTmp.append(String.format("&#x%x;", cp));
                                continue block7;
                            }
                            sbTmp.append(tmp);
                            continue block7;
                        }
                        if (this.chsEnc != null && !this.chsEnc.canEncode(ch)) {
                            sbTmp.append(String.format("&#x%04x;", ch));
                            continue block7;
                        }
                        sbTmp.append(ch);
                        continue block7;
                    }
                    sbTmp.append(ch);
                }
            }
        }
        return sbTmp.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        switch (value) {
            case '<': {
                return "&lt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '%': {
                return "&#37;";
            }
            case '&': {
                return "&amp;";
            }
            case '\n': {
                return this.lineBreak;
            }
        }
        if (value > '\u007f') {
            if (this.chsEnc != null && !this.chsEnc.canEncode(value)) {
                return String.format("&#x%04x;", value);
            }
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        switch (value) {
            case 60: {
                return "&lt;";
            }
            case 34: {
                return "&quot;";
            }
            case 37: {
                return "&#37;";
            }
            case 38: {
                return "&amp;";
            }
            case 62: {
                return "&gt;";
            }
            case 10: {
                return this.lineBreak;
            }
        }
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                String tmp = new String(Character.toChars(value));
                if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                    return String.format("&#x%x;", value);
                }
                return tmp;
            }
            if (this.chsEnc != null && !this.chsEnc.canEncode((char)value)) {
                return String.format("&#x%04x;", value);
            }
            return String.valueOf((char)value);
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }
}

