/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.unitils.core.UnitilsException;
import org.unitils.database.config.DatabaseConfiguration;

public class DatabaseConfigurations {
    protected DatabaseConfiguration defaultDatabaseConfiguration;
    protected Map<String, DatabaseConfiguration> databaseConfigurations;

    public DatabaseConfigurations(DatabaseConfiguration defaultDatabaseConfiguration, Map<String, DatabaseConfiguration> databaseConfigurations) {
        this.defaultDatabaseConfiguration = defaultDatabaseConfiguration;
        this.databaseConfigurations = databaseConfigurations;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.defaultDatabaseConfiguration;
    }

    public DatabaseConfiguration getDatabaseConfiguration(String databaseName) {
        if (StringUtils.isBlank((CharSequence)databaseName)) {
            return this.defaultDatabaseConfiguration;
        }
        DatabaseConfiguration databaseConfiguration = this.getOptionalDatabaseConfiguration(databaseName);
        if (databaseConfiguration == null) {
            throw new UnitilsException("No configuration found for database with name '" + databaseName + "'");
        }
        return databaseConfiguration;
    }

    public DatabaseConfiguration getOptionalDatabaseConfiguration(String databaseName) {
        return this.databaseConfigurations.get(databaseName);
    }

    public List<String> getDatabaseNames() {
        return new ArrayList<String>(this.databaseConfigurations.keySet());
    }

    public List<DatabaseConfiguration> getDatabaseConfigurations() {
        return new ArrayList<DatabaseConfiguration>(this.databaseConfigurations.values());
    }
}

